/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.event.transport.netty.channel;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.util.concurrent.BlockingQueue;
import org.apache.nifi.event.transport.message.ByteArrayMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class ByteArrayMessageChannelHandler
extends SimpleChannelInboundHandler<ByteArrayMessage> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ByteArrayMessageChannelHandler.class);
    private final BlockingQueue<ByteArrayMessage> messages;

    public ByteArrayMessageChannelHandler(BlockingQueue<ByteArrayMessage> messages) {
        this.messages = messages;
    }

    protected void channelRead0(ChannelHandlerContext channelHandlerContext, ByteArrayMessage message) {
        LOGGER.debug("Message Received Length [{}] Remote Address [{}] ", (Object)message.getMessage().length, (Object)message.getSender());
        this.messages.add(message);
    }
}

