/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.event.transport.netty.channel.ssl;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.ssl.SslHandler;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.apache.nifi.event.transport.netty.channel.StandardChannelInitializer;
import org.apache.nifi.security.util.ClientAuth;

public class ServerSslHandlerChannelInitializer<T extends Channel>
extends StandardChannelInitializer<T> {
    private final SSLContext sslContext;
    private final ClientAuth clientAuth;
    private final SSLParameters sslParameters;

    public ServerSslHandlerChannelInitializer(Supplier<List<ChannelHandler>> handlerSupplier, SSLContext sslContext, ClientAuth clientAuth, SSLParameters sslParameters) {
        super(handlerSupplier);
        this.sslContext = Objects.requireNonNull(sslContext, "SSLContext is required");
        this.clientAuth = Objects.requireNonNull(clientAuth, "ClientAuth is required");
        this.sslParameters = Objects.requireNonNull(sslParameters, "SSLParameters is required");
    }

    @Override
    protected void initChannel(Channel channel) {
        ChannelPipeline pipeline = channel.pipeline();
        pipeline.addLast(new ChannelHandler[]{this.newSslHandler()});
        super.initChannel(channel);
    }

    private SslHandler newSslHandler() {
        SSLEngine sslEngine = this.sslContext.createSSLEngine();
        sslEngine.setSSLParameters(this.sslParameters);
        sslEngine.setUseClientMode(false);
        if (ClientAuth.REQUIRED.equals((Object)this.clientAuth)) {
            sslEngine.setNeedClientAuth(true);
        } else if (ClientAuth.WANT.equals((Object)this.clientAuth)) {
            sslEngine.setWantClientAuth(true);
        }
        return new SslHandler(sslEngine);
    }
}

