/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.nifi.attribute.expression.language.CompiledExpression;
import org.apache.nifi.attribute.expression.language.EvaluationContext;
import org.apache.nifi.attribute.expression.language.Expression;
import org.apache.nifi.attribute.expression.language.NamedVariableImpact;
import org.apache.nifi.attribute.expression.language.PreparedQuery;
import org.apache.nifi.attribute.expression.language.StandardEvaluationContext;
import org.apache.nifi.attribute.expression.language.VariableImpact;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.literals.StringLiteralEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.selection.AllAttributesEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.selection.AnyAttributeEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.selection.AttributeEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.selection.MappingEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.selection.MultiAttributeEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.selection.MultiMatchAttributeEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.selection.MultiNamedAttributeEvaluator;
import org.apache.nifi.expression.AttributeValueDecorator;
import org.apache.nifi.processor.exception.ProcessException;

public class StandardPreparedQuery
implements PreparedQuery {
    private static final String EMPTY_STRING = "";
    private final List<Expression> expressions;
    private volatile VariableImpact variableImpact;

    public StandardPreparedQuery(List<Expression> expressions) {
        this.expressions = expressions;
    }

    @Override
    public String evaluateExpressions(EvaluationContext evaluationContext, AttributeValueDecorator decorator) throws ProcessException {
        if (this.expressions.isEmpty()) {
            return EMPTY_STRING;
        }
        if (this.expressions.size() == 1) {
            String evaluated = this.expressions.get(0).evaluate(evaluationContext, decorator);
            return evaluated == null ? EMPTY_STRING : evaluated;
        }
        StringBuilder sb = new StringBuilder();
        for (Expression expression : this.expressions) {
            String evaluated = expression.evaluate(evaluationContext, decorator);
            if (evaluated == null) continue;
            sb.append(evaluated);
        }
        return sb.toString();
    }

    @Override
    public boolean isExpressionLanguagePresent() {
        for (Expression expression : this.expressions) {
            if (!(expression instanceof CompiledExpression)) continue;
            return true;
        }
        return false;
    }

    @Override
    public VariableImpact getVariableImpact() {
        VariableImpact existing = this.variableImpact;
        if (existing != null) {
            return existing;
        }
        HashSet<String> variables = new HashSet<String>();
        for (Expression expression : this.expressions) {
            if (!(expression instanceof CompiledExpression)) continue;
            CompiledExpression compiled = (CompiledExpression)expression;
            for (Evaluator<?> evaluator : compiled.getAllEvaluators()) {
                MultiAttributeEvaluator iteratingEval;
                Evaluator<Boolean> allAttrsEval;
                if (evaluator instanceof AttributeEvaluator) {
                    AttributeEvaluator attributeEval = (AttributeEvaluator)evaluator;
                    Evaluator<String> nameEval = attributeEval.getNameEvaluator();
                    if (!(nameEval instanceof StringLiteralEvaluator)) continue;
                    String referencedVar = nameEval.evaluate(new StandardEvaluationContext(Collections.emptyMap())).getValue();
                    variables.add(referencedVar);
                    continue;
                }
                if (evaluator instanceof AllAttributesEvaluator) {
                    allAttrsEval = (AllAttributesEvaluator)evaluator;
                    iteratingEval = ((AllAttributesEvaluator)allAttrsEval).getVariableIteratingEvaluator();
                    if (iteratingEval instanceof MultiNamedAttributeEvaluator) {
                        variables.addAll(((MultiNamedAttributeEvaluator)iteratingEval).getAttributeNames());
                        continue;
                    }
                    if (!(iteratingEval instanceof MultiMatchAttributeEvaluator)) continue;
                    return VariableImpact.ALWAYS_IMPACTED;
                }
                if (evaluator instanceof AnyAttributeEvaluator) {
                    allAttrsEval = (AnyAttributeEvaluator)evaluator;
                    iteratingEval = ((AnyAttributeEvaluator)allAttrsEval).getVariableIteratingEvaluator();
                    if (iteratingEval instanceof MultiNamedAttributeEvaluator) {
                        variables.addAll(((MultiNamedAttributeEvaluator)iteratingEval).getAttributeNames());
                        continue;
                    }
                    if (!(iteratingEval instanceof MultiMatchAttributeEvaluator)) continue;
                    return VariableImpact.ALWAYS_IMPACTED;
                }
                if (!(evaluator instanceof MappingEvaluator) || !((iteratingEval = ((MappingEvaluator)(allAttrsEval = (MappingEvaluator)evaluator)).getVariableIteratingEvaluator()) instanceof MultiNamedAttributeEvaluator)) continue;
                variables.addAll(((MultiNamedAttributeEvaluator)iteratingEval).getAttributeNames());
            }
        }
        NamedVariableImpact impact = new NamedVariableImpact(variables);
        this.variableImpact = impact;
        return impact;
    }
}

