/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language.compile;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.Tree;
import org.apache.nifi.attribute.expression.language.CompiledExpression;
import org.apache.nifi.attribute.expression.language.Query;
import org.apache.nifi.attribute.expression.language.StandardEvaluationContext;
import org.apache.nifi.attribute.expression.language.antlr.AttributeExpressionLexer;
import org.apache.nifi.attribute.expression.language.antlr.AttributeExpressionParser;
import org.apache.nifi.attribute.expression.language.evaluation.BooleanEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.DateEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.DecimalEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.NumberEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.StringEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.WholeNumberEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.cast.BooleanCastEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.cast.DateCastEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.cast.DecimalCastEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.cast.NumberCastEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.cast.StringCastEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.cast.WholeNumberCastEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.AndEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.AppendEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.Base64DecodeEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.Base64EncodeEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.CharSequenceTranslatorEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.ContainsEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.DivideEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.EndsWithEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.EqualsEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.EqualsIgnoreCaseEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.EvaluateELStringEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.FindEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.FormatEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.FromRadixEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.GetDelimitedFieldEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.GetStateVariableEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.GreaterThanEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.GreaterThanOrEqualEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.HashEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.HostnameEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.IPEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.IfElseEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.InEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.IndexOfEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.IsEmptyEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.IsNullEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.JsonPathAddEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.JsonPathDeleteEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.JsonPathEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.JsonPathPutEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.JsonPathSetEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.LastIndexOfEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.LengthEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.LessThanEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.LessThanOrEqualEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.MatchesEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.MathEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.MinusEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.ModEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.MultiplyEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.NotEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.NotNullEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.NowEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.NumberToDateEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.OneUpSequenceEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.OrEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.PadLeftEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.PadRightEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.PlusEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.PrependEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.RandomNumberGeneratorEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.RepeatEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.ReplaceAllEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.ReplaceEmptyEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.ReplaceEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.ReplaceFirstEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.ReplaceNullEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.StartsWithEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.StringToDateEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.SubstringAfterEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.SubstringAfterLastEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.SubstringBeforeEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.SubstringBeforeLastEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.SubstringEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.ThreadEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.ToLowerEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.ToRadixEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.ToStringEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.ToUpperEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.TrimEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.UrlDecodeEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.UrlEncodeEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.Uuid3Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.Uuid5Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.UuidEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.literals.BooleanLiteralEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.literals.DecimalLiteralEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.literals.StringLiteralEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.literals.ToLiteralEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.literals.WholeNumberLiteralEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.reduce.CountEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.reduce.JoinEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.reduce.ReduceEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.selection.AllAttributesEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.selection.AnyAttributeEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.selection.AttributeEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.selection.DelineatedAttributeEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.selection.IteratingEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.selection.MappingEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.selection.MultiAttributeEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.selection.MultiMatchAttributeEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.selection.MultiNamedAttributeEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.selection.ParameterEvaluator;
import org.apache.nifi.attribute.expression.language.exception.AttributeExpressionLanguageException;
import org.apache.nifi.attribute.expression.language.exception.AttributeExpressionLanguageParsingException;
import org.apache.nifi.expression.AttributeExpression;
import org.apache.nifi.flowfile.FlowFile;

public class ExpressionCompiler {
    private final Set<Evaluator<?>> evaluators = new HashSet();

    public CompiledExpression compile(String expression) {
        try {
            ANTLRStringStream input = new ANTLRStringStream(expression);
            AttributeExpressionLexer lexer = new AttributeExpressionLexer((CharStream)input);
            CommonTokenStream lexerTokenStream = new CommonTokenStream((TokenSource)lexer);
            AttributeExpressionParser parser = new AttributeExpressionParser((TokenStream)lexerTokenStream);
            Tree ast = (Tree)parser.query().getTree();
            Tree tree = ast.getChild(0);
            Evaluator<?> evaluator = this.buildEvaluator(tree);
            this.verifyMappingEvaluatorReduced(evaluator);
            HashSet allEvaluators = new HashSet(this.evaluators);
            this.evaluators.clear();
            return new CompiledExpression(expression, evaluator, tree, allEvaluators);
        }
        catch (AttributeExpressionLanguageParsingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AttributeExpressionLanguageParsingException(e);
        }
    }

    private Tree compileTree(String expression) throws AttributeExpressionLanguageParsingException {
        try {
            ANTLRStringStream input = new ANTLRStringStream(expression);
            AttributeExpressionLexer lexer = new AttributeExpressionLexer((CharStream)input);
            CommonTokenStream lexerTokenStream = new CommonTokenStream((TokenSource)lexer);
            AttributeExpressionParser parser = new AttributeExpressionParser((TokenStream)lexerTokenStream);
            Tree ast = (Tree)parser.query().getTree();
            Tree tree = ast.getChild(0);
            Evaluator<?> evaluator = this.buildEvaluator(tree);
            this.verifyMappingEvaluatorReduced(evaluator);
            return tree;
        }
        catch (AttributeExpressionLanguageParsingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AttributeExpressionLanguageParsingException(e);
        }
    }

    private void verifyMappingEvaluatorReduced(Evaluator<?> evaluator) {
        Evaluator<?> rightMostEvaluator = evaluator instanceof IteratingEvaluator ? ((IteratingEvaluator)evaluator).getLogicEvaluator() : evaluator;
        Evaluator<?> lastEval = rightMostEvaluator;
        for (Evaluator<?> eval = rightMostEvaluator.getSubjectEvaluator(); eval != null; eval = eval.getSubjectEvaluator()) {
            if (eval instanceof ReduceEvaluator) {
                throw new AttributeExpressionLanguageParsingException("Expression attempts to call function '" + lastEval.getToken() + "' on the result of '" + eval.getToken() + "'. This is not allowed. Instead, use \"${literal( ${<embedded expression>} ):" + lastEval.getToken() + "(...)}\"");
            }
            lastEval = eval;
        }
        AttributeExpression.ResultType resultType = evaluator.getResultType();
        if (resultType == AttributeExpression.ResultType.BOOLEAN) {
            return;
        }
        Evaluator<?> rootEvaluator = this.getRootSubjectEvaluator(evaluator);
        if (rootEvaluator instanceof MultiAttributeEvaluator) {
            MultiAttributeEvaluator multiAttrEval = (MultiAttributeEvaluator)rootEvaluator;
            switch (multiAttrEval.getEvaluationType()) {
                case 4: 
                case 5: 
                case 6: {
                    if (evaluator instanceof ReduceEvaluator) break;
                    throw new AttributeExpressionLanguageParsingException("Cannot evaluate expression because it attempts to reference multiple attributes but does not use a reducing function");
                }
                default: {
                    throw new AttributeExpressionLanguageParsingException("Cannot evaluate expression because it attempts to reference multiple attributes but does not use a reducing function");
                }
            }
        }
    }

    private Evaluator<?> getRootSubjectEvaluator(Evaluator<?> evaluator) {
        if (evaluator == null) {
            return null;
        }
        Evaluator<?> subject = evaluator.getSubjectEvaluator();
        if (subject == null) {
            return evaluator;
        }
        return this.getRootSubjectEvaluator(subject);
    }

    private Evaluator<?> buildExpressionEvaluator(Tree tree) {
        if (tree.getChildCount() == 0) {
            throw new AttributeExpressionLanguageParsingException("EXPRESSION tree node has no children");
        }
        Evaluator<Boolean> evaluator = tree.getChildCount() == 1 ? this.buildEvaluator(tree.getChild(0)) : this.buildFunctionExpressionEvaluator(tree, 0);
        Evaluator<Boolean> chosenEvaluator = evaluator;
        Evaluator<?> rootEvaluator = this.getRootSubjectEvaluator(evaluator);
        if (rootEvaluator != null && rootEvaluator instanceof MultiAttributeEvaluator) {
            MultiAttributeEvaluator multiAttrEval = (MultiAttributeEvaluator)rootEvaluator;
            switch (multiAttrEval.getEvaluationType()) {
                case 8: 
                case 9: 
                case 10: {
                    chosenEvaluator = new AnyAttributeEvaluator((BooleanEvaluator)evaluator, multiAttrEval);
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    AttributeExpression.ResultType resultType = evaluator.getResultType();
                    if (resultType == AttributeExpression.ResultType.BOOLEAN) {
                        chosenEvaluator = new AllAttributesEvaluator((BooleanEvaluator)evaluator, multiAttrEval);
                        break;
                    }
                    if (evaluator instanceof ReduceEvaluator) {
                        chosenEvaluator = new MappingEvaluator((ReduceEvaluator)evaluator, multiAttrEval);
                        break;
                    }
                    throw new AttributeExpressionLanguageException("Cannot evaluate Expression because it attempts to reference multiple attributes but does not use a reducing function");
                }
            }
            this.evaluators.add(chosenEvaluator);
            switch (multiAttrEval.getEvaluationType()) {
                case 8: {
                    chosenEvaluator.setToken("anyAttribute");
                    break;
                }
                case 10: {
                    chosenEvaluator.setToken("anyMatchingAttribute");
                    break;
                }
                case 9: {
                    chosenEvaluator.setToken("anyDelineatedValue");
                    break;
                }
                case 4: {
                    chosenEvaluator.setToken("allAttributes");
                    break;
                }
                case 6: {
                    chosenEvaluator.setToken("allMatchingAttributes");
                    break;
                }
                case 5: {
                    chosenEvaluator.setToken("allDelineatedValues");
                }
            }
        }
        return chosenEvaluator;
    }

    private Evaluator<?> buildFunctionExpressionEvaluator(Tree tree, int offset) {
        if (tree.getChildCount() == 0) {
            throw new AttributeExpressionLanguageParsingException("EXPRESSION tree node has no children");
        }
        int firstChildIndex = tree.getChildCount() - offset - 1;
        if (firstChildIndex == 0) {
            return this.buildEvaluator(tree.getChild(0));
        }
        Tree functionTree = tree.getChild(firstChildIndex);
        Evaluator<?> subjectEvaluator = this.buildFunctionExpressionEvaluator(tree, offset + 1);
        Tree functionNameTree = functionTree.getChild(0);
        ArrayList argEvaluators = new ArrayList();
        for (int i = 1; i < functionTree.getChildCount(); ++i) {
            argEvaluators.add(this.buildEvaluator(functionTree.getChild(i)));
        }
        return this.buildFunctionEvaluator(functionNameTree, subjectEvaluator, argEvaluators);
    }

    private List<Evaluator<?>> verifyArgCount(List<Evaluator<?>> args, int count, String functionName) {
        if (args.size() != count) {
            throw new AttributeExpressionLanguageParsingException(functionName + "() function takes " + count + " arguments");
        }
        return args;
    }

    private Evaluator<String> toStringEvaluator(Evaluator<?> evaluator) {
        return this.toStringEvaluator(evaluator, null);
    }

    private Evaluator<String> toStringEvaluator(Evaluator<?> evaluator, String location) {
        if (evaluator.getResultType() == AttributeExpression.ResultType.STRING) {
            return (StringEvaluator)evaluator;
        }
        return this.addToken(new StringCastEvaluator(evaluator), evaluator.getToken());
    }

    private Evaluator<Boolean> toBooleanEvaluator(Evaluator<?> evaluator, String location) {
        switch (evaluator.getResultType()) {
            case BOOLEAN: {
                return evaluator;
            }
            case STRING: {
                return this.addToken(new BooleanCastEvaluator((StringEvaluator)evaluator), evaluator.getToken());
            }
        }
        throw new AttributeExpressionLanguageParsingException("Cannot implicitly convert Data Type " + evaluator.getResultType() + " to " + AttributeExpression.ResultType.BOOLEAN + (location == null ? "" : " at location [" + location + "]"));
    }

    private Evaluator<Boolean> toBooleanEvaluator(Evaluator<?> evaluator) {
        return this.toBooleanEvaluator(evaluator, null);
    }

    private Evaluator<Long> toWholeNumberEvaluator(Evaluator<?> evaluator) {
        return this.toWholeNumberEvaluator(evaluator, null);
    }

    private Evaluator<Long> toWholeNumberEvaluator(Evaluator<?> evaluator, String location) {
        switch (evaluator.getResultType()) {
            case WHOLE_NUMBER: {
                return evaluator;
            }
            case STRING: 
            case DATE: 
            case DECIMAL: 
            case NUMBER: {
                return this.addToken(new WholeNumberCastEvaluator(evaluator), evaluator.getToken());
            }
        }
        throw new AttributeExpressionLanguageParsingException("Cannot implicitly convert Data Type " + evaluator.getResultType() + " to " + AttributeExpression.ResultType.WHOLE_NUMBER + (location == null ? "" : " at location [" + location + "]"));
    }

    private Evaluator<Double> toDecimalEvaluator(Evaluator<?> evaluator) {
        return this.toDecimalEvaluator(evaluator, null);
    }

    private Evaluator<Double> toDecimalEvaluator(Evaluator<?> evaluator, String location) {
        switch (evaluator.getResultType()) {
            case DECIMAL: {
                return evaluator;
            }
            case STRING: 
            case WHOLE_NUMBER: 
            case DATE: 
            case NUMBER: {
                return this.addToken(new DecimalCastEvaluator(evaluator), evaluator.getToken());
            }
        }
        throw new AttributeExpressionLanguageParsingException("Cannot implicitly convert Data Type " + evaluator.getResultType() + " to " + AttributeExpression.ResultType.DECIMAL + (location == null ? "" : " at location [" + location + "]"));
    }

    private Evaluator<Number> toNumberEvaluator(Evaluator<?> evaluator) {
        return this.toNumberEvaluator(evaluator, null);
    }

    private Evaluator<Number> toNumberEvaluator(Evaluator<?> evaluator, String location) {
        switch (evaluator.getResultType()) {
            case NUMBER: {
                return evaluator;
            }
            case STRING: 
            case WHOLE_NUMBER: 
            case DATE: 
            case DECIMAL: {
                return this.addToken(new NumberCastEvaluator(evaluator), evaluator.getToken());
            }
        }
        throw new AttributeExpressionLanguageParsingException("Cannot implicitly convert Data Type " + evaluator.getResultType() + " to " + AttributeExpression.ResultType.WHOLE_NUMBER + (location == null ? "" : " at location [" + location + "]"));
    }

    private DateEvaluator toDateEvaluator(Evaluator<?> evaluator) {
        return this.toDateEvaluator(evaluator, null);
    }

    private DateEvaluator toDateEvaluator(Evaluator<?> evaluator, String location) {
        if (evaluator.getResultType() == AttributeExpression.ResultType.DATE) {
            return (DateEvaluator)evaluator;
        }
        return new DateCastEvaluator(evaluator);
    }

    private Evaluator<?> buildFunctionEvaluator(Tree tree, Evaluator<?> subjectEvaluator, List<Evaluator<?>> argEvaluators) {
        switch (tree.getType()) {
            case 105: {
                this.verifyArgCount(argEvaluators, 0, "trim");
                return this.addToken(new TrimEvaluator(this.toStringEvaluator(subjectEvaluator)), "trim");
            }
            case 103: {
                this.verifyArgCount(argEvaluators, 0, "toString");
                return this.addToken(new ToStringEvaluator(subjectEvaluator), "toString");
            }
            case 100: {
                this.verifyArgCount(argEvaluators, 0, "toLower");
                return this.addToken(new ToLowerEvaluator(this.toStringEvaluator(subjectEvaluator)), "toLower");
            }
            case 104: {
                this.verifyArgCount(argEvaluators, 0, "toUpper");
                return this.addToken(new ToUpperEvaluator(this.toStringEvaluator(subjectEvaluator)), "toUpper");
            }
            case 33: {
                this.verifyArgCount(argEvaluators, 0, "evaluateELString");
                return this.addToken(new EvaluateELStringEvaluator(this.toStringEvaluator(subjectEvaluator)), "evaluateELString");
            }
            case 113: {
                this.verifyArgCount(argEvaluators, 0, "urlEncode");
                return this.addToken(new UrlEncodeEvaluator(this.toStringEvaluator(subjectEvaluator)), "urlEncode");
            }
            case 112: {
                this.verifyArgCount(argEvaluators, 0, "urlDecode");
                return this.addToken(new UrlDecodeEvaluator(this.toStringEvaluator(subjectEvaluator)), "urlDecode");
            }
            case 14: {
                this.verifyArgCount(argEvaluators, 0, "base64Encode");
                return this.addToken(new Base64EncodeEvaluator(this.toStringEvaluator(subjectEvaluator)), "base64Encode");
            }
            case 13: {
                this.verifyArgCount(argEvaluators, 0, "base64Decode");
                return this.addToken(new Base64DecodeEvaluator(this.toStringEvaluator(subjectEvaluator)), "base64Decode");
            }
            case 28: {
                this.verifyArgCount(argEvaluators, 0, "escapeCsv");
                return this.addToken(CharSequenceTranslatorEvaluator.csvEscapeEvaluator(this.toStringEvaluator(subjectEvaluator)), "escapeCsv");
            }
            case 29: {
                this.verifyArgCount(argEvaluators, 0, "escapeHtml3");
                return this.addToken(CharSequenceTranslatorEvaluator.html3EscapeEvaluator(this.toStringEvaluator(subjectEvaluator)), "escapeHtml3");
            }
            case 30: {
                this.verifyArgCount(argEvaluators, 0, "escapeHtml4");
                return this.addToken(CharSequenceTranslatorEvaluator.html4EscapeEvaluator(this.toStringEvaluator(subjectEvaluator)), "escapeHtml4");
            }
            case 31: {
                this.verifyArgCount(argEvaluators, 0, "escapeJson");
                return this.addToken(CharSequenceTranslatorEvaluator.jsonEscapeEvaluator(this.toStringEvaluator(subjectEvaluator)), "escapeJson");
            }
            case 32: {
                this.verifyArgCount(argEvaluators, 0, "escapeXml");
                return this.addToken(CharSequenceTranslatorEvaluator.xmlEscapeEvaluator(this.toStringEvaluator(subjectEvaluator)), "escapeXml");
            }
            case 107: {
                this.verifyArgCount(argEvaluators, 0, "unescapeCsv");
                return this.addToken(CharSequenceTranslatorEvaluator.csvUnescapeEvaluator(this.toStringEvaluator(subjectEvaluator)), "unescapeCsv");
            }
            case 108: {
                this.verifyArgCount(argEvaluators, 0, "unescapeHtml3");
                return this.addToken(CharSequenceTranslatorEvaluator.html3UnescapeEvaluator(this.toStringEvaluator(subjectEvaluator)), "unescapeHtml3");
            }
            case 109: {
                this.verifyArgCount(argEvaluators, 0, "unescapeHtml4");
                return this.addToken(CharSequenceTranslatorEvaluator.html4UnescapeEvaluator(this.toStringEvaluator(subjectEvaluator)), "unescapeHtml4");
            }
            case 110: {
                this.verifyArgCount(argEvaluators, 0, "unescapeJson");
                return this.addToken(CharSequenceTranslatorEvaluator.jsonUnescapeEvaluator(this.toStringEvaluator(subjectEvaluator)), "unescapeJson");
            }
            case 111: {
                this.verifyArgCount(argEvaluators, 0, "unescapeXml");
                return this.addToken(CharSequenceTranslatorEvaluator.xmlUnescapeEvaluator(this.toStringEvaluator(subjectEvaluator)), "unescapeXml");
            }
            case 94: {
                this.verifyArgCount(argEvaluators, 1, "substringBefore");
                return this.addToken(new SubstringBeforeEvaluator(this.toStringEvaluator(subjectEvaluator), this.toStringEvaluator(argEvaluators.get(0), "first argument to substringBefore")), "substringBefore");
            }
            case 95: {
                this.verifyArgCount(argEvaluators, 1, "substringBeforeLast");
                return this.addToken(new SubstringBeforeLastEvaluator(this.toStringEvaluator(subjectEvaluator), this.toStringEvaluator(argEvaluators.get(0), "first argument to substringBeforeLast")), "substringBeforeLast");
            }
            case 92: {
                this.verifyArgCount(argEvaluators, 1, "substringAfter");
                return this.addToken(new SubstringAfterEvaluator(this.toStringEvaluator(subjectEvaluator), this.toStringEvaluator(argEvaluators.get(0), "first argument to substringAfter")), "substringAfter");
            }
            case 93: {
                this.verifyArgCount(argEvaluators, 1, "substringAfterLast");
                return this.addToken(new SubstringAfterLastEvaluator(this.toStringEvaluator(subjectEvaluator), this.toStringEvaluator(argEvaluators.get(0), "first argument to substringAfterLast")), "substringAfterLast");
            }
            case 86: {
                this.verifyArgCount(argEvaluators, 1, "replaceNull");
                return this.addToken(new ReplaceNullEvaluator(this.toStringEvaluator(subjectEvaluator), this.toStringEvaluator(argEvaluators.get(0), "first argument to replaceNull")), "replaceNull");
            }
            case 84: {
                this.verifyArgCount(argEvaluators, 1, "replaceEmtpy");
                return this.addToken(new ReplaceEmptyEvaluator(this.toStringEvaluator(subjectEvaluator), this.toStringEvaluator(argEvaluators.get(0), "first argument to replaceEmpty")), "replaceEmpty");
            }
            case 82: {
                this.verifyArgCount(argEvaluators, 2, "replace");
                return this.addToken(new ReplaceEvaluator(this.toStringEvaluator(subjectEvaluator), this.toStringEvaluator(argEvaluators.get(0), "first argument to replace"), this.toStringEvaluator(argEvaluators.get(1), "second argument to replace")), "replace");
            }
            case 85: {
                this.verifyArgCount(argEvaluators, 2, "replaceFirst");
                return this.addToken(new ReplaceFirstEvaluator(this.toStringEvaluator(subjectEvaluator), this.toStringEvaluator(argEvaluators.get(0), "first argument to replaceFirst"), this.toStringEvaluator(argEvaluators.get(1), "second argument to replaceFirst")), "replaceFirst");
            }
            case 83: {
                this.verifyArgCount(argEvaluators, 2, "replaceAll");
                return this.addToken(new ReplaceAllEvaluator(this.toStringEvaluator(subjectEvaluator), this.toStringEvaluator(argEvaluators.get(0), "first argument to replaceAll"), this.toStringEvaluator(argEvaluators.get(1), "second argument to replaceAll")), "replaceAll");
            }
            case 43: {
                this.verifyArgCount(argEvaluators, 1, "hash");
                return this.addToken(new HashEvaluator(this.toStringEvaluator(subjectEvaluator), this.toStringEvaluator(argEvaluators.get(0), "first argument to hash")), "hash");
            }
            case 74: {
                if (argEvaluators.size() == 1) {
                    return this.addToken(new PadLeftEvaluator(this.toStringEvaluator(subjectEvaluator), this.toWholeNumberEvaluator(argEvaluators.get(0), "desired string length")), "padLeft");
                }
                return this.addToken(new PadLeftEvaluator(this.toStringEvaluator(subjectEvaluator), this.toWholeNumberEvaluator(argEvaluators.get(0), "desired string length"), this.toStringEvaluator(argEvaluators.get(1), "padding string")), "padLeft");
            }
            case 75: {
                if (argEvaluators.size() == 1) {
                    return this.addToken(new PadRightEvaluator(this.toStringEvaluator(subjectEvaluator), this.toWholeNumberEvaluator(argEvaluators.get(0), "desired string length")), "padRight");
                }
                return this.addToken(new PadRightEvaluator(this.toStringEvaluator(subjectEvaluator), this.toWholeNumberEvaluator(argEvaluators.get(0), "desired string length"), this.toStringEvaluator(argEvaluators.get(1), "padding string")), "padRight");
            }
            case 11: {
                this.verifyArgCount(argEvaluators, 1, "append");
                return this.addToken(new AppendEvaluator(this.toStringEvaluator(subjectEvaluator), this.toStringEvaluator(argEvaluators.get(0), "first argument to append")), "append");
            }
            case 78: {
                this.verifyArgCount(argEvaluators, 1, "prepend");
                return this.addToken(new PrependEvaluator(this.toStringEvaluator(subjectEvaluator), this.toStringEvaluator(argEvaluators.get(0), "first argument to prepend")), "prepend");
            }
            case 91: {
                int numArgs = argEvaluators.size();
                if (numArgs == 1) {
                    return this.addToken(new SubstringEvaluator(this.toStringEvaluator(subjectEvaluator), this.toWholeNumberEvaluator(argEvaluators.get(0), "first argument to substring")), "substring");
                }
                if (numArgs == 2) {
                    return this.addToken(new SubstringEvaluator(this.toStringEvaluator(subjectEvaluator), this.toWholeNumberEvaluator(argEvaluators.get(0), "first argument to substring"), this.toWholeNumberEvaluator(argEvaluators.get(1), "second argument to substring")), "substring");
                }
                throw new AttributeExpressionLanguageParsingException("substring() function can take either 1 or 2 arguments but cannot take " + numArgs + " arguments");
            }
            case 81: {
                int numArgs = argEvaluators.size();
                if (numArgs == 1) {
                    return this.addToken(new RepeatEvaluator(this.toStringEvaluator(subjectEvaluator), this.toWholeNumberEvaluator(argEvaluators.get(0), "first argument to repeat")), "repeat");
                }
                if (numArgs == 2) {
                    return this.addToken(new RepeatEvaluator(this.toStringEvaluator(subjectEvaluator), this.toWholeNumberEvaluator(argEvaluators.get(0), "first argument to repeat"), this.toWholeNumberEvaluator(argEvaluators.get(1), "second argument to repeat")), "repeat");
                }
                throw new AttributeExpressionLanguageParsingException("repeat() function can take either 1 or 2 arguments but cannot take " + numArgs + " arguments");
            }
            case 51: {
                this.verifyArgCount(argEvaluators, 1, "join");
                return this.addToken(new JoinEvaluator(this.toStringEvaluator(subjectEvaluator), this.toStringEvaluator(argEvaluators.get(0))), "join");
            }
            case 19: {
                this.verifyArgCount(argEvaluators, 0, "count");
                return this.addToken(new CountEvaluator(subjectEvaluator), "count");
            }
            case 50: {
                this.verifyArgCount(argEvaluators, 0, "isNull");
                return this.addToken(new IsNullEvaluator(this.toStringEvaluator(subjectEvaluator)), "isNull");
            }
            case 49: {
                this.verifyArgCount(argEvaluators, 0, "isEmpty");
                return this.addToken(new IsEmptyEvaluator(this.toStringEvaluator(subjectEvaluator)), "isEmpty");
            }
            case 70: {
                this.verifyArgCount(argEvaluators, 0, "notNull");
                return this.addToken(new NotNullEvaluator(this.toStringEvaluator(subjectEvaluator)), "notNull");
            }
            case 89: {
                this.verifyArgCount(argEvaluators, 1, "startsWith");
                return this.addToken(new StartsWithEvaluator(this.toStringEvaluator(subjectEvaluator), this.toStringEvaluator(argEvaluators.get(0), "first argument to startsWith")), "startsWith");
            }
            case 24: {
                this.verifyArgCount(argEvaluators, 1, "endsWith");
                return this.addToken(new EndsWithEvaluator(this.toStringEvaluator(subjectEvaluator), this.toStringEvaluator(argEvaluators.get(0), "first argument to endsWith")), "endsWith");
            }
            case 18: {
                this.verifyArgCount(argEvaluators, 1, "contains");
                return this.addToken(new ContainsEvaluator(this.toStringEvaluator(subjectEvaluator), this.toStringEvaluator(argEvaluators.get(0), "first argument to contains")), "contains");
            }
            case 46: {
                ArrayList<Evaluator<String>> list = new ArrayList<Evaluator<String>>();
                for (int i = 0; i < argEvaluators.size(); ++i) {
                    list.add(this.toStringEvaluator(argEvaluators.get(i), i + "th argument to in"));
                }
                return this.addToken(new InEvaluator(this.toStringEvaluator(subjectEvaluator), list), "in");
            }
            case 36: {
                this.verifyArgCount(argEvaluators, 1, "find");
                return this.addToken(new FindEvaluator(this.toStringEvaluator(subjectEvaluator), this.toStringEvaluator(argEvaluators.get(0), "first argument to find")), "find");
            }
            case 63: {
                this.verifyArgCount(argEvaluators, 1, "matches");
                return this.addToken(new MatchesEvaluator(this.toStringEvaluator(subjectEvaluator), this.toStringEvaluator(argEvaluators.get(0), "first argument to matches")), "matches");
            }
            case 25: {
                this.verifyArgCount(argEvaluators, 1, "equals");
                return this.addToken(new EqualsEvaluator(subjectEvaluator, argEvaluators.get(0)), "equals");
            }
            case 26: {
                this.verifyArgCount(argEvaluators, 1, "equalsIgnoreCase");
                return this.addToken(new EqualsIgnoreCaseEvaluator(this.toStringEvaluator(subjectEvaluator), this.toStringEvaluator(argEvaluators.get(0), "first argument to equalsIgnoreCase")), "equalsIgnoreCase");
            }
            case 41: {
                this.verifyArgCount(argEvaluators, 1, "gt");
                return this.addToken(new GreaterThanEvaluator(this.toNumberEvaluator(subjectEvaluator), this.toNumberEvaluator(argEvaluators.get(0), "first argument to gt")), "gt");
            }
            case 42: {
                this.verifyArgCount(argEvaluators, 1, "ge");
                return this.addToken(new GreaterThanOrEqualEvaluator(this.toNumberEvaluator(subjectEvaluator), this.toNumberEvaluator(argEvaluators.get(0), "first argument to ge")), "ge");
            }
            case 60: {
                this.verifyArgCount(argEvaluators, 1, "lt");
                return this.addToken(new LessThanEvaluator(this.toNumberEvaluator(subjectEvaluator), this.toNumberEvaluator(argEvaluators.get(0), "first argument to lt")), "lt");
            }
            case 61: {
                this.verifyArgCount(argEvaluators, 1, "le");
                return this.addToken(new LessThanOrEqualEvaluator(this.toNumberEvaluator(subjectEvaluator), this.toNumberEvaluator(argEvaluators.get(0), "first argument to le")), "le");
            }
            case 59: {
                this.verifyArgCount(argEvaluators, 0, "length");
                return this.addToken(new LengthEvaluator(this.toStringEvaluator(subjectEvaluator)), "length");
            }
            case 97: {
                if (argEvaluators.isEmpty()) {
                    return this.addToken(new NumberToDateEvaluator(this.toWholeNumberEvaluator(subjectEvaluator)), "toDate");
                }
                if (subjectEvaluator.getResultType() == AttributeExpression.ResultType.STRING && argEvaluators.size() == 1) {
                    return this.addToken(new StringToDateEvaluator(this.toStringEvaluator(subjectEvaluator), this.toStringEvaluator(argEvaluators.get(0)), null), "toDate");
                }
                if (subjectEvaluator.getResultType() == AttributeExpression.ResultType.STRING && argEvaluators.size() == 2) {
                    return this.addToken(new StringToDateEvaluator(this.toStringEvaluator(subjectEvaluator), this.toStringEvaluator(argEvaluators.get(0)), this.toStringEvaluator(argEvaluators.get(1))), "toDate");
                }
                return this.addToken(new NumberToDateEvaluator(this.toWholeNumberEvaluator(subjectEvaluator)), "toDate");
            }
            case 101: {
                this.verifyArgCount(argEvaluators, 0, "toNumber");
                switch (subjectEvaluator.getResultType()) {
                    case STRING: 
                    case WHOLE_NUMBER: 
                    case DATE: 
                    case DECIMAL: 
                    case NUMBER: {
                        return this.addToken(this.toWholeNumberEvaluator(subjectEvaluator), "toNumber");
                    }
                }
                throw new AttributeExpressionLanguageParsingException(subjectEvaluator + " returns type " + subjectEvaluator.getResultType() + " but expected to get " + AttributeExpression.ResultType.STRING + ", " + AttributeExpression.ResultType.DECIMAL + ", or " + AttributeExpression.ResultType.DATE);
            }
            case 98: {
                this.verifyArgCount(argEvaluators, 0, "toDecimal");
                switch (subjectEvaluator.getResultType()) {
                    case STRING: 
                    case WHOLE_NUMBER: 
                    case DATE: 
                    case DECIMAL: 
                    case NUMBER: {
                        return this.addToken(this.toDecimalEvaluator(subjectEvaluator), "toDecimal");
                    }
                }
                throw new AttributeExpressionLanguageParsingException(subjectEvaluator + " returns type " + subjectEvaluator.getResultType() + " but expected to get " + AttributeExpression.ResultType.STRING + ", " + AttributeExpression.ResultType.WHOLE_NUMBER + ", or " + AttributeExpression.ResultType.DATE);
            }
            case 102: {
                if (argEvaluators.size() == 1) {
                    return this.addToken(new ToRadixEvaluator(this.toWholeNumberEvaluator(subjectEvaluator), this.toWholeNumberEvaluator(argEvaluators.get(0))), "toRadix");
                }
                return this.addToken(new ToRadixEvaluator(this.toWholeNumberEvaluator(subjectEvaluator), this.toWholeNumberEvaluator(argEvaluators.get(0)), this.toWholeNumberEvaluator(argEvaluators.get(1))), "toRadix");
            }
            case 38: {
                return this.addToken(new FromRadixEvaluator(this.toStringEvaluator(subjectEvaluator), this.toWholeNumberEvaluator(argEvaluators.get(0))), "fromRadix");
            }
            case 66: {
                return this.addToken(new ModEvaluator(this.toNumberEvaluator(subjectEvaluator), this.toNumberEvaluator(argEvaluators.get(0))), "mod");
            }
            case 77: {
                return this.addToken(new PlusEvaluator(this.toNumberEvaluator(subjectEvaluator), this.toNumberEvaluator(argEvaluators.get(0))), "plus");
            }
            case 65: {
                return this.addToken(new MinusEvaluator(this.toNumberEvaluator(subjectEvaluator), this.toNumberEvaluator(argEvaluators.get(0))), "minus");
            }
            case 67: {
                return this.addToken(new MultiplyEvaluator(this.toNumberEvaluator(subjectEvaluator), this.toNumberEvaluator(argEvaluators.get(0))), "multiply");
            }
            case 21: {
                return this.addToken(new DivideEvaluator(this.toNumberEvaluator(subjectEvaluator), this.toNumberEvaluator(argEvaluators.get(0))), "divide");
            }
            case 64: {
                if (argEvaluators.size() == 1) {
                    return this.addToken(new MathEvaluator(this.toNumberEvaluator(subjectEvaluator), this.toStringEvaluator(argEvaluators.get(0)), null), "math");
                }
                if (argEvaluators.size() == 2) {
                    return this.addToken(new MathEvaluator(this.toNumberEvaluator(subjectEvaluator), this.toStringEvaluator(argEvaluators.get(0)), this.toNumberEvaluator(argEvaluators.get(1))), "math");
                }
                throw new AttributeExpressionLanguageParsingException("math() function takes 1 or 2 arguments");
            }
            case 79: {
                return this.addToken(new RandomNumberGeneratorEvaluator(), "random");
            }
            case 47: {
                this.verifyArgCount(argEvaluators, 1, "indexOf");
                return this.addToken(new IndexOfEvaluator(this.toStringEvaluator(subjectEvaluator), this.toStringEvaluator(argEvaluators.get(0), "first argument to indexOf")), "indexOf");
            }
            case 57: {
                this.verifyArgCount(argEvaluators, 1, "lastIndexOf");
                return this.addToken(new LastIndexOfEvaluator(this.toStringEvaluator(subjectEvaluator), this.toStringEvaluator(argEvaluators.get(0), "first argument to lastIndexOf")), "lastIndexOf");
            }
            case 37: {
                if (argEvaluators.size() == 1) {
                    return this.addToken(new FormatEvaluator(this.toDateEvaluator(subjectEvaluator), this.toStringEvaluator(argEvaluators.get(0), "first argument of format"), null), "format");
                }
                if (argEvaluators.size() == 2) {
                    return this.addToken(new FormatEvaluator(this.toDateEvaluator(subjectEvaluator), this.toStringEvaluator(argEvaluators.get(0)), this.toStringEvaluator(argEvaluators.get(1))), "format");
                }
                throw new AttributeExpressionLanguageParsingException("format() function takes 1 or 2 arguments");
            }
            case 73: {
                return this.addToken(new OrEvaluator(this.toBooleanEvaluator(subjectEvaluator), this.toBooleanEvaluator(argEvaluators.get(0))), "or");
            }
            case 7: {
                return this.addToken(new AndEvaluator(this.toBooleanEvaluator(subjectEvaluator), this.toBooleanEvaluator(argEvaluators.get(0))), "and");
            }
            case 69: {
                return this.addToken(new NotEvaluator(this.toBooleanEvaluator(subjectEvaluator)), "not");
            }
            case 39: {
                if (argEvaluators.size() == 1) {
                    return this.addToken(new GetDelimitedFieldEvaluator(this.toStringEvaluator(subjectEvaluator), this.toWholeNumberEvaluator(argEvaluators.get(0), "first argument of getDelimitedField")), "getDelimitedField");
                }
                if (argEvaluators.size() == 2) {
                    return this.addToken(new GetDelimitedFieldEvaluator(this.toStringEvaluator(subjectEvaluator), this.toWholeNumberEvaluator(argEvaluators.get(0), "first argument of getDelimitedField"), this.toStringEvaluator(argEvaluators.get(1), "second argument of getDelimitedField")), "getDelimitedField");
                }
                if (argEvaluators.size() == 3) {
                    return this.addToken(new GetDelimitedFieldEvaluator(this.toStringEvaluator(subjectEvaluator), this.toWholeNumberEvaluator(argEvaluators.get(0), "first argument of getDelimitedField"), this.toStringEvaluator(argEvaluators.get(1), "second argument of getDelimitedField"), this.toStringEvaluator(argEvaluators.get(2), "third argument of getDelimitedField")), "getDelimitedField");
                }
                if (argEvaluators.size() == 4) {
                    return this.addToken(new GetDelimitedFieldEvaluator(this.toStringEvaluator(subjectEvaluator), this.toWholeNumberEvaluator(argEvaluators.get(0), "first argument of getDelimitedField"), this.toStringEvaluator(argEvaluators.get(1), "second argument of getDelimitedField"), this.toStringEvaluator(argEvaluators.get(2), "third argument of getDelimitedField"), this.toStringEvaluator(argEvaluators.get(3), "fourth argument of getDelimitedField")), "getDelimitedField");
                }
                return this.addToken(new GetDelimitedFieldEvaluator(this.toStringEvaluator(subjectEvaluator), this.toWholeNumberEvaluator(argEvaluators.get(0), "first argument of getDelimitedField"), this.toStringEvaluator(argEvaluators.get(1), "second argument of getDelimitedField"), this.toStringEvaluator(argEvaluators.get(2), "third argument of getDelimitedField"), this.toStringEvaluator(argEvaluators.get(3), "fourth argument of getDelimitedField"), this.toBooleanEvaluator(argEvaluators.get(4), "fifth argument of getDelimitedField")), "getDelimitedField");
            }
            case 52: {
                this.verifyArgCount(argEvaluators, 1, "jsonPath");
                return this.addToken(new JsonPathEvaluator(this.toStringEvaluator(subjectEvaluator), this.toStringEvaluator(argEvaluators.get(0), "first argument to jsonPath")), "jsonPath");
            }
            case 54: {
                this.verifyArgCount(argEvaluators, 1, "jsonPathDelete");
                return this.addToken(new JsonPathDeleteEvaluator(this.toStringEvaluator(subjectEvaluator), this.toStringEvaluator(argEvaluators.get(0), "first argument to jsonPathDelete")), "jsonPathDelete");
            }
            case 56: {
                this.verifyArgCount(argEvaluators, 2, "jsonPathSet");
                Evaluator<?> argValueEvaluator = argEvaluators.get(1);
                String location = "second argument to jsonPathSet";
                Evaluator<?> valueEvaluator = this.getJsonPathUpdateEvaluator(argValueEvaluator, location);
                return this.addToken(new JsonPathSetEvaluator(this.toStringEvaluator(subjectEvaluator), this.toStringEvaluator(argEvaluators.get(0), "first argument to jsonPathSet"), valueEvaluator), "jsonPathSet");
            }
            case 53: {
                this.verifyArgCount(argEvaluators, 2, "jsonPathAdd");
                Evaluator<?> argValueEvaluator = argEvaluators.get(1);
                String location = "second argument to jsonPathAdd";
                Evaluator<?> valueEvaluator = this.getJsonPathUpdateEvaluator(argValueEvaluator, location);
                return this.addToken(new JsonPathAddEvaluator(this.toStringEvaluator(subjectEvaluator), this.toStringEvaluator(argEvaluators.get(0), "first argument to jsonPathAdd"), valueEvaluator), "jsonPathAdd");
            }
            case 55: {
                this.verifyArgCount(argEvaluators, 3, "jsonPathPut");
                Evaluator<?> argValueEvaluator = argEvaluators.get(1);
                String valueLocation = "second argument to jsonPathPut";
                Evaluator<?> valueEvaluator = this.getJsonPathUpdateEvaluator(argValueEvaluator, valueLocation);
                Evaluator<?> argKeyEvaluator = argEvaluators.get(2);
                String keyLocation = "third argument to jsonPathPut";
                Evaluator<?> keyEvaluator = this.getJsonPathUpdateEvaluator(argKeyEvaluator, keyLocation);
                return this.addToken(new JsonPathPutEvaluator(this.toStringEvaluator(subjectEvaluator), this.toStringEvaluator(argEvaluators.get(0), "first argument to jsonPathPut"), this.toStringEvaluator(keyEvaluator, keyLocation), valueEvaluator), "jsonPathPut");
            }
            case 115: {
                this.verifyArgCount(argEvaluators, 1, "UUID3");
                return this.addToken(new Uuid3Evaluator(this.toStringEvaluator(subjectEvaluator), this.toStringEvaluator(argEvaluators.get(0), "first argument to UUID3")), "UUID3");
            }
            case 116: {
                this.verifyArgCount(argEvaluators, 1, "UUID5");
                return this.addToken(new Uuid5Evaluator(this.toStringEvaluator(subjectEvaluator), this.toStringEvaluator(argEvaluators.get(0), "first argument to UUID5")), "UUID5");
            }
            case 45: {
                this.verifyArgCount(argEvaluators, 2, "ifElse");
                return this.addToken(new IfElseEvaluator(this.toBooleanEvaluator(subjectEvaluator), this.toStringEvaluator(argEvaluators.get(0), "argument to return if true"), this.toStringEvaluator(argEvaluators.get(1), "argument to return if false")), "ifElse");
            }
        }
        throw new AttributeExpressionLanguageParsingException("Expected a Function-type expression but got " + tree.toString());
    }

    private Evaluator<?> getJsonPathUpdateEvaluator(Evaluator<?> argValueEvaluator, String location) {
        Evaluator<Object> valueEvaluator;
        if (argValueEvaluator instanceof StringEvaluator) {
            valueEvaluator = this.toStringEvaluator(argValueEvaluator, location);
        } else if (argValueEvaluator instanceof DecimalEvaluator) {
            valueEvaluator = this.toDecimalEvaluator(argValueEvaluator, location);
        } else if (argValueEvaluator instanceof NumberEvaluator) {
            valueEvaluator = this.toNumberEvaluator(argValueEvaluator, location);
        } else if (argValueEvaluator instanceof WholeNumberEvaluator) {
            valueEvaluator = this.toWholeNumberEvaluator(argValueEvaluator, location);
        } else if (argValueEvaluator instanceof BooleanEvaluator) {
            valueEvaluator = this.toBooleanEvaluator(argValueEvaluator, location);
        } else {
            throw new AttributeExpressionLanguageParsingException("Cannot implicitly convert Data Type " + argValueEvaluator.getResultType() + (location == null ? "" : " at location [" + location + "]"));
        }
        return valueEvaluator;
    }

    public Evaluator<?> buildEvaluator(Tree tree) {
        switch (tree.getType()) {
            case 121: {
                return this.buildExpressionEvaluator(tree);
            }
            case 124: {
                String parameterName = tree.getChild(0).getText();
                ParameterEvaluator parameterEvaluator = new ParameterEvaluator(parameterName);
                this.evaluators.add(parameterEvaluator);
                return parameterEvaluator;
            }
            case 119: {
                Evaluator<?> childEvaluator = this.buildEvaluator(tree.getChild(0));
                if (childEvaluator instanceof MultiAttributeEvaluator) {
                    return childEvaluator;
                }
                AttributeEvaluator eval = new AttributeEvaluator(this.toStringEvaluator(childEvaluator));
                this.evaluators.add(eval);
                return eval;
            }
            case 123: {
                Tree functionTypeTree = tree.getChild(0);
                int multiAttrType = functionTypeTree.getType();
                if (multiAttrType == 9 || multiAttrType == 5) {
                    Evaluator<String> delineatedValueEvaluator = this.toStringEvaluator(this.buildEvaluator(tree.getChild(1)));
                    Evaluator<String> delimiterEvaluator = this.toStringEvaluator(this.buildEvaluator(tree.getChild(2)));
                    String token = multiAttrType == 9 ? "anyDelineatedValue" : "allDelineatedValues";
                    return this.addToken(new DelineatedAttributeEvaluator(delineatedValueEvaluator, delimiterEvaluator, multiAttrType), token);
                }
                ArrayList<String> attributeNames = new ArrayList<String>();
                for (int i = 1; i < tree.getChildCount(); ++i) {
                    attributeNames.add(this.newStringLiteralEvaluator(tree.getChild(i).getText()).evaluate(new StandardEvaluationContext(Collections.emptyMap())).getValue());
                }
                switch (multiAttrType) {
                    case 4: {
                        for (String attributeName : attributeNames) {
                            try {
                                FlowFile.KeyValidator.validateKey((String)attributeName);
                            }
                            catch (IllegalArgumentException iae) {
                                throw new AttributeExpressionLanguageParsingException("Invalid Attribute Name: " + attributeName + ". " + iae.getMessage());
                            }
                        }
                        return this.addToken(new MultiNamedAttributeEvaluator(attributeNames, 4), "allAttributes");
                    }
                    case 6: {
                        return this.addToken(new MultiMatchAttributeEvaluator(attributeNames, 6), "allMatchingAttributes");
                    }
                    case 8: {
                        for (String attributeName : attributeNames) {
                            try {
                                FlowFile.KeyValidator.validateKey((String)attributeName);
                            }
                            catch (IllegalArgumentException iae) {
                                throw new AttributeExpressionLanguageParsingException("Invalid Attribute Name: " + attributeName + ". " + iae.getMessage());
                            }
                        }
                        return this.addToken(new MultiNamedAttributeEvaluator(attributeNames, 8), "anyAttribute");
                    }
                    case 10: {
                        return this.addToken(new MultiMatchAttributeEvaluator(attributeNames, 10), "anyMatchingAttribute");
                    }
                }
                throw new AssertionError((Object)("Illegal Multi-Attribute Reference: " + functionTypeTree.toString()));
            }
            case 120: {
                return this.newStringLiteralEvaluator(tree.getChild(0).getText());
            }
            case 118: {
                return this.addToken(new WholeNumberLiteralEvaluator(tree.getText()), "wholeNumber");
            }
            case 90: {
                return this.newStringLiteralEvaluator(tree.getText());
            }
            case 20: {
                return this.addToken(new DecimalLiteralEvaluator(tree.getText()), "decimal");
            }
            case 35: 
            case 106: {
                return this.buildBooleanEvaluator(tree);
            }
            case 114: {
                return this.addToken(new UuidEvaluator(), "uuid");
            }
            case 71: {
                return this.addToken(new NowEvaluator(), "now");
            }
            case 99: {
                Evaluator<?> argEvaluator = this.buildEvaluator(tree.getChild(0));
                return this.addToken(new ToLiteralEvaluator(argEvaluator), "toLiteral");
            }
            case 48: {
                try {
                    return this.addToken(new IPEvaluator(), "ip");
                }
                catch (UnknownHostException e) {
                    throw new AttributeExpressionLanguageException(e);
                }
            }
            case 96: {
                return this.addToken(new ThreadEvaluator(), "thread");
            }
            case 44: {
                if (tree.getChildCount() == 0) {
                    try {
                        return this.addToken(new HostnameEvaluator(false), "hostname");
                    }
                    catch (UnknownHostException e) {
                        throw new AttributeExpressionLanguageException(e);
                    }
                }
                if (tree.getChildCount() == 1) {
                    Tree childTree = tree.getChild(0);
                    try {
                        switch (childTree.getType()) {
                            case 106: {
                                return this.addToken(new HostnameEvaluator(true), "hostname");
                            }
                            case 35: {
                                return this.addToken(new HostnameEvaluator(false), "hostname");
                            }
                        }
                        throw new AttributeExpressionLanguageParsingException("Call to hostname() must take 0 or 1 (boolean) parameter");
                    }
                    catch (UnknownHostException e) {
                        throw new AttributeExpressionLanguageException(e);
                    }
                }
                throw new AttributeExpressionLanguageParsingException("Call to hostname() must take 0 or 1 (boolean) parameter");
            }
            case 68: {
                return this.addToken(new OneUpSequenceEvaluator(), "nextInt");
            }
            case 79: {
                return this.addToken(new RandomNumberGeneratorEvaluator(), "random");
            }
            case 64: {
                if (tree.getChildCount() == 1) {
                    return this.addToken(new MathEvaluator(null, this.toStringEvaluator(this.buildEvaluator(tree.getChild(0))), null), "math");
                }
                throw new AttributeExpressionLanguageParsingException("Call to math() as the subject must take exactly 1 parameter");
            }
            case 40: {
                Tree childTree = tree.getChild(0);
                Evaluator<?> argEvaluator = this.buildEvaluator(childTree);
                Evaluator<String> stringEvaluator = this.toStringEvaluator(argEvaluator);
                GetStateVariableEvaluator eval = new GetStateVariableEvaluator(stringEvaluator);
                this.evaluators.add(eval);
                return eval;
            }
        }
        throw new AttributeExpressionLanguageParsingException("Unexpected token: " + tree.toString());
    }

    private <T> Evaluator<T> addToken(Evaluator<T> evaluator, String token) {
        evaluator.setToken(token);
        this.evaluators.add(evaluator);
        return evaluator;
    }

    private String unescapeTrailingDollarSigns(String value) {
        char c;
        if (!value.endsWith("$")) {
            return value;
        }
        int dollars = 0;
        for (int i = value.length() - 1; i >= 0 && (c = value.charAt(i)) == '$'; --i) {
            ++dollars;
        }
        int charsToRemove = dollars / 2;
        int newLength = value.length() - charsToRemove;
        return value.substring(0, newLength);
    }

    private Evaluator<String> newStringLiteralEvaluator(String literalValue) {
        if (literalValue == null || literalValue.length() < 2) {
            return this.addToken(new StringLiteralEvaluator(literalValue), literalValue);
        }
        List<Query.Range> ranges = Query.extractExpressionRanges(literalValue);
        if (ranges.isEmpty()) {
            List<Query.Range> escapedRanges = Query.extractEscapedRanges(literalValue);
            return this.newStringLiteralEvaluatorForEscapedRanges(literalValue, escapedRanges);
        }
        ArrayList evaluators = new ArrayList();
        int lastIndex = 0;
        for (Query.Range range : ranges) {
            String treeText = literalValue.substring(range.getStart(), range.getEnd() + 1);
            Evaluator<?> evaluator = this.buildEvaluator(this.compileTree(treeText));
            if (range.getStart() > lastIndex) {
                if (evaluator instanceof AttributeEvaluator) {
                    evaluators.add(this.newStringLiteralEvaluator(this.unescapeTrailingDollarSigns(literalValue.substring(lastIndex, range.getStart()))));
                } else {
                    evaluators.add(this.newStringLiteralEvaluator(literalValue.substring(lastIndex, range.getStart())));
                }
            }
            evaluators.add(evaluator);
            lastIndex = range.getEnd() + 1;
        }
        Query.Range lastRange = ranges.get(ranges.size() - 1);
        if (lastRange.getEnd() + 1 < literalValue.length()) {
            String treeText = literalValue.substring(lastRange.getEnd() + 1);
            evaluators.add(this.newStringLiteralEvaluator(treeText));
        }
        if (evaluators.size() == 1) {
            return this.toStringEvaluator((Evaluator)evaluators.get(0));
        }
        AppendEvaluator lastEvaluator = this.toStringEvaluator((Evaluator)evaluators.get(0));
        for (int i = 1; i < evaluators.size(); ++i) {
            lastEvaluator = new AppendEvaluator(lastEvaluator, this.toStringEvaluator((Evaluator)evaluators.get(i)));
        }
        this.evaluators.addAll(evaluators);
        return lastEvaluator;
    }

    private Evaluator<String> newStringLiteralEvaluatorForEscapedRanges(String literalValue, List<Query.Range> escapedRanges) {
        if (escapedRanges.isEmpty()) {
            return this.addToken(new StringLiteralEvaluator(literalValue), literalValue);
        }
        int lastIndex = 0;
        ArrayList<StringLiteralEvaluator> evaluators = new ArrayList<StringLiteralEvaluator>();
        for (Query.Range range : escapedRanges) {
            String treeText = literalValue.substring(range.getStart(), range.getEnd() + 1);
            if (range.getStart() > lastIndex) {
                evaluators.add(new StringLiteralEvaluator(literalValue.substring(lastIndex, range.getStart())));
            }
            StringLiteralEvaluator evaluator = new StringLiteralEvaluator(Query.unescape(treeText));
            evaluators.add(evaluator);
            lastIndex = range.getEnd() + 1;
        }
        Query.Range lastRange = escapedRanges.get(escapedRanges.size() - 1);
        if (lastRange.getEnd() + 1 < literalValue.length()) {
            String treeText = literalValue.substring(lastRange.getEnd() + 1);
            evaluators.add(new StringLiteralEvaluator(treeText));
        }
        if (evaluators.size() == 1) {
            return this.toStringEvaluator((Evaluator)evaluators.get(0));
        }
        AppendEvaluator lastEvaluator = this.toStringEvaluator((Evaluator)evaluators.get(0));
        for (int i = 1; i < evaluators.size(); ++i) {
            lastEvaluator = new AppendEvaluator(lastEvaluator, this.toStringEvaluator((Evaluator)evaluators.get(i)));
        }
        this.evaluators.addAll(evaluators);
        return lastEvaluator;
    }

    private Evaluator<Boolean> buildBooleanEvaluator(Tree tree) {
        switch (tree.getType()) {
            case 106: {
                return this.addToken(new BooleanLiteralEvaluator(true), "true");
            }
            case 35: {
                return this.addToken(new BooleanLiteralEvaluator(false), "true");
            }
        }
        throw new AttributeExpressionLanguageParsingException("Cannot build Boolean evaluator from tree " + tree.toString());
    }
}

