/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language.evaluation.literals;

import org.apache.nifi.attribute.expression.language.EvaluationContext;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.QueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.StringEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.StringQueryResult;

public class StringLiteralEvaluator
extends StringEvaluator {
    private final String value;

    public StringLiteralEvaluator(String value) {
        StringBuilder sb = new StringBuilder();
        boolean lastCharIsBackslash = false;
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (lastCharIsBackslash) {
                switch (c) {
                    case 'n': {
                        sb.append("\n");
                        break;
                    }
                    case 'r': {
                        sb.append("\r");
                        break;
                    }
                    case '\\': {
                        sb.append("\\");
                        break;
                    }
                    case 't': {
                        sb.append("\\t");
                        break;
                    }
                    default: {
                        sb.append("\\").append(c);
                    }
                }
                lastCharIsBackslash = false;
                continue;
            }
            if (c == '\\') {
                lastCharIsBackslash = true;
                continue;
            }
            sb.append(c);
        }
        this.value = sb.toString();
    }

    @Override
    public QueryResult<String> evaluate(EvaluationContext evaluationContext) {
        return new StringQueryResult(this.value);
    }

    @Override
    public Evaluator<?> getSubjectEvaluator() {
        return null;
    }
}

