/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language.evaluation.functions;

import java.util.Map;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.QueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.StringEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.StringQueryResult;

public class AppendEvaluator
extends StringEvaluator {
    private final Evaluator<String> subject;
    private final Evaluator<String> appendEvaluator;

    public AppendEvaluator(Evaluator<String> subject, Evaluator<String> append) {
        this.subject = subject;
        this.appendEvaluator = append;
    }

    @Override
    public QueryResult<String> evaluate(Map<String, String> attributes) {
        String subjectValue = this.subject.evaluate(attributes).getValue();
        String appendValue = this.appendEvaluator.evaluate(attributes).getValue();
        String result = (subjectValue == null ? "" : subjectValue) + (appendValue == null ? "" : appendValue);
        return new StringQueryResult(result);
    }

    @Override
    public Evaluator<?> getSubjectEvaluator() {
        return this.subject;
    }
}

