/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language.evaluation.functions;

import java.util.Map;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.NumberEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.NumberQueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.QueryResult;

public class DivideEvaluator
extends NumberEvaluator {
    private final Evaluator<Number> subject;
    private final Evaluator<Number> divideValue;

    public DivideEvaluator(Evaluator<Number> subject, Evaluator<Number> divideValue) {
        this.subject = subject;
        this.divideValue = divideValue;
    }

    @Override
    public QueryResult<Number> evaluate(Map<String, String> attributes) {
        Number subjectValue = this.subject.evaluate(attributes).getValue();
        if (subjectValue == null) {
            return new NumberQueryResult(null);
        }
        Number divide = this.divideValue.evaluate(attributes).getValue();
        if (divide == null) {
            return new NumberQueryResult(null);
        }
        Number result = subjectValue instanceof Double || divide instanceof Double ? (Number)(subjectValue.doubleValue() / divide.doubleValue()) : (Number)(subjectValue.longValue() / divide.longValue());
        return new NumberQueryResult(result);
    }

    @Override
    public Evaluator<?> getSubjectEvaluator() {
        return this.subject;
    }
}

