/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language.evaluation.functions;

import java.util.Map;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.QueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.WholeNumberEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.WholeNumberQueryResult;

public class LastIndexOfEvaluator
extends WholeNumberEvaluator {
    private final Evaluator<String> subject;
    private final Evaluator<String> indexEvaluator;

    public LastIndexOfEvaluator(Evaluator<String> subject, Evaluator<String> indexEvaluator) {
        this.subject = subject;
        this.indexEvaluator = indexEvaluator;
    }

    @Override
    public QueryResult<Long> evaluate(Map<String, String> attributes) {
        String subjectValue = this.subject.evaluate(attributes).getValue();
        if (subjectValue == null) {
            return new WholeNumberQueryResult(-1L);
        }
        String indexEvalValue = this.indexEvaluator.evaluate(attributes).getValue();
        return new WholeNumberQueryResult(Long.valueOf(subjectValue.lastIndexOf(indexEvalValue)));
    }

    @Override
    public Evaluator<?> getSubjectEvaluator() {
        return this.subject;
    }
}

