/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language.evaluation.functions;

import java.util.Arrays;
import java.util.Map;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.QueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.StringEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.StringQueryResult;

public class ToRadixEvaluator
extends StringEvaluator {
    private final Evaluator<Long> numberEvaluator;
    private final Evaluator<Long> radixEvaluator;
    private final Evaluator<Long> minimumWidthEvaluator;

    public ToRadixEvaluator(Evaluator<Long> subject, Evaluator<Long> radixEvaluator) {
        this(subject, radixEvaluator, null);
    }

    public ToRadixEvaluator(Evaluator<Long> subject, Evaluator<Long> radixEvaluator, Evaluator<Long> minimumWidthEvaluator) {
        this.numberEvaluator = subject;
        this.radixEvaluator = radixEvaluator;
        this.minimumWidthEvaluator = minimumWidthEvaluator;
    }

    @Override
    public QueryResult<String> evaluate(Map<String, String> attributes) {
        int paddingWidth;
        Long minimumWidth;
        Long result = this.numberEvaluator.evaluate(attributes).getValue();
        if (result == null) {
            return new StringQueryResult(null);
        }
        Long radix = this.radixEvaluator.evaluate(attributes).getValue();
        if (radix == null) {
            return new StringQueryResult(null);
        }
        String stringValue = Long.toString(result, radix.intValue());
        if (this.minimumWidthEvaluator != null && (minimumWidth = this.minimumWidthEvaluator.evaluate(attributes).getValue()) != null && (paddingWidth = minimumWidth.intValue() - stringValue.length()) > 0) {
            char[] padChars = new char[paddingWidth];
            Arrays.fill(padChars, '0');
            stringValue = String.valueOf(padChars) + stringValue;
        }
        return new StringQueryResult(stringValue);
    }

    @Override
    public Evaluator<?> getSubjectEvaluator() {
        return this.numberEvaluator;
    }
}

