/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.antlr.runtime.tree.Tree;
import org.apache.nifi.attribute.expression.language.AttributesAndState;
import org.apache.nifi.attribute.expression.language.CompiledExpression;
import org.apache.nifi.attribute.expression.language.EmptyPreparedQuery;
import org.apache.nifi.attribute.expression.language.Expression;
import org.apache.nifi.attribute.expression.language.InvalidPreparedQuery;
import org.apache.nifi.attribute.expression.language.PreparedQuery;
import org.apache.nifi.attribute.expression.language.StandardPreparedQuery;
import org.apache.nifi.attribute.expression.language.StringLiteralExpression;
import org.apache.nifi.attribute.expression.language.compile.ExpressionCompiler;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.QueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.selection.AttributeEvaluator;
import org.apache.nifi.attribute.expression.language.exception.AttributeExpressionLanguageParsingException;
import org.apache.nifi.expression.AttributeExpression;
import org.apache.nifi.expression.AttributeValueDecorator;
import org.apache.nifi.processor.exception.ProcessException;

public class Query {
    private final String query;
    private final Tree tree;
    private final Evaluator<?> evaluator;
    private final AtomicBoolean evaluated = new AtomicBoolean(false);

    private Query(String query, Tree tree, Evaluator<?> evaluator) {
        this.query = query;
        this.tree = tree;
        this.evaluator = evaluator;
    }

    public static boolean isValidExpression(String value) {
        try {
            Query.validateExpression(value, false);
            return true;
        }
        catch (AttributeExpressionLanguageParsingException | ProcessException e) {
            return false;
        }
    }

    public static AttributeExpression.ResultType getResultType(String value) throws AttributeExpressionLanguageParsingException {
        return Query.compile(value).getResultType();
    }

    public static List<AttributeExpression.ResultType> extractResultTypes(String value) throws AttributeExpressionLanguageParsingException {
        ArrayList<AttributeExpression.ResultType> types = new ArrayList<AttributeExpression.ResultType>();
        for (Range range : Query.extractExpressionRanges(value)) {
            String text = value.substring(range.getStart(), range.getEnd() + 1);
            types.add(Query.getResultType(text));
        }
        return types;
    }

    public static List<String> extractExpressions(String value) throws AttributeExpressionLanguageParsingException {
        ArrayList<String> expressions = new ArrayList<String>();
        for (Range range : Query.extractExpressionRanges(value)) {
            expressions.add(value.substring(range.getStart(), range.getEnd() + 1));
        }
        return expressions;
    }

    public static List<Range> extractExpressionRanges(String value) throws AttributeExpressionLanguageParsingException {
        ArrayList<Range> ranges = new ArrayList<Range>();
        int lastChar = 0;
        int embeddedCount = 0;
        int expressionStart = -1;
        boolean oddDollarCount = false;
        int backslashCount = 0;
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (!(expressionStart <= -1 || c != '\'' && c != '\"' || lastChar == 92 && backslashCount % 2 != 0)) {
                int endQuoteIndex = Query.findEndQuoteChar(value, i);
                if (endQuoteIndex < 0) break;
                i = endQuoteIndex;
                continue;
            }
            if (c == '{') {
                if (oddDollarCount && lastChar == 36 && embeddedCount == 0) {
                    expressionStart = i - 1;
                }
                if (expressionStart > -1) {
                    ++embeddedCount;
                }
            } else if (c == '}') {
                if (embeddedCount <= 0) continue;
                if (--embeddedCount == 0) {
                    if (expressionStart > -1) {
                        Range range = new Range(expressionStart, i);
                        ranges.add(range);
                    }
                    expressionStart = -1;
                }
            } else if (c == '$') {
                oddDollarCount = !oddDollarCount;
            } else if (c == '\\') {
                ++backslashCount;
            } else {
                oddDollarCount = false;
            }
            lastChar = c;
        }
        return ranges;
    }

    public static void validateExpression(String value, boolean allowSurroundingCharacters) throws AttributeExpressionLanguageParsingException {
        if (!allowSurroundingCharacters) {
            List<Range> ranges = Query.extractExpressionRanges(value);
            if (ranges.size() > 1) {
                throw new AttributeExpressionLanguageParsingException("Found multiple Expressions but expected only 1");
            }
            if (ranges.isEmpty()) {
                throw new AttributeExpressionLanguageParsingException("No Expressions found");
            }
            Range range = ranges.get(0);
            String expression = value.substring(range.getStart(), range.getEnd() + 1);
            Query.compile(expression);
            if (range.getStart() > 0 || range.getEnd() < value.length() - 1) {
                throw new AttributeExpressionLanguageParsingException("Found characters outside of Expression");
            }
        } else {
            for (Range range : Query.extractExpressionRanges(value)) {
                String expression = value.substring(range.getStart(), range.getEnd() + 1);
                Query.compile(expression);
            }
        }
    }

    static int findEndQuoteChar(String value, int quoteStart) {
        char quoteChar = value.charAt(quoteStart);
        int backslashCount = 0;
        char lastChar = '\u0000';
        for (int i = quoteStart + 1; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == '\\') {
                ++backslashCount;
            } else if (c == quoteChar && (backslashCount % 2 == 0 || lastChar != '\\')) {
                return i;
            }
            lastChar = c;
        }
        return -1;
    }

    static String evaluateExpression(Tree tree, String queryText, Map<String, String> valueMap, AttributeValueDecorator decorator, Map<String, String> stateVariables) throws ProcessException {
        Object evaluated = Query.fromTree(tree, queryText).evaluate(valueMap, stateVariables).getValue();
        if (evaluated == null) {
            return null;
        }
        String value = evaluated.toString();
        return decorator == null ? value : decorator.decorate(value);
    }

    static String evaluateExpressions(String rawValue, Map<String, String> expressionMap, AttributeValueDecorator decorator, Map<String, String> stateVariables) throws ProcessException {
        return Query.prepare(rawValue).evaluateExpressions(expressionMap, decorator, stateVariables);
    }

    static String evaluateExpressions(String rawValue, Map<String, String> valueLookup) throws ProcessException {
        return Query.evaluateExpressions(rawValue, valueLookup, null);
    }

    static String evaluateExpressions(String rawValue, Map<String, String> valueLookup, AttributeValueDecorator decorator) throws ProcessException {
        return Query.prepare(rawValue).evaluateExpressions(valueLookup, decorator);
    }

    public static String unescape(String value) {
        return value.replaceAll("\\$\\$(?=\\$*\\{.*?\\})", "\\$");
    }

    public static Query fromTree(Tree tree, String text) {
        ExpressionCompiler compiler = new ExpressionCompiler();
        return new Query(text, tree, compiler.buildEvaluator(tree));
    }

    private static String unescapeLeadingDollarSigns(String value) {
        int index = value.indexOf("{");
        if (index < 0) {
            return value.replace("$$", "$");
        }
        String prefix = value.substring(0, index);
        return prefix.replace("$$", "$") + value.substring(index);
    }

    private static String unescapeTrailingDollarSigns(String value, boolean escapeIfAllDollars) {
        char c;
        if (!value.endsWith("$")) {
            return value;
        }
        int dollars = 0;
        for (int i = value.length() - 1; i >= 0 && (c = value.charAt(i)) == '$'; --i) {
            ++dollars;
        }
        if (dollars == value.length() && !escapeIfAllDollars) {
            return value;
        }
        int charsToRemove = dollars / 2;
        int newLength = value.length() - charsToRemove;
        return value.substring(0, newLength);
    }

    public static PreparedQuery prepare(String query) throws AttributeExpressionLanguageParsingException {
        if (query == null) {
            return new EmptyPreparedQuery(null);
        }
        List<Range> ranges = Query.extractExpressionRanges(query);
        if (ranges.isEmpty()) {
            return new EmptyPreparedQuery(Query.unescape(query));
        }
        ExpressionCompiler compiler = new ExpressionCompiler();
        try {
            ArrayList<Expression> expressions = new ArrayList<Expression>();
            int lastIndex = 0;
            for (Range range : ranges) {
                String treeText = Query.unescapeLeadingDollarSigns(query.substring(range.getStart(), range.getEnd() + 1));
                CompiledExpression compiledExpression = compiler.compile(treeText);
                if (range.getStart() > lastIndex) {
                    String substring = Query.unescapeLeadingDollarSigns(query.substring(lastIndex, range.getStart()));
                    if (compiledExpression.getRootEvaluator() instanceof AttributeEvaluator) {
                        substring = Query.unescapeTrailingDollarSigns(substring, false);
                    }
                    expressions.add(new StringLiteralExpression(substring));
                }
                expressions.add(compiledExpression);
                lastIndex = range.getEnd() + 1;
            }
            Range lastRange = ranges.get(ranges.size() - 1);
            if (lastRange.getEnd() + 1 < query.length()) {
                String treeText = Query.unescapeLeadingDollarSigns(query.substring(lastRange.getEnd() + 1));
                expressions.add(new StringLiteralExpression(treeText));
            }
            return new StandardPreparedQuery(expressions);
        }
        catch (AttributeExpressionLanguageParsingException e) {
            return new InvalidPreparedQuery(query, e.getMessage());
        }
    }

    public static Query compile(String query) throws AttributeExpressionLanguageParsingException {
        try {
            ExpressionCompiler compiler = new ExpressionCompiler();
            CompiledExpression compiledExpression = compiler.compile(query);
            return new Query(compiledExpression.getExpression(), compiledExpression.getTree(), compiledExpression.getRootEvaluator());
        }
        catch (AttributeExpressionLanguageParsingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AttributeExpressionLanguageParsingException(e);
        }
    }

    public AttributeExpression.ResultType getResultType() {
        return this.evaluator.getResultType();
    }

    QueryResult<?> evaluate(Map<String, String> map) {
        return this.evaluate(map, null);
    }

    QueryResult<?> evaluate(Map<String, String> attributes, Map<String, String> stateMap) {
        if (this.evaluated.getAndSet(true)) {
            throw new IllegalStateException("A Query cannot be evaluated more than once");
        }
        if (stateMap != null) {
            AttributesAndState attributesAndState = new AttributesAndState(attributes, stateMap);
            return this.evaluator.evaluate(attributesAndState);
        }
        return this.evaluator.evaluate(attributes);
    }

    Tree getTree() {
        return this.tree;
    }

    public String toString() {
        return "Query [" + this.query + "]";
    }

    public static class Range {
        private final int start;
        private final int end;

        public Range(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public String toString() {
            return this.start + " - " + this.end;
        }
    }
}

