/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language;

import java.time.Duration;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.attribute.expression.language.EmptyPreparedQuery;
import org.apache.nifi.attribute.expression.language.PreparedQuery;
import org.apache.nifi.attribute.expression.language.Query;
import org.apache.nifi.attribute.expression.language.StandardEvaluationContext;
import org.apache.nifi.attribute.expression.language.ValueLookup;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.resource.ResourceContext;
import org.apache.nifi.components.resource.ResourceReference;
import org.apache.nifi.components.resource.ResourceReferenceFactory;
import org.apache.nifi.components.resource.ResourceReferences;
import org.apache.nifi.components.resource.StandardResourceContext;
import org.apache.nifi.components.resource.StandardResourceReferenceFactory;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.expression.AttributeValueDecorator;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.parameter.ParameterLookup;
import org.apache.nifi.processor.DataUnit;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.util.FormatUtils;

public class StandardPropertyValue
implements PropertyValue {
    private final String rawValue;
    private final ControllerServiceLookup serviceLookup;
    private final PreparedQuery preparedQuery;
    private final ParameterLookup parameterLookup;
    private final ResourceContext resourceContext;

    public StandardPropertyValue(String rawValue, ControllerServiceLookup serviceLookup, ParameterLookup parameterLookup) {
        this((ResourceContext)new StandardResourceContext((ResourceReferenceFactory)new StandardResourceReferenceFactory(), null), rawValue, serviceLookup, parameterLookup);
    }

    public StandardPropertyValue(ResourceContext resourceContext, String rawValue, ControllerServiceLookup serviceLookup, ParameterLookup parameterLookup) {
        this(resourceContext, rawValue, serviceLookup, parameterLookup, Query.prepare(rawValue));
    }

    public StandardPropertyValue(ResourceContext resourceContext, String rawValue, ControllerServiceLookup serviceLookup, ParameterLookup parameterLookup, PreparedQuery preparedQuery) {
        this.rawValue = rawValue;
        this.serviceLookup = serviceLookup;
        this.preparedQuery = preparedQuery;
        this.parameterLookup = parameterLookup == null ? ParameterLookup.EMPTY : parameterLookup;
        this.resourceContext = resourceContext;
    }

    public String getValue() {
        return this.rawValue;
    }

    public Integer asInteger() {
        return this.rawValue == null ? null : Integer.valueOf(Integer.parseInt(this.rawValue.trim()));
    }

    public Long asLong() {
        return this.rawValue == null ? null : Long.valueOf(Long.parseLong(this.rawValue.trim()));
    }

    public Boolean asBoolean() {
        return this.rawValue == null ? null : Boolean.valueOf(Boolean.parseBoolean(this.rawValue.trim()));
    }

    public Float asFloat() {
        return this.rawValue == null ? null : Float.valueOf(Float.parseFloat(this.rawValue.trim()));
    }

    public Double asDouble() {
        return this.rawValue == null ? null : Double.valueOf(Double.parseDouble(this.rawValue.trim()));
    }

    public Long asTimePeriod(TimeUnit timeUnit) {
        return this.rawValue == null ? null : Long.valueOf(FormatUtils.getTimeDuration((String)this.rawValue.trim(), (TimeUnit)timeUnit));
    }

    public Duration asDuration() {
        return this.isSet() ? Duration.ofNanos(this.asTimePeriod(TimeUnit.NANOSECONDS)) : null;
    }

    public Double asDataSize(DataUnit dataUnit) {
        return this.rawValue == null ? null : DataUnit.parseDataSize((String)this.rawValue.trim(), (DataUnit)dataUnit);
    }

    public PropertyValue evaluateAttributeExpressions() throws ProcessException {
        return this.evaluateAttributeExpressions(null, null, null);
    }

    public PropertyValue evaluateAttributeExpressions(Map<String, String> attributes) throws ProcessException {
        return this.evaluateAttributeExpressions(null, attributes, null);
    }

    public PropertyValue evaluateAttributeExpressions(Map<String, String> attributes, AttributeValueDecorator decorator) throws ProcessException {
        return this.evaluateAttributeExpressions(null, attributes, decorator);
    }

    public PropertyValue evaluateAttributeExpressions(AttributeValueDecorator decorator) throws ProcessException {
        return this.evaluateAttributeExpressions(null, null, decorator);
    }

    public PropertyValue evaluateAttributeExpressions(FlowFile flowFile) throws ProcessException {
        return this.evaluateAttributeExpressions(flowFile, null, null);
    }

    public PropertyValue evaluateAttributeExpressions(FlowFile flowFile, Map<String, String> additionalAttributes) throws ProcessException {
        return this.evaluateAttributeExpressions(flowFile, additionalAttributes, null);
    }

    public PropertyValue evaluateAttributeExpressions(FlowFile flowFile, AttributeValueDecorator decorator) throws ProcessException {
        return this.evaluateAttributeExpressions(flowFile, null, decorator);
    }

    public PropertyValue evaluateAttributeExpressions(FlowFile flowFile, Map<String, String> additionalAttributes, AttributeValueDecorator decorator) throws ProcessException {
        return this.evaluateAttributeExpressions(flowFile, additionalAttributes, decorator, null);
    }

    public PropertyValue evaluateAttributeExpressions(FlowFile flowFile, Map<String, String> additionalAttributes, AttributeValueDecorator decorator, Map<String, String> stateValues) throws ProcessException {
        if (this.rawValue == null || this.preparedQuery == null) {
            return this;
        }
        ValueLookup lookup = new ValueLookup(flowFile, additionalAttributes);
        StandardEvaluationContext evaluationContext = new StandardEvaluationContext(lookup, stateValues, this.parameterLookup);
        String evaluated = this.preparedQuery.evaluateExpressions(evaluationContext, decorator);
        return new StandardPropertyValue(this.resourceContext, evaluated, this.serviceLookup, this.parameterLookup, new EmptyPreparedQuery(evaluated));
    }

    public String toString() {
        return this.rawValue;
    }

    public ControllerService asControllerService() {
        if (this.rawValue == null || this.rawValue.equals("") || this.serviceLookup == null) {
            return null;
        }
        return this.serviceLookup.getControllerService(this.rawValue);
    }

    public <T extends ControllerService> T asControllerService(Class<T> serviceType) throws IllegalArgumentException {
        if (!serviceType.isInterface()) {
            throw new IllegalArgumentException("ControllerServices may be referenced only via their interfaces; " + String.valueOf(serviceType) + " is not an interface");
        }
        if (this.rawValue == null || this.rawValue.equals("") || this.serviceLookup == null) {
            return null;
        }
        ControllerService service = this.serviceLookup.getControllerService(this.rawValue);
        if (service == null) {
            return null;
        }
        if (serviceType.isAssignableFrom(service.getClass())) {
            return (T)((ControllerService)serviceType.cast(service));
        }
        throw new IllegalArgumentException("Controller Service with identifier " + this.rawValue + " is of type " + String.valueOf(service.getClass()) + " and cannot be cast to " + String.valueOf(serviceType));
    }

    public ResourceReference asResource() {
        PropertyDescriptor propertyDescriptor = this.resourceContext.getPropertyDescriptor();
        if (propertyDescriptor == null) {
            return null;
        }
        return this.resourceContext.getResourceReferenceFactory().createResourceReference(this.rawValue, propertyDescriptor.getResourceDefinition());
    }

    public ResourceReferences asResources() {
        PropertyDescriptor propertyDescriptor = this.resourceContext.getPropertyDescriptor();
        if (propertyDescriptor == null) {
            return null;
        }
        return this.resourceContext.getResourceReferenceFactory().createResourceReferences(this.rawValue, propertyDescriptor.getResourceDefinition());
    }

    public boolean isSet() {
        return this.rawValue != null;
    }

    public boolean isExpressionLanguagePresent() {
        if (this.preparedQuery == null) {
            return false;
        }
        return this.preparedQuery.isExpressionLanguagePresent();
    }
}

