/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.protocol.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.nifi.cluster.protocol.ProtocolContext;
import org.apache.nifi.cluster.protocol.ProtocolException;
import org.apache.nifi.cluster.protocol.ProtocolHandler;
import org.apache.nifi.cluster.protocol.ProtocolListener;
import org.apache.nifi.cluster.protocol.ProtocolMessageMarshaller;
import org.apache.nifi.cluster.protocol.ProtocolMessageUnmarshaller;
import org.apache.nifi.cluster.protocol.message.MulticastProtocolMessage;
import org.apache.nifi.cluster.protocol.message.ProtocolMessage;
import org.apache.nifi.events.BulletinFactory;
import org.apache.nifi.io.socket.multicast.MulticastConfiguration;
import org.apache.nifi.io.socket.multicast.MulticastListener;
import org.apache.nifi.logging.NiFiLog;
import org.apache.nifi.reporting.Bulletin;
import org.apache.nifi.reporting.BulletinRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MulticastProtocolListener
extends MulticastListener
implements ProtocolListener {
    private static final Logger logger = new NiFiLog(LoggerFactory.getLogger(MulticastProtocolListener.class));
    private final Collection<ProtocolHandler> handlers = new CopyOnWriteArrayList<ProtocolHandler>();
    private final String listenerId = UUID.randomUUID().toString();
    private final ProtocolContext<ProtocolMessage> protocolContext;
    private volatile BulletinRepository bulletinRepository;

    public MulticastProtocolListener(int numThreads, InetSocketAddress multicastAddress, MulticastConfiguration configuration, ProtocolContext<ProtocolMessage> protocolContext) {
        super(numThreads, multicastAddress, configuration);
        if (protocolContext == null) {
            throw new IllegalArgumentException("Protocol Context may not be null.");
        }
        this.protocolContext = protocolContext;
    }

    @Override
    public void setBulletinRepository(BulletinRepository bulletinRepository) {
        this.bulletinRepository = bulletinRepository;
    }

    @Override
    public void start() throws IOException {
        if (super.isRunning()) {
            throw new IllegalStateException("Instance is already started.");
        }
        super.start();
    }

    @Override
    public void stop() throws IOException {
        if (!super.isRunning()) {
            throw new IllegalStateException("Instance is already stopped.");
        }
        super.stop();
    }

    @Override
    public Collection<ProtocolHandler> getHandlers() {
        return Collections.unmodifiableCollection(this.handlers);
    }

    @Override
    public void addHandler(ProtocolHandler handler) {
        if (handler == null) {
            throw new NullPointerException("Protocol handler may not be null.");
        }
        this.handlers.add(handler);
    }

    @Override
    public boolean removeHandler(ProtocolHandler handler) {
        return this.handlers.remove(handler);
    }

    public void dispatchRequest(MulticastSocket multicastSocket, DatagramPacket packet) {
        block10: {
            try {
                ProtocolMessage unwrappedRequest;
                ProtocolMessageUnmarshaller<ProtocolMessage> unmarshaller = this.protocolContext.createUnmarshaller();
                ProtocolMessage request = unmarshaller.unmarshal(new ByteArrayInputStream(packet.getData(), 0, packet.getLength()));
                if (request instanceof MulticastProtocolMessage) {
                    MulticastProtocolMessage multicastRequest = (MulticastProtocolMessage)request;
                    if (this.listenerId.equals(multicastRequest.getId())) {
                        return;
                    }
                    unwrappedRequest = multicastRequest.getProtocolMessage();
                } else {
                    unwrappedRequest = request;
                }
                ProtocolHandler desiredHandler = null;
                for (ProtocolHandler handler : this.getHandlers()) {
                    if (!handler.canHandle(unwrappedRequest)) continue;
                    desiredHandler = handler;
                    break;
                }
                if (desiredHandler == null) {
                    throw new ProtocolException("No handler assigned to handle message type: " + (Object)((Object)request.getType()));
                }
                ProtocolMessage response = desiredHandler.handle(request);
                if (response == null) break block10;
                try {
                    MulticastProtocolMessage multicastResponse = new MulticastProtocolMessage(this.listenerId, response);
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    ProtocolMessageMarshaller<ProtocolMessage> marshaller = this.protocolContext.createMarshaller();
                    marshaller.marshal(multicastResponse, baos);
                    byte[] responseBytes = baos.toByteArray();
                    int maxPacketSizeBytes = this.getMaxPacketSizeBytes();
                    if (responseBytes.length > maxPacketSizeBytes) {
                        logger.warn("Cluster protocol handler '" + desiredHandler.getClass() + "' produced a multicast response with length greater than configured max packet size '" + maxPacketSizeBytes + "'");
                    }
                    DatagramPacket responseDatagram = new DatagramPacket(responseBytes, responseBytes.length, this.getMulticastAddress().getAddress(), this.getMulticastAddress().getPort());
                    multicastSocket.send(responseDatagram);
                }
                catch (IOException ioe) {
                    throw new ProtocolException("Failed marshalling protocol message in response to message type: " + (Object)((Object)request.getType()) + " due to: " + ioe, ioe);
                }
            }
            catch (Throwable t) {
                logger.warn("Failed processing protocol message due to " + t, t);
                if (this.bulletinRepository == null) break block10;
                Bulletin bulletin = BulletinFactory.createBulletin((String)"Clustering", (String)"WARNING", (String)("Failed to process Protocol Message due to " + t.toString()));
                this.bulletinRepository.addBulletin(bulletin);
            }
        }
    }
}

