/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.protocol;

import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.cluster.protocol.StandardDataFlow;
import org.apache.nifi.cluster.protocol.jaxb.message.ConnectionResponseAdapter;

@XmlJavaTypeAdapter(value=ConnectionResponseAdapter.class)
public class ConnectionResponse {
    private final boolean blockedByFirewall;
    private final int tryLaterSeconds;
    private final NodeIdentifier nodeIdentifier;
    private final StandardDataFlow dataFlow;
    private final boolean primary;
    private final Integer managerRemoteInputPort;
    private final Boolean managerRemoteCommsSecure;
    private final String instanceId;
    private volatile String clusterManagerDN;

    public ConnectionResponse(NodeIdentifier nodeIdentifier, StandardDataFlow dataFlow, boolean primary, Integer managerRemoteInputPort, Boolean managerRemoteCommsSecure, String instanceId) {
        if (nodeIdentifier == null) {
            throw new IllegalArgumentException("Node identifier may not be empty or null.");
        }
        if (dataFlow == null) {
            throw new IllegalArgumentException("DataFlow may not be null.");
        }
        this.nodeIdentifier = nodeIdentifier;
        this.dataFlow = dataFlow;
        this.tryLaterSeconds = 0;
        this.blockedByFirewall = false;
        this.primary = primary;
        this.managerRemoteInputPort = managerRemoteInputPort;
        this.managerRemoteCommsSecure = managerRemoteCommsSecure;
        this.instanceId = instanceId;
    }

    public ConnectionResponse(int tryLaterSeconds) {
        if (tryLaterSeconds <= 0) {
            throw new IllegalArgumentException("Try-Later seconds may not be nonnegative: " + tryLaterSeconds);
        }
        this.dataFlow = null;
        this.nodeIdentifier = null;
        this.tryLaterSeconds = tryLaterSeconds;
        this.blockedByFirewall = false;
        this.primary = false;
        this.managerRemoteInputPort = null;
        this.managerRemoteCommsSecure = null;
        this.instanceId = null;
    }

    private ConnectionResponse() {
        this.dataFlow = null;
        this.nodeIdentifier = null;
        this.tryLaterSeconds = 0;
        this.blockedByFirewall = true;
        this.primary = false;
        this.managerRemoteInputPort = null;
        this.managerRemoteCommsSecure = null;
        this.instanceId = null;
    }

    public static ConnectionResponse createBlockedByFirewallResponse() {
        return new ConnectionResponse();
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public boolean shouldTryLater() {
        return this.tryLaterSeconds > 0;
    }

    public boolean isBlockedByFirewall() {
        return this.blockedByFirewall;
    }

    public int getTryLaterSeconds() {
        return this.tryLaterSeconds;
    }

    public StandardDataFlow getDataFlow() {
        return this.dataFlow;
    }

    public NodeIdentifier getNodeIdentifier() {
        return this.nodeIdentifier;
    }

    public Integer getManagerRemoteInputPort() {
        return this.managerRemoteInputPort;
    }

    public Boolean isManagerRemoteCommsSecure() {
        return this.managerRemoteCommsSecure;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setClusterManagerDN(String dn) {
        this.clusterManagerDN = dn;
    }

    public String getClusterManagerDN() {
        return this.clusterManagerDN;
    }
}

