/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.protocol.spring;

import java.util.concurrent.TimeUnit;
import org.apache.nifi.io.socket.SSLContextFactory;
import org.apache.nifi.io.socket.ServerSocketConfiguration;
import org.apache.nifi.util.FormatUtils;
import org.apache.nifi.util.NiFiProperties;
import org.springframework.beans.factory.FactoryBean;

public class ServerSocketConfigurationFactoryBean
implements FactoryBean<ServerSocketConfiguration> {
    private ServerSocketConfiguration configuration;
    private NiFiProperties properties;

    public ServerSocketConfiguration getObject() throws Exception {
        if (this.configuration == null) {
            this.configuration = new ServerSocketConfiguration();
            this.configuration.setNeedClientAuth(this.properties.getNeedClientAuth());
            int timeout = (int)FormatUtils.getTimeDuration((String)this.properties.getClusterProtocolSocketTimeout(), (TimeUnit)TimeUnit.MILLISECONDS);
            this.configuration.setSocketTimeout(Integer.valueOf(timeout));
            this.configuration.setReuseAddress(Boolean.valueOf(true));
            if (Boolean.valueOf(this.properties.getProperty("nifi.cluster.protocol.is.secure")).booleanValue()) {
                this.configuration.setSSLContextFactory(new SSLContextFactory(this.properties));
            }
        }
        return this.configuration;
    }

    public Class<ServerSocketConfiguration> getObjectType() {
        return ServerSocketConfiguration.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setProperties(NiFiProperties properties) {
        this.properties = properties;
    }
}

