/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.protocol;

import java.util.Date;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.cluster.protocol.jaxb.message.HeartbeatAdapter;

@XmlJavaTypeAdapter(value=HeartbeatAdapter.class)
public class Heartbeat {
    private final NodeIdentifier nodeIdentifier;
    private final boolean primary;
    private final boolean connected;
    private final long createdTimestamp;
    private final byte[] payload;

    public Heartbeat(NodeIdentifier nodeIdentifier, boolean primary, boolean connected, byte[] payload) {
        if (nodeIdentifier == null) {
            throw new IllegalArgumentException("Node Identifier may not be null.");
        }
        this.nodeIdentifier = nodeIdentifier;
        this.primary = primary;
        this.connected = connected;
        this.payload = payload;
        this.createdTimestamp = new Date().getTime();
    }

    public NodeIdentifier getNodeIdentifier() {
        return this.nodeIdentifier;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public boolean isConnected() {
        return this.connected;
    }

    @XmlTransient
    public long getCreatedTimestamp() {
        return this.createdTimestamp;
    }
}

