/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.coordination;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.cluster.coordination.node.DisconnectionCode;
import org.apache.nifi.cluster.coordination.node.NodeConnectionState;
import org.apache.nifi.cluster.coordination.node.NodeConnectionStatus;
import org.apache.nifi.cluster.event.NodeEvent;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.reporting.Severity;
import org.apache.nifi.services.FlowService;

public interface ClusterCoordinator {
    public void requestNodeConnect(NodeIdentifier var1, String var2);

    public void shutdown();

    public void finishNodeConnection(NodeIdentifier var1);

    public void requestNodeDisconnect(NodeIdentifier var1, DisconnectionCode var2, String var3);

    public void disconnectionRequestedByNode(NodeIdentifier var1, DisconnectionCode var2, String var3);

    public void removeNode(NodeIdentifier var1, String var2);

    public NodeConnectionStatus getConnectionStatus(NodeIdentifier var1);

    public Set<NodeIdentifier> getNodeIdentifiers(NodeConnectionState ... var1);

    public Map<NodeConnectionState, List<NodeIdentifier>> getConnectionStates();

    public boolean isBlockedByFirewall(String var1);

    public void reportEvent(NodeIdentifier var1, Severity var2, String var3);

    public void updateNodeRoles(NodeIdentifier var1, Set<String> var2);

    public NodeIdentifier getNodeIdentifier(String var1);

    public List<NodeEvent> getNodeEvents(NodeIdentifier var1);

    public NodeIdentifier getPrimaryNode();

    public NodeIdentifier getElectedActiveCoordinatorNode();

    public NodeIdentifier getLocalNodeIdentifier();

    public boolean isActiveClusterCoordinator();

    public void setFlowService(FlowService var1);

    public void resetNodeStatuses(Map<NodeIdentifier, NodeConnectionStatus> var1);

    public void setLocalNodeIdentifier(NodeIdentifier var1);

    public void setConnected(boolean var1);

    public boolean isConnected();

    public void addRole(String var1);

    public void removeRole(String var1);
}

