/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.protocol;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.nifi.cluster.protocol.DataFlow;
import org.apache.nifi.cluster.protocol.jaxb.message.DataFlowAdapter;

@XmlJavaTypeAdapter(value=DataFlowAdapter.class)
public class StandardDataFlow
implements Serializable,
DataFlow {
    private static final long serialVersionUID = 1L;
    private final byte[] flow;
    private final byte[] snippetBytes;
    private final byte[] authorizerFingerprint;
    private final Set<String> missingComponentIds;

    public StandardDataFlow(byte[] flow, byte[] snippetBytes, byte[] authorizerFingerprint, Set<String> missingComponentIds) {
        if (flow == null) {
            throw new NullPointerException("Flow cannot be null");
        }
        this.flow = flow;
        this.snippetBytes = snippetBytes;
        this.authorizerFingerprint = authorizerFingerprint;
        this.missingComponentIds = Collections.unmodifiableSet(missingComponentIds == null ? new HashSet() : new HashSet<String>(missingComponentIds));
    }

    public StandardDataFlow(DataFlow toCopy) {
        this.flow = StandardDataFlow.copy(toCopy.getFlow());
        this.snippetBytes = StandardDataFlow.copy(toCopy.getSnippets());
        this.authorizerFingerprint = StandardDataFlow.copy(toCopy.getAuthorizerFingerprint());
        this.missingComponentIds = Collections.unmodifiableSet(toCopy.getMissingComponents() == null ? new HashSet() : new HashSet(toCopy.getMissingComponents()));
    }

    private static byte[] copy(byte[] bytes) {
        return bytes == null ? null : Arrays.copyOf(bytes, bytes.length);
    }

    public byte[] getFlow() {
        return this.flow;
    }

    public byte[] getSnippets() {
        return this.snippetBytes;
    }

    public byte[] getAuthorizerFingerprint() {
        return this.authorizerFingerprint;
    }

    public Set<String> getMissingComponents() {
        return this.missingComponentIds;
    }
}

