/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.protocol;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.nifi.cluster.coordination.node.NodeConnectionStatus;
import org.apache.nifi.cluster.protocol.ComponentRevision;
import org.apache.nifi.cluster.protocol.DataFlow;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.cluster.protocol.jaxb.message.ConnectionResponseAdapter;

@XmlJavaTypeAdapter(value=ConnectionResponseAdapter.class)
public class ConnectionResponse {
    private final String rejectionReason;
    private final int tryLaterSeconds;
    private final NodeIdentifier nodeIdentifier;
    private final DataFlow dataFlow;
    private final String instanceId;
    private final List<NodeConnectionStatus> nodeStatuses;
    private final List<ComponentRevision> componentRevisions;

    public ConnectionResponse(NodeIdentifier nodeIdentifier, DataFlow dataFlow, String instanceId, List<NodeConnectionStatus> nodeStatuses, List<ComponentRevision> componentRevisions) {
        if (nodeIdentifier == null) {
            throw new IllegalArgumentException("Node identifier may not be empty or null.");
        }
        this.nodeIdentifier = nodeIdentifier;
        this.dataFlow = dataFlow;
        this.tryLaterSeconds = 0;
        this.rejectionReason = null;
        this.instanceId = instanceId;
        this.nodeStatuses = Collections.unmodifiableList(new ArrayList<NodeConnectionStatus>(nodeStatuses));
        this.componentRevisions = componentRevisions == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<ComponentRevision>(componentRevisions));
    }

    public ConnectionResponse(int tryLaterSeconds, String explanation) {
        if (tryLaterSeconds <= 0) {
            throw new IllegalArgumentException("Try-Later seconds must be nonnegative: " + tryLaterSeconds);
        }
        this.dataFlow = null;
        this.nodeIdentifier = null;
        this.tryLaterSeconds = tryLaterSeconds;
        this.rejectionReason = explanation;
        this.instanceId = null;
        this.nodeStatuses = null;
        this.componentRevisions = null;
    }

    private ConnectionResponse(String rejectionReason) {
        this.dataFlow = null;
        this.nodeIdentifier = null;
        this.tryLaterSeconds = 0;
        this.rejectionReason = rejectionReason;
        this.instanceId = null;
        this.nodeStatuses = null;
        this.componentRevisions = null;
    }

    public static ConnectionResponse createBlockedByFirewallResponse() {
        return new ConnectionResponse("Blocked by Firewall");
    }

    public static ConnectionResponse createConflictingNodeIdResponse(String otherNode) {
        return new ConnectionResponse("The Node Identifier provided already belongs to node " + otherNode);
    }

    public static ConnectionResponse createRejectionResponse(String explanation) {
        return new ConnectionResponse(explanation);
    }

    public boolean shouldTryLater() {
        return this.tryLaterSeconds > 0;
    }

    public String getRejectionReason() {
        return this.rejectionReason;
    }

    public int getTryLaterSeconds() {
        return this.tryLaterSeconds;
    }

    public DataFlow getDataFlow() {
        return this.dataFlow;
    }

    public NodeIdentifier getNodeIdentifier() {
        return this.nodeIdentifier;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public List<NodeConnectionStatus> getNodeConnectionStatuses() {
        return this.nodeStatuses;
    }

    public List<ComponentRevision> getComponentRevisions() {
        return this.componentRevisions;
    }
}

