/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.logging.repository;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.logging.LogLevel;
import org.apache.nifi.logging.LogMessage;
import org.apache.nifi.logging.LogObserver;
import org.apache.nifi.logging.LogRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;

public class StandardLogRepository
implements LogRepository {
    private final Map<LogLevel, Collection<LogObserver>> observers = new EnumMap<LogLevel, Collection<LogObserver>>(LogLevel.class);
    private final Map<String, LogObserver> observerLookup = new HashMap<String, LogObserver>();
    private final ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.rwLock.readLock();
    private final Lock writeLock = this.rwLock.writeLock();
    private final Logger logger = LoggerFactory.getLogger(StandardLogRepository.class);
    private volatile ComponentLog componentLogger;

    public void addLogMessage(LogMessage logMessage) {
        LogLevel logLevel = logMessage.getLogLevel();
        Collection<LogObserver> logObservers = this.observers.get(logLevel);
        if (logObservers != null) {
            for (LogObserver observer : logObservers) {
                try {
                    observer.onLogMessage(logMessage);
                }
                catch (Exception observerThrowable) {
                    this.logger.error("Failed to pass log message to Observer {} due to {}", (Object)observer, (Object)observerThrowable.toString());
                }
            }
        }
    }

    public void addLogMessage(LogLevel level, String format, Object[] params) {
        Optional<String> flowFileUuid = this.getFirstFlowFileUuidFromObjects(params);
        this.simplifyArgs(params);
        String formattedMessage = MessageFormatter.arrayFormat((String)format, (Object[])params).getMessage();
        LogMessage logMessage = new LogMessage.Builder(System.currentTimeMillis(), level).message(formattedMessage).flowFileUuid((String)flowFileUuid.orElse(null)).createLogMessage();
        this.addLogMessage(logMessage);
    }

    public void addLogMessage(LogLevel level, String format, Object[] params, Throwable t) {
        Optional<String> flowFileUuid = this.getFirstFlowFileUuidFromObjects(params);
        this.simplifyArgs(params);
        String formattedMessage = MessageFormatter.arrayFormat((String)format, (Object[])params, (Throwable)t).getMessage();
        LogMessage logMessage = new LogMessage.Builder(System.currentTimeMillis(), level).message(formattedMessage).throwable(t).flowFileUuid((String)flowFileUuid.orElse(null)).createLogMessage();
        this.addLogMessage(logMessage);
    }

    private Optional<String> getFirstFlowFileUuidFromObjects(Object[] params) {
        int flowFileCount = 0;
        FlowFile flowFileFound = null;
        for (Object param : params) {
            if (!(param instanceof FlowFile)) continue;
            if (++flowFileCount > 1) {
                return Optional.empty();
            }
            flowFileFound = (FlowFile)param;
        }
        return Optional.ofNullable(flowFileFound).map(ff -> ff.getAttribute(CoreAttributes.UUID.key()));
    }

    private void simplifyArgs(Object[] params) {
        for (int i = 0; i < params.length; ++i) {
            params[i] = this.simplifyArg(params[i]);
        }
    }

    private Object simplifyArg(Object param) {
        if (param instanceof Throwable) {
            return ((Throwable)param).getLocalizedMessage();
        }
        if (param instanceof FlowFile) {
            FlowFile flowFile = (FlowFile)param;
            return "FlowFile[filename=" + flowFile.getAttribute(CoreAttributes.FILENAME.key()) + "]";
        }
        return param;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObservationLevel(String observerIdentifier, LogLevel level) {
        this.writeLock.lock();
        try {
            LogObserver observer = this.removeObserver(observerIdentifier);
            if (observer != null) {
                this.addObserver(observerIdentifier, level, observer);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogLevel getObservationLevel(String observerIdentifier) {
        this.readLock.lock();
        try {
            if (!this.observerLookup.containsKey(observerIdentifier)) {
                throw new IllegalStateException("The specified observer identifier does not exist.");
            }
            LogObserver observer = this.observerLookup.get(observerIdentifier);
            for (LogLevel logLevel : LogLevel.values()) {
                Collection<LogObserver> levelObservers = this.observers.get(logLevel);
                if (levelObservers == null || !levelObservers.contains(observer)) continue;
                LogLevel logLevel2 = logLevel;
                return logLevel2;
            }
            LogLevel logLevel = LogLevel.NONE;
            return logLevel;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObserver(String observerIdentifier, LogLevel minimumLevel, LogObserver observer) {
        this.writeLock.lock();
        try {
            if (this.observerLookup.containsKey(observerIdentifier)) {
                throw new IllegalStateException("Cannot add Log Observer for " + observer.getComponentDescription() + " because the specified observer identifier (" + observerIdentifier + ") already exists.");
            }
            LogLevel[] allLevels = LogLevel.values();
            for (int i = minimumLevel.ordinal(); i < allLevels.length; ++i) {
                if (i == LogLevel.NONE.ordinal()) continue;
                Collection collection = this.observers.computeIfAbsent(allLevels[i], k -> new ArrayList());
                collection.add(observer);
            }
            this.observerLookup.put(observerIdentifier, observer);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogObserver removeObserver(String observerIdentifier) {
        this.writeLock.lock();
        try {
            LogObserver observer = this.observerLookup.get(observerIdentifier);
            for (Collection<LogObserver> collection : this.observers.values()) {
                collection.remove(observer);
            }
            LogObserver logObserver = this.observerLookup.remove(observerIdentifier);
            return logObserver;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void removeAllObservers() {
        this.writeLock.lock();
        try {
            this.observers.clear();
            this.observerLookup.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void setLogger(ComponentLog componentLogger) {
        this.componentLogger = componentLogger;
    }

    public ComponentLog getLogger() {
        return this.componentLogger;
    }

    private boolean hasObserver(LogLevel logLevel) {
        Collection<LogObserver> logLevelObservers = this.observers.get(logLevel);
        return logLevelObservers != null && !logLevelObservers.isEmpty();
    }

    public boolean isDebugEnabled() {
        return this.hasObserver(LogLevel.DEBUG);
    }

    public boolean isInfoEnabled() {
        return this.hasObserver(LogLevel.INFO);
    }

    public boolean isWarnEnabled() {
        return this.hasObserver(LogLevel.WARN);
    }

    public boolean isErrorEnabled() {
        return this.hasObserver(LogLevel.ERROR);
    }
}

