/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.init;

import org.apache.nifi.components.ConfigurableComponent;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.init.ConfigurableComponentInitializer;
import org.apache.nifi.init.ControllerServiceInitializer;
import org.apache.nifi.init.ProcessorInitializer;
import org.apache.nifi.init.ReportingTaskingInitializer;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.reporting.ReportingTask;

public class ConfigurableComponentInitializerFactory {
    public static ConfigurableComponentInitializer createComponentInitializer(ExtensionManager extensionManager, Class<? extends ConfigurableComponent> componentClass) {
        if (Processor.class.isAssignableFrom(componentClass)) {
            return new ProcessorInitializer(extensionManager);
        }
        if (ControllerService.class.isAssignableFrom(componentClass)) {
            return new ControllerServiceInitializer(extensionManager);
        }
        if (ReportingTask.class.isAssignableFrom(componentClass)) {
            return new ReportingTaskingInitializer(extensionManager);
        }
        return null;
    }
}

