/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.nar;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.apache.nifi.annotation.behavior.RequiresInstanceClassLoading;
import org.apache.nifi.authentication.LoginIdentityProvider;
import org.apache.nifi.authorization.AccessPolicyProvider;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.UserGroupProvider;
import org.apache.nifi.bundle.Bundle;
import org.apache.nifi.components.Validator;
import org.apache.nifi.components.state.StateProvider;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.repository.ContentRepository;
import org.apache.nifi.controller.repository.FlowFileRepository;
import org.apache.nifi.controller.repository.FlowFileSwapManager;
import org.apache.nifi.controller.status.history.StatusHistoryRepository;
import org.apache.nifi.flowanalysis.FlowAnalysisRule;
import org.apache.nifi.flowfile.FlowFilePrioritizer;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.nar.InstanceClassLoader;
import org.apache.nifi.nar.NarClassLoader;
import org.apache.nifi.parameter.ParameterProvider;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processor.io.InputStreamCallback;
import org.apache.nifi.processor.io.OutputStreamCallback;
import org.apache.nifi.processor.io.StreamCallback;
import org.apache.nifi.provenance.ProvenanceRepository;
import org.apache.nifi.registry.flow.FlowRegistryClient;
import org.apache.nifi.reporting.ReportingTask;
import org.apache.nifi.util.NiFiProperties;

public class NarThreadContextClassLoader
extends URLClassLoader {
    private final ClassLoader forward = ClassLoader.getSystemClassLoader();
    private static final List<Class<?>> narSpecificClasses = new ArrayList();

    private NarThreadContextClassLoader() {
        super(new URL[0]);
    }

    @Override
    public void clearAssertionStatus() {
        this.lookupClassLoader().clearAssertionStatus();
    }

    @Override
    public URL getResource(String name) {
        return this.lookupClassLoader().getResource(name);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        return this.lookupClassLoader().getResourceAsStream(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        return this.lookupClassLoader().getResources(name);
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.lookupClassLoader().loadClass(name);
    }

    @Override
    public void setClassAssertionStatus(String className, boolean enabled) {
        this.lookupClassLoader().setClassAssertionStatus(className, enabled);
    }

    @Override
    public void setDefaultAssertionStatus(boolean enabled) {
        this.lookupClassLoader().setDefaultAssertionStatus(enabled);
    }

    @Override
    public void setPackageAssertionStatus(String packageName, boolean enabled) {
        this.lookupClassLoader().setPackageAssertionStatus(packageName, enabled);
    }

    private ClassLoader lookupClassLoader() {
        StackWalker walker = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
        Optional callerClassLoader = walker.walk(s -> s.map(StackWalker.StackFrame::getDeclaringClass).map(this::findNarClass).filter(Objects::nonNull).map(Class::getClassLoader).map(cl -> cl instanceof NarClassLoader ? cl : null).filter(Objects::nonNull).findFirst());
        callerClassLoader.ifPresent(Thread.currentThread()::setContextClassLoader);
        return callerClassLoader.orElse(this.forward);
    }

    private Class<?> findNarClass(Class<?> cls) {
        for (Class<?> narClass : narSpecificClasses) {
            if (narClass.isAssignableFrom(cls)) {
                return cls;
            }
            if (cls.getEnclosingClass() == null) continue;
            return this.findNarClass(cls.getEnclosingClass());
        }
        return null;
    }

    public static NarThreadContextClassLoader getInstance() {
        return SingletonHolder.instance;
    }

    public static <T> T createInstance(ExtensionManager extensionManager, String implementationClassName, Class<T> typeDefinition, NiFiProperties nifiProperties) throws InstantiationException, IllegalAccessException, ClassNotFoundException, InvocationTargetException, NoSuchMethodException {
        return NarThreadContextClassLoader.createInstance(extensionManager, implementationClassName, typeDefinition, nifiProperties, UUID.randomUUID().toString());
    }

    public static <T> T createInstance(ExtensionManager extensionManager, String implementationClassName, Class<T> typeDefinition, NiFiProperties nifiProperties, String instanceId) throws InstantiationException, IllegalAccessException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Constructor<T> constructor;
            block15: {
                T nsme2;
                List<Bundle> bundles = extensionManager.getBundles(implementationClassName);
                if (bundles.size() == 0) {
                    throw new IllegalStateException(String.format("The specified implementation class '%s' is not known to this nifi.", implementationClassName));
                }
                if (bundles.size() > 1) {
                    throw new IllegalStateException(String.format("More than one bundle was found for the specified implementation class '%s', only one is allowed.", implementationClassName));
                }
                Bundle bundle = bundles.get(0);
                ClassLoader instanceClassLoader = NarThreadContextClassLoader.createClassLoader(implementationClassName, instanceId, bundle, extensionManager);
                Class<?> instanceClass = Class.forName(implementationClassName, true, instanceClassLoader);
                Thread.currentThread().setContextClassLoader(instanceClassLoader);
                Class<T> desiredClass = instanceClass.asSubclass(typeDefinition);
                if (nifiProperties == null) {
                    T t = typeDefinition.cast(desiredClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                    return t;
                }
                constructor = null;
                try {
                    constructor = desiredClass.getConstructor(NiFiProperties.class);
                }
                catch (NoSuchMethodException nsme2) {
                    try {
                        constructor = desiredClass.getConstructor(new Class[0]);
                    }
                    catch (NoSuchMethodException nsme22) {
                        throw new IllegalStateException("Failed to find constructor which takes NiFiProperties as argument as well as the default constructor on " + desiredClass.getName(), nsme22);
                    }
                }
                try {
                    if (constructor.getParameterTypes().length != 0) break block15;
                    nsme2 = typeDefinition.cast(constructor.newInstance(new Object[0]));
                }
                catch (InvocationTargetException ite) {
                    throw new IllegalStateException("Failed to instantiate a component due to (see target exception)", ite);
                }
                return nsme2;
            }
            T nsme2 = typeDefinition.cast(constructor.newInstance(nifiProperties));
            return nsme2;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    private static ClassLoader createClassLoader(String implementationClassName, String instanceId, Bundle bundle, ExtensionManager extensionManager) throws ClassNotFoundException {
        ClassLoader bundleClassLoader = bundle.getClassLoader();
        Class<?> rawClass = Class.forName(implementationClassName, true, bundleClassLoader);
        RequiresInstanceClassLoading instanceClassLoadingAnnotation = rawClass.getAnnotation(RequiresInstanceClassLoading.class);
        if (instanceClassLoadingAnnotation == null) {
            return bundleClassLoader;
        }
        LinkedHashSet<URL> instanceUrls = new LinkedHashSet<URL>();
        LinkedHashSet<File> narNativeLibDirs = new LinkedHashSet<File>();
        NarClassLoader narBundleClassLoader = (NarClassLoader)bundleClassLoader;
        narNativeLibDirs.add(narBundleClassLoader.getNARNativeLibDir());
        instanceUrls.addAll(Arrays.asList(narBundleClassLoader.getURLs()));
        ClassLoader ancestorClassLoader = narBundleClassLoader.getParent();
        if (instanceClassLoadingAnnotation.cloneAncestorResources()) {
            Bundle ancestorNarBundle;
            while (ancestorClassLoader instanceof NarClassLoader && (ancestorNarBundle = extensionManager.getBundle(ancestorClassLoader)) != null && !ancestorNarBundle.getBundleDetails().getCoordinate().getId().equals("nifi-jetty-bundle")) {
                NarClassLoader ancestorNarClassLoader = (NarClassLoader)ancestorClassLoader;
                narNativeLibDirs.add(ancestorNarClassLoader.getNARNativeLibDir());
                Collections.addAll(instanceUrls, ancestorNarClassLoader.getURLs());
                ancestorClassLoader = ancestorNarClassLoader.getParent();
            }
        }
        InstanceClassLoader instanceClassLoader = new InstanceClassLoader(instanceId, implementationClassName, instanceUrls, Collections.emptySet(), narNativeLibDirs, ancestorClassLoader);
        extensionManager.registerInstanceClassLoader(instanceId, instanceClassLoader);
        return instanceClassLoader;
    }

    static {
        narSpecificClasses.add(Processor.class);
        narSpecificClasses.add(FlowFilePrioritizer.class);
        narSpecificClasses.add(ReportingTask.class);
        narSpecificClasses.add(FlowAnalysisRule.class);
        narSpecificClasses.add(ParameterProvider.class);
        narSpecificClasses.add(Validator.class);
        narSpecificClasses.add(InputStreamCallback.class);
        narSpecificClasses.add(OutputStreamCallback.class);
        narSpecificClasses.add(StreamCallback.class);
        narSpecificClasses.add(ControllerService.class);
        narSpecificClasses.add(Authorizer.class);
        narSpecificClasses.add(UserGroupProvider.class);
        narSpecificClasses.add(AccessPolicyProvider.class);
        narSpecificClasses.add(LoginIdentityProvider.class);
        narSpecificClasses.add(ProvenanceRepository.class);
        narSpecificClasses.add(StatusHistoryRepository.class);
        narSpecificClasses.add(FlowFileRepository.class);
        narSpecificClasses.add(FlowFileSwapManager.class);
        narSpecificClasses.add(ContentRepository.class);
        narSpecificClasses.add(StateProvider.class);
        narSpecificClasses.add(FlowRegistryClient.class);
    }

    private static class SingletonHolder {
        public static final NarThreadContextClassLoader instance = new NarThreadContextClassLoader();

        private SingletonHolder() {
        }
    }
}

