/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.hadoop;

import java.util.HashMap;
import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.apache.hadoop.security.authentication.util.KerberosUtil;

public class KerberosConfiguration
extends Configuration {
    private static final Map<String, String> USER_KERBEROS_OPTIONS = new HashMap<String, String>();
    private static final AppConfigurationEntry USER_KERBEROS_LOGIN;
    private static final AppConfigurationEntry[] USER_KERBEROS_CONF;

    KerberosConfiguration(String principal, String keytab) {
        USER_KERBEROS_OPTIONS.put("principal", principal);
        USER_KERBEROS_OPTIONS.put("keyTab", keytab);
    }

    @Override
    public AppConfigurationEntry[] getAppConfigurationEntry(String appName) {
        return USER_KERBEROS_CONF;
    }

    static {
        USER_KERBEROS_OPTIONS.put("doNotPrompt", "true");
        USER_KERBEROS_OPTIONS.put("useKeyTab", "true");
        USER_KERBEROS_OPTIONS.put("refreshKrb5Config", "true");
        USER_KERBEROS_LOGIN = new AppConfigurationEntry(KerberosUtil.getKrb5LoginModuleName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, USER_KERBEROS_OPTIONS);
        USER_KERBEROS_CONF = new AppConfigurationEntry[]{USER_KERBEROS_LOGIN};
    }
}

