/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.hbase;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.Validator;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.hbase.DeleteRequest;
import org.apache.nifi.hbase.put.PutColumn;
import org.apache.nifi.hbase.put.PutFlowFile;
import org.apache.nifi.hbase.scan.Column;
import org.apache.nifi.hbase.scan.ResultHandler;
import org.apache.nifi.hbase.validate.ConfigFilesValidator;
import org.apache.nifi.processor.util.StandardValidators;

@Tags(value={"hbase", "client"})
@CapabilityDescription(value="A controller service for accessing an HBase client.")
public interface HBaseClientService
extends ControllerService {
    public static final PropertyDescriptor HADOOP_CONF_FILES = new PropertyDescriptor.Builder().name("Hadoop Configuration Files").description("Comma-separated list of Hadoop Configuration files, such as hbase-site.xml and core-site.xml for kerberos, including full paths to the files.").addValidator((Validator)new ConfigFilesValidator()).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    public static final PropertyDescriptor ZOOKEEPER_QUORUM = new PropertyDescriptor.Builder().name("ZooKeeper Quorum").description("Comma-separated list of ZooKeeper hosts for HBase. Required if Hadoop Configuration Files are not provided.").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    public static final PropertyDescriptor ZOOKEEPER_CLIENT_PORT = new PropertyDescriptor.Builder().name("ZooKeeper Client Port").description("The port on which ZooKeeper is accepting client connections. Required if Hadoop Configuration Files are not provided.").addValidator(StandardValidators.PORT_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    public static final PropertyDescriptor ZOOKEEPER_ZNODE_PARENT = new PropertyDescriptor.Builder().name("ZooKeeper ZNode Parent").description("The ZooKeeper ZNode Parent value for HBase (example: /hbase). Required if Hadoop Configuration Files are not provided.").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    public static final PropertyDescriptor HBASE_CLIENT_RETRIES = new PropertyDescriptor.Builder().name("HBase Client Retries").description("The number of times the HBase client will retry connecting. Required if Hadoop Configuration Files are not provided.").addValidator(StandardValidators.POSITIVE_INTEGER_VALIDATOR).defaultValue("1").expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    public static final PropertyDescriptor PHOENIX_CLIENT_JAR_LOCATION = new PropertyDescriptor.Builder().name("Phoenix Client JAR Location").description("The full path to the Phoenix client JAR. Required if Phoenix is installed on top of HBase.").addValidator(StandardValidators.FILE_EXISTS_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).dynamicallyModifiesClasspath(true).build();

    public void put(String var1, Collection<PutFlowFile> var2) throws IOException;

    public void put(String var1, byte[] var2, Collection<PutColumn> var3) throws IOException;

    public boolean checkAndPut(String var1, byte[] var2, byte[] var3, byte[] var4, byte[] var5, PutColumn var6) throws IOException;

    public void delete(String var1, byte[] var2) throws IOException;

    public void delete(String var1, byte[] var2, String var3) throws IOException;

    public void delete(String var1, List<byte[]> var2) throws IOException;

    public void deleteCells(String var1, List<DeleteRequest> var2) throws IOException;

    public void delete(String var1, List<byte[]> var2, String var3) throws IOException;

    public void scan(String var1, Collection<Column> var2, String var3, long var4, ResultHandler var6) throws IOException;

    public void scan(String var1, Collection<Column> var2, String var3, long var4, List<String> var6, ResultHandler var7) throws IOException;

    public void scan(String var1, byte[] var2, byte[] var3, Collection<Column> var4, List<String> var5, ResultHandler var6) throws IOException;

    public void scan(String var1, String var2, String var3, String var4, Long var5, Long var6, Integer var7, Boolean var8, Collection<Column> var9, List<String> var10, ResultHandler var11) throws IOException;

    public byte[] toBytes(boolean var1);

    public byte[] toBytes(float var1);

    public byte[] toBytes(int var1);

    public byte[] toBytes(long var1);

    public byte[] toBytes(double var1);

    public byte[] toBytes(String var1);

    public byte[] toBytesBinary(String var1);

    default public String toTransitUri(String tableName, String rowKey) {
        return "hbase://" + tableName + (rowKey != null && !rowKey.isEmpty() ? "/" + rowKey : "");
    }
}

