/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.dbcp;

import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.behavior.RequiresInstanceClassLoading;
import org.apache.nifi.annotation.behavior.Restricted;
import org.apache.nifi.annotation.behavior.Restriction;
import org.apache.nifi.annotation.behavior.SupportsSensitiveDynamicProperties;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnDisabled;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.RequiredPermission;
import org.apache.nifi.components.Validator;
import org.apache.nifi.components.resource.ResourceCardinality;
import org.apache.nifi.components.resource.ResourceType;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.dbcp.ConnectionUrlValidator;
import org.apache.nifi.dbcp.DBCPService;
import org.apache.nifi.dbcp.DBCPValidator;
import org.apache.nifi.dbcp.DriverClassValidator;
import org.apache.nifi.expression.AttributeExpression;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.kerberos.KerberosUserService;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.security.krb.KerberosAction;
import org.apache.nifi.security.krb.KerberosUser;

@RequiresInstanceClassLoading
@Tags(value={"dbcp", "hikari", "jdbc", "database", "connection", "pooling", "store"})
@CapabilityDescription(value="Provides Database Connection Pooling Service based on HikariCP. Connections can be asked from pool and returned after usage.")
@SupportsSensitiveDynamicProperties
@DynamicProperty(name="JDBC property name", value="JDBC property value", expressionLanguageScope=ExpressionLanguageScope.ENVIRONMENT, description="Specifies a property name and value to be set on the JDBC connection(s). If Expression Language is used, evaluation will be performed upon the controller service being enabled. Note that no flow file input (attributes, e.g.) is available for use in Expression Language constructs for these properties.")
@Restricted(restrictions={@Restriction(requiredPermission=RequiredPermission.REFERENCE_REMOTE_RESOURCES, explanation="Database Driver Location can reference resources over HTTP")})
public class HikariCPConnectionPool
extends AbstractControllerService
implements DBCPService {
    protected static final String SENSITIVE_PROPERTY_PREFIX = "SENSITIVE.";
    protected static final long INFINITE_MILLISECONDS = -1L;
    private static final String DEFAULT_TOTAL_CONNECTIONS = "10";
    private static final String DEFAULT_MAX_CONN_LIFETIME = "-1";
    public static final PropertyDescriptor DATABASE_URL = new PropertyDescriptor.Builder().name("hikaricp-connection-url").displayName("Database Connection URL").description("A database connection URL used to connect to a database. May contain database system name, host, port, database name and some parameters. The exact syntax of a database connection URL is specified by your DBMS.").addValidator((Validator)new ConnectionUrlValidator()).required(true).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).build();
    public static final PropertyDescriptor DB_DRIVERNAME = new PropertyDescriptor.Builder().name("hikaricp-driver-classname").displayName("Database Driver Class Name").description("The fully-qualified class name of the JDBC driver. Example: com.mysql.jdbc.Driver").required(true).addValidator((Validator)new DriverClassValidator()).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).build();
    public static final PropertyDescriptor DB_DRIVER_LOCATION = new PropertyDescriptor.Builder().name("hikaricp-driver-locations").displayName("Database Driver Location(s)").description("Comma-separated list of files/folders and/or URLs containing the driver JAR and its dependencies (if any). For example '/var/tmp/mariadb-java-client-1.1.7.jar'").required(false).identifiesExternalResource(ResourceCardinality.MULTIPLE, ResourceType.FILE, new ResourceType[]{ResourceType.DIRECTORY, ResourceType.URL}).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).dynamicallyModifiesClasspath(true).build();
    public static final PropertyDescriptor DB_USER = new PropertyDescriptor.Builder().name("hikaricp-username").displayName("Database User").description("Database user name").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).build();
    public static final PropertyDescriptor DB_PASSWORD = new PropertyDescriptor.Builder().name("hikaricp-password").displayName("Password").description("The password for the database user").required(false).sensitive(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).build();
    public static final PropertyDescriptor MAX_WAIT_TIME = new PropertyDescriptor.Builder().name("hikaricp-max-wait-time").displayName("Max Wait Time").description("The maximum amount of time that the pool will wait (when there are no available connections)  for a connection to be returned before failing, or 0 <time units> to wait indefinitely. ").defaultValue("500 millis").required(true).addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).sensitive(false).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).build();
    public static final PropertyDescriptor MAX_TOTAL_CONNECTIONS = new PropertyDescriptor.Builder().name("hikaricp-max-total-conns").displayName("Max Total Connections").description("This property controls the maximum size that the pool is allowed to reach, including both idle and in-use connections. Basically this value will determine the maximum number of actual connections to the database backend. A reasonable value for this is best determined by your execution environment. When the pool reaches this size, and no idle connections are available, the service will block for up to connectionTimeout milliseconds before timing out.").defaultValue("10").required(true).addValidator(StandardValidators.INTEGER_VALIDATOR).sensitive(false).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).build();
    public static final PropertyDescriptor VALIDATION_QUERY = new PropertyDescriptor.Builder().name("hikaricp-validation-query").displayName("Validation Query").description("Validation Query used to validate connections before returning them. When connection is invalid, it gets dropped and new valid connection will be returned. NOTE: Using validation might have some performance penalty.").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).build();
    public static final PropertyDescriptor MIN_IDLE = new PropertyDescriptor.Builder().name("hikaricp-min-idle-conns").displayName("Minimum Idle Connections").description("This property controls the minimum number of idle connections that HikariCP tries to maintain in the pool. If the idle connections dip below this value and total connections in the pool are less than 'Max Total Connections', HikariCP will make a best effort to add additional connections quickly and efficiently. It is recommended that this property to be set equal to 'Max Total Connections'.").defaultValue("10").required(true).addValidator(StandardValidators.NON_NEGATIVE_INTEGER_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).build();
    public static final PropertyDescriptor MAX_CONN_LIFETIME = new PropertyDescriptor.Builder().name("hikaricp-max-conn-lifetime").displayName("Max Connection Lifetime").description("The maximum lifetime of a connection. After this time is exceeded the connection will fail the next activation, passivation or validation test. A value of zero or less means the connection has an infinite lifetime.").defaultValue("-1").required(false).addValidator(DBCPValidator.CUSTOM_TIME_PERIOD_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).build();
    public static final PropertyDescriptor KERBEROS_USER_SERVICE = new PropertyDescriptor.Builder().name("hikaricp-kerberos-user-service").displayName("Kerberos User Service").description("Specifies the Kerberos User Controller Service that should be used for authenticating with Kerberos").identifiesControllerService(KerberosUserService.class).required(false).build();
    private static final List<PropertyDescriptor> properties;
    private volatile HikariDataSource dataSource;
    private volatile KerberosUser kerberosUser;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return properties;
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        PropertyDescriptor.Builder builder = new PropertyDescriptor.Builder().name(propertyDescriptorName).required(false).dynamic(true).addValidator(StandardValidators.createAttributeExpressionLanguageValidator((AttributeExpression.ResultType)AttributeExpression.ResultType.STRING, (boolean)true)).addValidator(StandardValidators.ATTRIBUTE_KEY_PROPERTY_NAME_VALIDATOR);
        if (propertyDescriptorName.startsWith(SENSITIVE_PROPERTY_PREFIX)) {
            builder.sensitive(true).expressionLanguageSupported(ExpressionLanguageScope.NONE);
        } else {
            builder.expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT);
        }
        return builder.build();
    }

    @OnEnabled
    public void onConfigured(ConfigurationContext context) {
        String driverName = context.getProperty(DB_DRIVERNAME).evaluateAttributeExpressions().getValue();
        String user = context.getProperty(DB_USER).evaluateAttributeExpressions().getValue();
        String passw = context.getProperty(DB_PASSWORD).evaluateAttributeExpressions().getValue();
        String dburl = context.getProperty(DATABASE_URL).evaluateAttributeExpressions().getValue();
        Integer maxTotal = context.getProperty(MAX_TOTAL_CONNECTIONS).evaluateAttributeExpressions().asInteger();
        String validationQuery = context.getProperty(VALIDATION_QUERY).evaluateAttributeExpressions().getValue();
        long maxWaitMillis = this.extractMillisWithInfinite(context.getProperty(MAX_WAIT_TIME).evaluateAttributeExpressions());
        int minIdle = context.getProperty(MIN_IDLE).evaluateAttributeExpressions().asInteger();
        long maxConnLifetimeMillis = this.extractMillisWithInfinite(context.getProperty(MAX_CONN_LIFETIME).evaluateAttributeExpressions());
        KerberosUserService kerberosUserService = (KerberosUserService)context.getProperty(KERBEROS_USER_SERVICE).asControllerService(KerberosUserService.class);
        if (kerberosUserService != null) {
            this.kerberosUser = kerberosUserService.createKerberosUser();
            if (this.kerberosUser != null) {
                this.kerberosUser.login();
            }
        }
        this.dataSource = new HikariDataSource();
        this.dataSource.setDriverClassName(driverName);
        this.dataSource.setConnectionTimeout(maxWaitMillis);
        this.dataSource.setMaximumPoolSize(maxTotal.intValue());
        this.dataSource.setMinimumIdle(minIdle);
        this.dataSource.setMaxLifetime(maxConnLifetimeMillis);
        if (validationQuery != null && !validationQuery.isEmpty()) {
            this.dataSource.setConnectionTestQuery(validationQuery);
        }
        this.dataSource.setJdbcUrl(dburl);
        this.dataSource.setUsername(user);
        this.dataSource.setPassword(passw);
        List<PropertyDescriptor> dynamicProperties = context.getProperties().keySet().stream().filter(PropertyDescriptor::isDynamic).collect(Collectors.toList());
        Properties properties = this.dataSource.getDataSourceProperties();
        dynamicProperties.forEach(descriptor -> {
            PropertyValue propertyValue = context.getProperty(descriptor);
            if (descriptor.isSensitive()) {
                String propertyName = StringUtils.substringAfter((String)descriptor.getName(), (String)SENSITIVE_PROPERTY_PREFIX);
                properties.setProperty(propertyName, propertyValue.getValue());
            } else {
                properties.setProperty(descriptor.getName(), propertyValue.evaluateAttributeExpressions().getValue());
            }
        });
        this.dataSource.setDataSourceProperties(properties);
        this.dataSource.setPoolName(this.toString());
    }

    private long extractMillisWithInfinite(PropertyValue prop) {
        return DEFAULT_MAX_CONN_LIFETIME.equals(prop.getValue()) ? -1L : prop.asTimePeriod(TimeUnit.MILLISECONDS);
    }

    @OnDisabled
    public void shutdown() {
        try {
            if (this.kerberosUser != null) {
                this.kerberosUser.logout();
            }
        }
        finally {
            this.kerberosUser = null;
            try {
                if (this.dataSource != null) {
                    this.dataSource.close();
                }
            }
            finally {
                this.dataSource = null;
            }
        }
    }

    public Connection getConnection() throws ProcessException {
        try {
            Connection con;
            if (this.kerberosUser != null) {
                KerberosAction kerberosAction = new KerberosAction(this.kerberosUser, () -> this.dataSource.getConnection(), this.getLogger());
                con = (Connection)kerberosAction.execute();
            } else {
                con = this.dataSource.getConnection();
            }
            return con;
        }
        catch (SQLException e) {
            if (this.kerberosUser != null) {
                this.getLogger().info("Error getting connection, performing Kerberos re-login");
                this.kerberosUser.login();
            }
            throw new ProcessException("Connection retrieval failed", (Throwable)e);
        }
    }

    public String toString() {
        return String.format("%s[id=%s]", ((Object)((Object)this)).getClass().getSimpleName(), this.getIdentifier());
    }

    HikariDataSource getDataSource() {
        return this.dataSource;
    }

    static {
        ArrayList<PropertyDescriptor> props = new ArrayList<PropertyDescriptor>();
        props.add(DATABASE_URL);
        props.add(DB_DRIVERNAME);
        props.add(DB_DRIVER_LOCATION);
        props.add(KERBEROS_USER_SERVICE);
        props.add(DB_USER);
        props.add(DB_PASSWORD);
        props.add(MAX_WAIT_TIME);
        props.add(MAX_TOTAL_CONNECTIONS);
        props.add(VALIDATION_QUERY);
        props.add(MIN_IDLE);
        props.add(MAX_CONN_LIFETIME);
        properties = Collections.unmodifiableList(props);
    }
}

