/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.lookup;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.behavior.Restricted;
import org.apache.nifi.annotation.behavior.Restriction;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnDisabled;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.RequiredPermission;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.controller.ControllerServiceInitializationContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.lookup.AbstractCSVLookupService;
import org.apache.nifi.lookup.LookupFailureException;
import org.apache.nifi.lookup.StringLookupService;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.reporting.InitializationException;

@Tags(value={"lookup", "cache", "enrich", "join", "csv", "reloadable", "key", "value"})
@CapabilityDescription(value="A reloadable CSV file-based lookup service. The first line of the csv file is considered as header.")
@Restricted(restrictions={@Restriction(requiredPermission=RequiredPermission.READ_FILESYSTEM, explanation="Provides operator the ability to read from any file that NiFi has access to.")})
public class SimpleCsvFileLookupService
extends AbstractCSVLookupService
implements StringLookupService {
    private static final Set<String> REQUIRED_KEYS = Collections.unmodifiableSet(Stream.of("key").collect(Collectors.toSet()));
    public static final PropertyDescriptor LOOKUP_VALUE_COLUMN = new PropertyDescriptor.Builder().name("lookup-value-column").displayName("Lookup Value Column").description("Lookup value column.").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    private volatile ConcurrentMap<String, String> cache;
    private volatile String lookupValueColumn;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void loadCache() throws IllegalStateException, IOException {
        if (this.lock.tryLock()) {
            try {
                ComponentLog logger = this.getLogger();
                if (logger.isDebugEnabled()) {
                    logger.debug("Loading lookup table from file: " + this.csvFile);
                }
                HashMap<String, String> properties = new HashMap<String, String>();
                try (FileInputStream is = new FileInputStream(this.csvFile);
                     InputStreamReader reader = new InputStreamReader((InputStream)is, this.charset);){
                    CSVParser records = this.csvFormat.withFirstRecordAsHeader().parse((Reader)reader);
                    for (CSVRecord record : records) {
                        String key = record.get(this.lookupKeyColumn);
                        String value = record.get(this.lookupValueColumn);
                        if (StringUtils.isBlank((CharSequence)key)) {
                            throw new IllegalStateException("Empty lookup key encountered in: " + this.csvFile);
                        }
                        if (!this.ignoreDuplicates && properties.containsKey(key)) {
                            throw new IllegalStateException("Duplicate lookup key encountered: " + key + " in " + this.csvFile);
                        }
                        if (this.ignoreDuplicates && properties.containsKey(key)) {
                            logger.warn("Duplicate lookup key encountered: {} in {}", new Object[]{key, this.csvFile});
                        }
                        properties.put(key, value);
                    }
                }
                this.cache = new ConcurrentHashMap<String, String>(properties);
                if (this.cache.isEmpty()) {
                    logger.warn("Lookup table is empty after reading file: " + this.csvFile);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    @Override
    protected void init(ControllerServiceInitializationContext context) {
        super.init(context);
        this.properties.add(LOOKUP_VALUE_COLUMN);
    }

    @Override
    @OnEnabled
    public void onEnabled(ConfigurationContext context) throws IOException, InitializationException {
        super.onEnabled(context);
        this.lookupValueColumn = context.getProperty(LOOKUP_VALUE_COLUMN).evaluateAttributeExpressions().getValue();
        try {
            this.loadCache();
        }
        catch (IllegalStateException e) {
            throw new InitializationException(e.getMessage(), (Throwable)e);
        }
    }

    public Optional<String> lookup(Map<String, Object> coordinates) throws LookupFailureException {
        if (coordinates == null) {
            return Optional.empty();
        }
        String key = coordinates.get("key").toString();
        if (StringUtils.isBlank((CharSequence)key)) {
            return Optional.empty();
        }
        try {
            if (this.watcher != null && this.watcher.checkAndReset()) {
                this.loadCache();
            }
        }
        catch (IOException | IllegalStateException e) {
            throw new LookupFailureException(e.getMessage(), (Throwable)e);
        }
        return Optional.ofNullable(this.cache.get(key));
    }

    public Set<String> getRequiredKeys() {
        return REQUIRED_KEYS;
    }

    @OnDisabled
    public void onDisabled() {
        this.cache = null;
    }

    boolean isCaching() {
        return this.cache != null;
    }
}

