/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.installer.ArtifactInstaller;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.dependency.utils.DependencyStatusSets;
import org.apache.maven.plugin.dependency.utils.DependencyUtil;
import org.apache.maven.plugin.dependency.utils.filters.DestFileFilter;
import org.apache.maven.plugin.dependency.utils.resolvers.DefaultArtifactsResolver;
import org.apache.maven.plugin.dependency.utils.translators.ClassifierTypeTranslator;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.shared.artifact.filter.collection.ArtifactFilterException;
import org.apache.maven.shared.artifact.filter.collection.ArtifactIdFilter;
import org.apache.maven.shared.artifact.filter.collection.ArtifactsFilter;
import org.apache.maven.shared.artifact.filter.collection.ClassifierFilter;
import org.apache.maven.shared.artifact.filter.collection.FilterArtifacts;
import org.apache.maven.shared.artifact.filter.collection.GroupIdFilter;
import org.apache.maven.shared.artifact.filter.collection.ProjectTransitivityFilter;
import org.apache.maven.shared.artifact.filter.collection.ScopeFilter;
import org.apache.maven.shared.artifact.filter.collection.TypeFilter;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.jar.ManifestException;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="nar", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=false, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class NarMojo
extends AbstractMojo {
    private static final String[] DEFAULT_EXCLUDES = new String[]{"**/package.html"};
    private static final String[] DEFAULT_INCLUDES = new String[]{"**/**"};
    private static final String BUILD_TIMESTAMP_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    protected MavenSession session;
    @Parameter(property="includes")
    protected String[] includes;
    @Parameter(property="excludes")
    protected String[] excludes;
    @Parameter(alias="narName", property="nar.finalName", defaultValue="${project.build.finalName}", required=true)
    protected String finalName;
    @Component(role=Archiver.class, hint="jar")
    private JarArchiver jarArchiver;
    @Parameter(property="archive")
    protected final MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    @Parameter(property="defaultManifestFiles", defaultValue="${project.build.outputDirectory}/META-INF/MANIFEST.MF", readonly=true, required=true)
    protected File defaultManifestFile;
    @Parameter(property="nar.useDefaultManifestFile", defaultValue="false")
    protected boolean useDefaultManifestFile;
    @Component
    protected MavenProjectHelper projectHelper;
    @Parameter(property="nar.forceCreation", defaultValue="false")
    protected boolean forceCreation;
    @Parameter(property="classifier")
    protected String classifier;
    @Component
    protected ArtifactInstaller installer;
    @Component
    protected ArtifactRepositoryFactory repositoryFactory;
    @Parameter(property="mdep.failOnMissingClassifierArtifact", defaultValue="true", required=false)
    protected boolean failOnMissingClassifierArtifact = true;
    @Parameter(property="includeTypes", required=false)
    protected String includeTypes;
    @Parameter(property="excludeTypes", required=false)
    protected String excludeTypes;
    @Parameter(property="includeScope", required=false)
    protected String includeScope;
    @Parameter(property="excludeScope", required=false)
    protected String excludeScope;
    @Parameter(property="includeClassifiers", required=false)
    protected String includeClassifiers;
    @Parameter(property="excludeClassifiers", required=false)
    protected String excludeClassifiers;
    @Parameter(property="classifier", required=false)
    protected String copyDepClassifier;
    @Parameter(property="type", required=false, defaultValue="nar")
    protected String type;
    @Parameter(property="excludeArtifacts", required=false)
    protected String excludeArtifactIds;
    @Parameter(property="includeArtifacts", required=false)
    protected String includeArtifactIds;
    @Parameter(property="excludeArtifacts", required=false)
    protected String excludeGroupIds;
    @Parameter(property="includeGroupIds", required=false)
    protected String includeGroupIds;
    @Parameter(property="markersDirectory", required=false, defaultValue="${project.build.directory}/dependency-maven-plugin-markers")
    protected File markersDirectory;
    @Parameter(property="overWriteReleases", required=false)
    protected boolean overWriteReleases;
    @Parameter(property="overWriteSnapshots", required=false)
    protected boolean overWriteSnapshots;
    @Parameter(property="overWriteIfNewer", required=false, defaultValue="true")
    protected boolean overWriteIfNewer;
    @Parameter(property="projectBuildDirectory", required=false, defaultValue="${project.build.directory}")
    protected File projectBuildDirectory;
    @Component
    protected ArtifactFactory factory;
    @Component
    protected ArtifactResolver resolver;
    @Component(role=ArtifactCollector.class)
    protected ArtifactCollector artifactCollector;
    @Component(role=ArtifactMetadataSource.class)
    protected ArtifactMetadataSource artifactMetadataSource;
    @Parameter(property="localRepository", required=true, readonly=true)
    protected ArtifactRepository local;
    @Parameter(property="project.remoteArtifactRepositories", required=true, readonly=true)
    protected List remoteRepos;
    @Component
    protected ArchiverManager archiverManager;
    @Parameter(property="reactorProjects", required=true, readonly=true)
    protected List reactorProjects;
    @Parameter(property="silent", required=false, defaultValue="false")
    public boolean silent;
    @Parameter(property="outputAbsoluteArtifactFilename", defaultValue="false", required=false)
    protected boolean outputAbsoluteArtifactFilename;
    @Parameter(property="narGroup", defaultValue="${project.groupId}", required=true)
    protected String narGroup;
    @Parameter(property="narId", defaultValue="${project.artifactId}", required=true)
    protected String narId;
    @Parameter(property="narVersion", defaultValue="${project.version}", required=true)
    protected String narVersion;
    @Parameter(property="narDependencyGroup", required=false)
    protected String narDependencyGroup = null;
    @Parameter(property="narDependencyId", required=false)
    protected String narDependencyId = null;
    @Parameter(property="narDependencyVersion", required=false)
    protected String narDependencyVersion = null;
    @Parameter(property="buildTag", defaultValue="${project.scm.tag}", required=false)
    protected String buildTag;
    @Parameter(property="buildBranch", defaultValue="${buildBranch}", required=false)
    protected String buildBranch;
    @Parameter(property="buildRevision", defaultValue="${buildRevision}", required=false)
    protected String buildRevision;
    @Parameter(property="cloneDuringInstanceClassLoading", defaultValue="false", required=false)
    protected boolean cloneDuringInstanceClassLoading;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.copyDependencies();
        this.makeNar();
    }

    private void copyDependencies() throws MojoExecutionException {
        DependencyStatusSets dss = this.getDependencySets(this.failOnMissingClassifierArtifact);
        Set artifacts = dss.getResolvedDependencies();
        for (Object artifactObj : artifacts) {
            this.copyArtifact((Artifact)artifactObj);
        }
        artifacts = dss.getSkippedDependencies();
        for (Object artifactOjb : artifacts) {
            Artifact artifact = (Artifact)artifactOjb;
            this.getLog().info((CharSequence)(artifact.getFile().getName() + " already exists in destination."));
        }
    }

    protected void copyArtifact(Artifact artifact) throws MojoExecutionException {
        String destFileName = DependencyUtil.getFormattedFileName((Artifact)artifact, (boolean)false);
        File destDir = DependencyUtil.getFormattedOutputDirectory((boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (File)this.getDependenciesDirectory(), (Artifact)artifact);
        File destFile = new File(destDir, destFileName);
        this.copyFile(artifact.getFile(), destFile);
    }

    protected Artifact getResolvedPomArtifact(Artifact artifact) {
        Artifact pomArtifact = this.factory.createArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), "", "pom");
        try {
            this.resolver.resolve(pomArtifact, this.remoteRepos, this.local);
        }
        catch (ArtifactNotFoundException | ArtifactResolutionException e) {
            this.getLog().info((CharSequence)e.getMessage());
        }
        return pomArtifact;
    }

    protected ArtifactsFilter getMarkedArtifactFilter() {
        return new DestFileFilter(this.overWriteReleases, this.overWriteSnapshots, this.overWriteIfNewer, false, false, false, false, false, this.getDependenciesDirectory());
    }

    protected DependencyStatusSets getDependencySets(boolean stopOnFailure) throws MojoExecutionException {
        FilterArtifacts filter = new FilterArtifacts();
        filter.addFilter((ArtifactsFilter)new ProjectTransitivityFilter(this.project.getDependencyArtifacts(), false));
        filter.addFilter((ArtifactsFilter)new ScopeFilter(this.includeScope, this.excludeScope));
        filter.addFilter((ArtifactsFilter)new TypeFilter(this.includeTypes, this.excludeTypes));
        filter.addFilter((ArtifactsFilter)new ClassifierFilter(this.includeClassifiers, this.excludeClassifiers));
        filter.addFilter((ArtifactsFilter)new GroupIdFilter(this.includeGroupIds, this.excludeGroupIds));
        filter.addFilter((ArtifactsFilter)new ArtifactIdFilter(this.includeArtifactIds, this.excludeArtifactIds));
        filter.addFilter((ArtifactsFilter)new TypeFilter("", "nar"));
        Set artifacts = this.project.getArtifacts();
        try {
            artifacts = filter.filter(artifacts);
        }
        catch (ArtifactFilterException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        DependencyStatusSets status = StringUtils.isNotEmpty((String)this.copyDepClassifier) ? this.getClassifierTranslatedDependencies(artifacts, stopOnFailure) : this.filterMarkedDependencies(artifacts);
        return status;
    }

    protected DependencyStatusSets getClassifierTranslatedDependencies(Set artifacts, boolean stopOnFailure) throws MojoExecutionException {
        HashSet unResolvedArtifacts = new HashSet();
        Set resolvedArtifacts = artifacts;
        DependencyStatusSets status = new DependencyStatusSets();
        if (StringUtils.isNotEmpty((String)this.copyDepClassifier)) {
            ClassifierTypeTranslator translator = new ClassifierTypeTranslator(this.copyDepClassifier, this.type, this.factory);
            artifacts = translator.translate(artifacts, this.getLog());
            status = this.filterMarkedDependencies(artifacts);
            artifacts = status.getResolvedDependencies();
            DefaultArtifactsResolver artifactsResolver = new DefaultArtifactsResolver(this.resolver, this.local, this.remoteRepos, stopOnFailure);
            resolvedArtifacts = artifactsResolver.resolve(artifacts, this.getLog());
            unResolvedArtifacts.addAll(artifacts);
            unResolvedArtifacts.removeAll(resolvedArtifacts);
        }
        status.setResolvedDependencies(resolvedArtifacts);
        status.setUnResolvedDependencies(unResolvedArtifacts);
        return status;
    }

    protected DependencyStatusSets filterMarkedDependencies(Set artifacts) throws MojoExecutionException {
        Set unMarkedArtifacts;
        FilterArtifacts filter = new FilterArtifacts();
        filter.clearFilters();
        filter.addFilter(this.getMarkedArtifactFilter());
        try {
            unMarkedArtifacts = filter.filter(artifacts);
        }
        catch (ArtifactFilterException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        HashSet skippedArtifacts = new HashSet();
        skippedArtifacts.addAll(artifacts);
        skippedArtifacts.removeAll(unMarkedArtifacts);
        return new DependencyStatusSets(unMarkedArtifacts, null, skippedArtifacts);
    }

    protected void copyFile(File artifact, File destFile) throws MojoExecutionException {
        try {
            this.getLog().info((CharSequence)("Copying " + (this.outputAbsoluteArtifactFilename ? artifact.getAbsolutePath() : artifact.getName()) + " to " + destFile));
            FileUtils.copyFile((File)artifact, (File)destFile);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error copying artifact from " + artifact + " to " + destFile, e);
        }
    }

    private File getClassesDirectory() {
        File outputDirectory = this.projectBuildDirectory;
        return new File(outputDirectory, "classes");
    }

    private File getDependenciesDirectory() {
        return new File(this.getClassesDirectory(), "META-INF/bundled-dependencies");
    }

    private void makeNar() throws MojoExecutionException {
        File narFile = this.createArchive();
        if (this.classifier != null) {
            this.projectHelper.attachArtifact(this.project, "nar", this.classifier, narFile);
        } else {
            this.project.getArtifact().setFile(narFile);
        }
    }

    public File createArchive() throws MojoExecutionException {
        File outputDirectory = this.projectBuildDirectory;
        File narFile = this.getNarFile(outputDirectory, this.finalName, this.classifier);
        MavenArchiver archiver = new MavenArchiver();
        archiver.setArchiver(this.jarArchiver);
        archiver.setOutputFile(narFile);
        this.archive.setForced(this.forceCreation);
        try {
            File contentDirectory = this.getClassesDirectory();
            if (!contentDirectory.exists()) {
                this.getLog().warn((CharSequence)"NAR will be empty - no content was marked for inclusion!");
            } else {
                archiver.getArchiver().addDirectory(contentDirectory, this.getIncludes(), this.getExcludes());
            }
            File existingManifest = this.defaultManifestFile;
            if (this.useDefaultManifestFile && existingManifest.exists() && this.archive.getManifestFile() == null) {
                this.getLog().info((CharSequence)("Adding existing MANIFEST to archive. Found under: " + existingManifest.getPath()));
                this.archive.setManifestFile(existingManifest);
            }
            this.archive.addManifestEntry("Nar-Id", this.narId);
            this.archive.addManifestEntry("Nar-Group", this.narGroup);
            this.archive.addManifestEntry("Nar-Version", this.narVersion);
            NarDependency narDependency = this.getNarDependency();
            if (narDependency != null) {
                String narDependencyGroup = this.notEmpty(this.narDependencyGroup) ? this.narDependencyGroup : narDependency.getGroupId();
                String narDependencyId = this.notEmpty(this.narDependencyId) ? this.narDependencyId : narDependency.getArtifactId();
                String narDependencyVersion = this.notEmpty(this.narDependencyVersion) ? this.narDependencyVersion : narDependency.getVersion();
                this.archive.addManifestEntry("Nar-Dependency-Group", narDependencyGroup);
                this.archive.addManifestEntry("Nar-Dependency-Id", narDependencyId);
                this.archive.addManifestEntry("Nar-Dependency-Version", narDependencyVersion);
            }
            if (this.notEmpty(this.buildTag)) {
                this.archive.addManifestEntry("Build-Tag", this.buildTag);
            }
            if (this.notEmpty(this.buildBranch)) {
                this.archive.addManifestEntry("Build-Branch", this.buildBranch);
            }
            if (this.notEmpty(this.buildRevision)) {
                this.archive.addManifestEntry("Build-Revision", this.buildRevision);
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat(BUILD_TIMESTAMP_FORMAT);
            this.archive.addManifestEntry("Build-Timestamp", dateFormat.format(new Date()));
            this.archive.addManifestEntry("Clone-During-Instance-Class-Loading", String.valueOf(this.cloneDuringInstanceClassLoading));
            archiver.createArchive(this.session, this.project, this.archive);
            return narFile;
        }
        catch (IOException | DependencyResolutionRequiredException | MojoExecutionException | ArchiverException | ManifestException e) {
            throw new MojoExecutionException("Error assembling NAR", (Exception)e);
        }
    }

    private boolean notEmpty(String value) {
        return value != null && !value.isEmpty();
    }

    private String[] getIncludes() {
        if (this.includes != null && this.includes.length > 0) {
            return this.includes;
        }
        return DEFAULT_INCLUDES;
    }

    private String[] getExcludes() {
        if (this.excludes != null && this.excludes.length > 0) {
            return this.excludes;
        }
        return DEFAULT_EXCLUDES;
    }

    protected File getNarFile(File basedir, String finalName, String classifier) {
        if (classifier == null) {
            classifier = "";
        } else if (classifier.trim().length() > 0 && !classifier.startsWith("-")) {
            classifier = "-" + classifier;
        }
        return new File(basedir, finalName + classifier + ".nar");
    }

    private NarDependency getNarDependency() throws MojoExecutionException {
        NarDependency narDependency = null;
        FilterArtifacts filter = new FilterArtifacts();
        filter.addFilter((ArtifactsFilter)new TypeFilter("nar", ""));
        Set artifacts = this.project.getArtifacts();
        try {
            artifacts = filter.filter(artifacts);
        }
        catch (ArtifactFilterException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        if (artifacts.size() > 1) {
            throw new MojoExecutionException("Each NAR represents a ClassLoader. A NAR dependency allows that NAR's ClassLoader to be used as the parent of this NAR's ClassLoader. As a result, only a single NAR dependency is allowed.");
        }
        if (artifacts.size() == 1) {
            Artifact artifact = (Artifact)artifacts.iterator().next();
            narDependency = new NarDependency(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
        }
        return narDependency;
    }

    private static class NarDependency {
        final String groupId;
        final String artifactId;
        final String version;

        public NarDependency(String groupId, String artifactId, String version) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public String getVersion() {
            return this.version;
        }
    }
}

