/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilder;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilderException;
import org.apache.maven.shared.dependency.tree.traversal.DependencyNodeVisitor;
import org.eclipse.aether.RepositorySystemSession;

@Mojo(name="provided-nar-dependencies", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=false, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class NarProvidedDependenciesMojo
extends AbstractMojo {
    private static final String NAR = "nar";
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${localRepository}", readonly=true)
    private ArtifactRepository localRepository;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private RepositorySystemSession repoSession;
    @Parameter(property="mode", defaultValue="tree")
    private String mode;
    @Component
    private DependencyTreeBuilder dependencyTreeBuilder;
    @Component
    private ArtifactHandlerManager artifactHandlerManager;
    @Component
    private ProjectBuilder projectBuilder;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            Artifact narArtifact = null;
            for (Artifact artifact : this.project.getDependencyArtifacts()) {
                if (!NAR.equals(artifact.getType())) continue;
                if (narArtifact != null) {
                    throw new MojoExecutionException("Project can only have one NAR dependency.");
                }
                narArtifact = artifact;
            }
            if (narArtifact == null) {
                throw new MojoExecutionException("Project does not have any NAR dependencies.");
            }
            DefaultProjectBuildingRequest narRequest = new DefaultProjectBuildingRequest();
            narRequest.setRepositorySession(this.repoSession);
            narRequest.setSystemProperties(System.getProperties());
            ProjectBuildingResult narResult = this.projectBuilder.build(narArtifact, (ProjectBuildingRequest)narRequest);
            ArtifactHandler narHandler = this.excludesDependencies(narArtifact);
            narArtifact.setArtifactHandler(narHandler);
            HashMap<String, ArtifactHandler> narHandlerMap = new HashMap<String, ArtifactHandler>();
            narHandlerMap.put(NAR, narHandler);
            this.artifactHandlerManager.addHandlers(narHandlerMap);
            DependencyNode root = this.dependencyTreeBuilder.buildDependencyTree(narResult.getProject(), this.localRepository, null);
            Object visitor = null;
            if ("tree".equals(this.mode)) {
                visitor = new TreeWriter();
            } else if ("pom".equals(this.mode)) {
                visitor = new PomWriter();
            }
            if (visitor == null) {
                throw new MojoExecutionException("The specified mode is invalid. Supported options are 'tree' and 'pom'.");
            }
            root.accept((DependencyNodeVisitor)visitor);
            this.getLog().info((CharSequence)("--- Provided NAR Dependencies ---\n\n" + visitor.toString()));
        }
        catch (ProjectBuildingException | DependencyTreeBuilderException e) {
            throw new MojoExecutionException("Cannot build project dependency tree", (Exception)e);
        }
    }

    public MavenProject getProject() {
        return this.project;
    }

    private ArtifactHandler excludesDependencies(Artifact artifact) {
        final ArtifactHandler orig = artifact.getArtifactHandler();
        return new ArtifactHandler(){

            public String getExtension() {
                return orig.getExtension();
            }

            public String getDirectory() {
                return orig.getDirectory();
            }

            public String getClassifier() {
                return orig.getClassifier();
            }

            public String getPackaging() {
                return orig.getPackaging();
            }

            public boolean isIncludesDependencies() {
                return false;
            }

            public String getLanguage() {
                return orig.getLanguage();
            }

            public boolean isAddedToClasspath() {
                return orig.isAddedToClasspath();
            }
        };
    }

    private boolean isTest(DependencyNode node) {
        return "test".equals(node.getArtifact().getScope());
    }

    private class PomWriter
    implements DependencyNodeVisitor {
        private final StringBuilder output = new StringBuilder();

        private PomWriter() {
        }

        public boolean visit(DependencyNode node) {
            if (NarProvidedDependenciesMojo.this.isTest(node)) {
                return false;
            }
            Artifact artifact = node.getArtifact();
            if (!NarProvidedDependenciesMojo.NAR.equals(artifact.getType())) {
                this.output.append("<dependency>\n");
                this.output.append("    <groupId>").append(artifact.getGroupId()).append("</groupId>\n");
                this.output.append("    <artifactId>").append(artifact.getArtifactId()).append("</artifactId>\n");
                this.output.append("    <version>").append(artifact.getVersion()).append("</version>\n");
                this.output.append("    <scope>provided</scope>\n");
                this.output.append("</dependency>\n");
            }
            return true;
        }

        public boolean endVisit(DependencyNode node) {
            return true;
        }

        public String toString() {
            return this.output.toString();
        }
    }

    private class TreeWriter
    implements DependencyNodeVisitor {
        private final StringBuilder output = new StringBuilder();
        private final Deque<DependencyNode> hierarchy = new ArrayDeque<DependencyNode>();

        private TreeWriter() {
        }

        public boolean visit(DependencyNode node) {
            this.hierarchy.push(node);
            if (NarProvidedDependenciesMojo.this.isTest(node)) {
                return false;
            }
            StringBuilder pad = new StringBuilder();
            for (int i = 0; i < this.hierarchy.size() - 1; ++i) {
                pad.append("   ");
            }
            pad.append("+- ");
            this.output.append((CharSequence)pad).append(node.toNodeString()).append("\n");
            return true;
        }

        public boolean endVisit(DependencyNode node) {
            this.hierarchy.pop();
            return true;
        }

        public String toString() {
            return this.output.toString();
        }
    }
}

