/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.extension.definition.extraction;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilder;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilderException;
import org.apache.maven.shared.dependency.tree.traversal.DependencyNodeVisitor;
import org.apache.nifi.extension.definition.extraction.ExtensionClassLoader;
import org.eclipse.aether.RepositorySystemSession;

public class ExtensionClassLoaderFactory {
    private final Log log;
    private final MavenProject project;
    private final RepositorySystemSession repoSession;
    private final ProjectBuilder projectBuilder;
    private final ArtifactRepository localRepo;
    private final DependencyTreeBuilder dependencyTreeBuilder;
    private final ArtifactResolver artifactResolver;
    private final ArtifactHandlerManager artifactHandlerManager;

    private ExtensionClassLoaderFactory(Builder builder) {
        this.log = builder.log;
        this.project = builder.project;
        this.repoSession = builder.repositorySession;
        this.projectBuilder = builder.projectBuilder;
        this.localRepo = builder.localRepo;
        this.dependencyTreeBuilder = builder.dependencyTreeBuilder;
        this.artifactResolver = builder.artifactResolver;
        this.artifactHandlerManager = builder.artifactHandlerManager;
    }

    private Log getLog() {
        return this.log;
    }

    public ExtensionClassLoader createExtensionClassLoader() throws MojoExecutionException, ProjectBuildingException {
        Artifact narArtifact = this.project.getArtifact();
        Set<Artifact> narArtifacts = this.getNarDependencies(narArtifact);
        ArtifactsHolder artifactsHolder = new ArtifactsHolder();
        artifactsHolder.addArtifacts(narArtifacts);
        this.getLog().debug((CharSequence)"Project artifacts: ");
        narArtifacts.forEach(artifact -> this.getLog().debug((CharSequence)artifact.getArtifactId()));
        ExtensionClassLoader parentClassLoader = this.createClassLoader(narArtifacts, artifactsHolder);
        ExtensionClassLoader classLoader = this.createClassLoader(narArtifacts, parentClassLoader, narArtifact);
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Full ClassLoader is:\n" + classLoader.toTree()));
        }
        return classLoader;
    }

    private ExtensionClassLoader createClassLoader(Set<Artifact> artifacts, ArtifactsHolder artifactsHolder) throws MojoExecutionException, ProjectBuildingException {
        Artifact nar = this.removeNarArtifact(artifacts);
        if (nar == null) {
            ExtensionClassLoader providedEntityClassLoader = this.createProvidedEntitiesClassLoader(artifactsHolder);
            return this.createClassLoader(artifacts, providedEntityClassLoader, null);
        }
        Set<Artifact> narDependencies = this.getNarDependencies(nar);
        artifactsHolder.addArtifacts(narDependencies);
        return this.createClassLoader(narDependencies, this.createClassLoader(narDependencies, artifactsHolder), nar);
    }

    private Artifact removeNarArtifact(Set<Artifact> artifacts) {
        Iterator<Artifact> itr = artifacts.iterator();
        while (itr.hasNext()) {
            Artifact artifact = itr.next();
            if (artifact.equals(this.project.getArtifact()) || !"nar".equalsIgnoreCase(artifact.getType())) continue;
            this.getLog().info((CharSequence)("Found NAR dependency of " + artifact));
            itr.remove();
            return artifact;
        }
        return null;
    }

    private Set<Artifact> getNarDependencies(Artifact narArtifact) throws MojoExecutionException {
        DefaultProjectBuildingRequest narRequest = new DefaultProjectBuildingRequest();
        narRequest.setRepositorySession(this.repoSession);
        narRequest.setSystemProperties(System.getProperties());
        TreeSet<Artifact> narDependencies = new TreeSet<Artifact>();
        try {
            ProjectBuildingResult narResult = this.projectBuilder.build(narArtifact, (ProjectBuildingRequest)narRequest);
            this.gatherArtifacts(narResult.getProject(), narDependencies);
            narDependencies.remove(narArtifact);
            narDependencies.remove(this.project.getArtifact());
            this.getLog().debug((CharSequence)("Found NAR dependency of " + narArtifact + ", which resolved to the following artifacts: " + narDependencies));
        }
        catch (ProjectBuildingException e) {
            throw new MojoExecutionException("Could not build parent nar project");
        }
        return narDependencies;
    }

    private String determineProvidedEntityVersion(Set<Artifact> artifacts, String groupId, String artifactId) throws ProjectBuildingException, MojoExecutionException {
        this.getLog().debug((CharSequence)("Determining provided entities for " + groupId + ":" + artifactId));
        for (Artifact artifact : artifacts) {
            if (!artifact.getGroupId().equals(groupId) || !artifact.getArtifactId().equals(artifactId)) continue;
            return artifact.getVersion();
        }
        return this.findProvidedDependencyVersion(artifacts, groupId, artifactId);
    }

    private String findProvidedDependencyVersion(Set<Artifact> artifacts, String groupId, String artifactId) throws ProjectBuildingException, MojoExecutionException {
        DefaultProjectBuildingRequest narRequest = new DefaultProjectBuildingRequest();
        narRequest.setRepositorySession(this.repoSession);
        narRequest.setSystemProperties(System.getProperties());
        for (Artifact artifact : artifacts) {
            HashSet<Artifact> artifactDependencies = new HashSet<Artifact>();
            try {
                ProjectBuildingResult projectResult = this.projectBuilder.build(artifact, (ProjectBuildingRequest)narRequest);
                this.gatherArtifacts(projectResult.getProject(), artifactDependencies);
                this.getLog().debug((CharSequence)("For Artifact " + artifact + ", found the following dependencies:"));
                artifactDependencies.forEach(dep -> this.getLog().debug((CharSequence)dep.toString()));
                for (Artifact dependency : artifactDependencies) {
                    if (!dependency.getGroupId().equals(groupId) || !dependency.getArtifactId().equals(artifactId)) continue;
                    this.getLog().debug((CharSequence)("Found version of " + groupId + ":" + artifactId + " to be " + artifact.getVersion()));
                    return artifact.getVersion();
                }
            }
            catch (Exception e) {
                this.getLog().warn((CharSequence)("Unable to construct Maven Project for " + artifact + " when attempting to determine the expected version of NiFi API"));
                this.getLog().debug((CharSequence)("Unable to construct Maven Project for " + artifact + " when attempting to determine the expected version of NiFi API"), (Throwable)e);
            }
        }
        return null;
    }

    private Artifact getProvidedArtifact(String groupId, String artifactId, String version) throws MojoExecutionException {
        VersionRange versionRange;
        ArtifactHandler handler = this.artifactHandlerManager.getArtifactHandler("jar");
        try {
            versionRange = VersionRange.createFromVersionSpec((String)version);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Could not determine appropriate version for Provided Artifact " + groupId + ":" + artifactId, e);
        }
        DefaultArtifact artifact = new DefaultArtifact(groupId, artifactId, versionRange, null, "jar", null, handler);
        ArtifactResolutionRequest request = new ArtifactResolutionRequest();
        request.setLocalRepository(this.localRepo);
        request.setArtifact((Artifact)artifact);
        ArtifactResolutionResult result = this.artifactResolver.resolve(request);
        if (!result.isSuccess()) {
            List exceptions = result.getExceptions();
            MojoExecutionException exception = new MojoExecutionException("Could not resolve local dependency " + artifact);
            if (exceptions != null) {
                for (Exception e : exceptions) {
                    exception.addSuppressed((Throwable)e);
                }
            }
            throw exception;
        }
        Set artifacts = result.getArtifacts();
        if (artifacts.isEmpty()) {
            throw new MojoExecutionException("Could not resolve any artifacts for dependency " + artifact);
        }
        ArrayList sorted = new ArrayList(artifacts);
        Collections.sort(sorted);
        return (Artifact)sorted.get(0);
    }

    private ExtensionClassLoader createProvidedEntitiesClassLoader(ArtifactsHolder artifactsHolder) throws MojoExecutionException, ProjectBuildingException {
        String nifiApiVersion = this.determineProvidedEntityVersion(artifactsHolder.getAllArtifacts(), "org.apache.nifi", "nifi-api");
        if (nifiApiVersion == null) {
            throw new MojoExecutionException("Could not find any dependency, provided or otherwise, on [org.apache.nifi:nifi-api]");
        }
        this.getLog().info((CharSequence)("Found a dependency on version " + nifiApiVersion + " of NiFi API"));
        String slf4jApiVersion = this.determineProvidedEntityVersion(artifactsHolder.getAllArtifacts(), "org.slf4j", "slf4j-api");
        Artifact nifiApiArtifact = this.getProvidedArtifact("org.apache.nifi", "nifi-api", nifiApiVersion);
        Artifact nifiFrameworkApiArtifact = this.getProvidedArtifact("org.apache.nifi", "nifi-framework-api", nifiApiArtifact.getVersion());
        Artifact slf4jArtifact = this.getProvidedArtifact("org.slf4j", "slf4j-api", slf4jApiVersion);
        HashSet<Artifact> providedArtifacts = new HashSet<Artifact>();
        providedArtifacts.add(nifiApiArtifact);
        providedArtifacts.add(nifiFrameworkApiArtifact);
        providedArtifacts.add(slf4jArtifact);
        this.getLog().debug((CharSequence)("Creating Provided Entities Class Loader with artifacts: " + providedArtifacts));
        return this.createClassLoader(providedArtifacts, null, null);
    }

    private ExtensionClassLoader createClassLoader(Set<Artifact> artifacts, ExtensionClassLoader parent, Artifact narArtifact) throws MojoExecutionException {
        HashSet<URL> urls = new HashSet<URL>();
        for (Artifact artifact : artifacts) {
            Set<URL> artifactUrls = this.toURLs(artifact);
            urls.addAll(artifactUrls);
        }
        this.getLog().debug((CharSequence)("Creating class loader with following dependencies: " + urls));
        URL[] urlArray = urls.toArray(new URL[0]);
        if (parent == null) {
            return new ExtensionClassLoader(urlArray, narArtifact, artifacts);
        }
        return new ExtensionClassLoader(urlArray, parent, narArtifact, artifacts);
    }

    private void gatherArtifacts(MavenProject mavenProject, final Set<Artifact> artifacts) throws MojoExecutionException {
        DependencyNodeVisitor nodeVisitor = new DependencyNodeVisitor(){

            public boolean visit(DependencyNode dependencyNode) {
                Artifact artifact = dependencyNode.getArtifact();
                artifacts.add(artifact);
                return true;
            }

            public boolean endVisit(DependencyNode dependencyNode) {
                return true;
            }
        };
        try {
            DependencyNode depNode = this.dependencyTreeBuilder.buildDependencyTree(mavenProject, this.localRepo, null);
            depNode.accept(nodeVisitor);
        }
        catch (DependencyTreeBuilderException e) {
            throw new MojoExecutionException("Failed to build dependency tree", (Exception)((Object)e));
        }
    }

    private Set<URL> toURLs(Artifact artifact) throws MojoExecutionException {
        HashSet<URL> urls = new HashSet<URL>();
        File artifactFile = artifact.getFile();
        if (artifactFile == null) {
            this.getLog().debug((CharSequence)("Attempting to resolve Artifact " + artifact + " because it has no File associated with it"));
            ArtifactResolutionRequest request = new ArtifactResolutionRequest();
            request.setLocalRepository(this.localRepo);
            request.setArtifact(artifact);
            ArtifactResolutionResult result = this.artifactResolver.resolve(request);
            if (!result.isSuccess()) {
                throw new MojoExecutionException("Could not resolve local dependency " + artifact);
            }
            this.getLog().debug((CharSequence)("Resolved Artifact " + artifact + " to " + result.getArtifacts()));
            for (Artifact resolved : result.getArtifacts()) {
                urls.addAll(this.toURLs(resolved));
            }
        } else {
            try {
                URL url = artifact.getFile().toURI().toURL();
                this.getLog().debug((CharSequence)("Adding URL " + url + " to ClassLoader"));
                urls.add(url);
            }
            catch (MalformedURLException mue) {
                throw new MojoExecutionException("Failed to convert File " + artifact.getFile() + " into URL", (Exception)mue);
            }
        }
        return urls;
    }

    private static class ArtifactsHolder {
        private Set<Artifact> allArtifacts = new TreeSet<Artifact>();

        private ArtifactsHolder() {
        }

        public void addArtifacts(Set<Artifact> artifacts) {
            if (artifacts != null) {
                this.allArtifacts.addAll(artifacts);
            }
        }

        public Set<Artifact> getAllArtifacts() {
            return this.allArtifacts;
        }
    }

    public static class Builder {
        private Log log;
        private MavenProject project;
        private ArtifactRepository localRepo;
        private DependencyTreeBuilder dependencyTreeBuilder;
        private ArtifactResolver artifactResolver;
        private ProjectBuilder projectBuilder;
        private RepositorySystemSession repositorySession;
        private ArtifactHandlerManager artifactHandlerManager;

        public Builder log(Log log) {
            this.log = log;
            return this;
        }

        public Builder projectBuilder(ProjectBuilder projectBuilder) {
            this.projectBuilder = projectBuilder;
            return this;
        }

        public Builder project(MavenProject project) {
            this.project = project;
            return this;
        }

        public Builder localRepository(ArtifactRepository localRepo) {
            this.localRepo = localRepo;
            return this;
        }

        public Builder dependencyTreeBuilder(DependencyTreeBuilder dependencyTreeBuilder) {
            this.dependencyTreeBuilder = dependencyTreeBuilder;
            return this;
        }

        public Builder artifactResolver(ArtifactResolver resolver) {
            this.artifactResolver = resolver;
            return this;
        }

        public Builder repositorySession(RepositorySystemSession repositorySession) {
            this.repositorySession = repositorySession;
            return this;
        }

        public Builder artifactHandlerManager(ArtifactHandlerManager artifactHandlerManager) {
            this.artifactHandlerManager = artifactHandlerManager;
            return this;
        }

        public ExtensionClassLoaderFactory build() {
            return new ExtensionClassLoaderFactory(this);
        }
    }
}

