/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.installer.ArtifactInstaller;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.dependency.utils.DependencyStatusSets;
import org.apache.maven.plugin.dependency.utils.DependencyUtil;
import org.apache.maven.plugin.dependency.utils.filters.DestFileFilter;
import org.apache.maven.plugin.dependency.utils.resolvers.DefaultArtifactsResolver;
import org.apache.maven.plugin.dependency.utils.translators.ClassifierTypeTranslator;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.shared.artifact.filter.collection.ArtifactFilterException;
import org.apache.maven.shared.artifact.filter.collection.ArtifactIdFilter;
import org.apache.maven.shared.artifact.filter.collection.ArtifactsFilter;
import org.apache.maven.shared.artifact.filter.collection.ClassifierFilter;
import org.apache.maven.shared.artifact.filter.collection.FilterArtifacts;
import org.apache.maven.shared.artifact.filter.collection.GroupIdFilter;
import org.apache.maven.shared.artifact.filter.collection.ProjectTransitivityFilter;
import org.apache.maven.shared.artifact.filter.collection.ScopeFilter;
import org.apache.maven.shared.artifact.filter.collection.TypeFilter;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.nifi.extension.definition.ExtensionDefinition;
import org.apache.nifi.extension.definition.ExtensionType;
import org.apache.nifi.extension.definition.ServiceAPIDefinition;
import org.apache.nifi.extension.definition.extraction.ExtensionClassLoader;
import org.apache.nifi.extension.definition.extraction.ExtensionClassLoaderFactory;
import org.apache.nifi.extension.definition.extraction.ExtensionDefinitionFactory;
import org.apache.nifi.extension.definition.extraction.StandardServiceAPIDefinition;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.jar.ManifestException;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.aether.RepositorySystemSession;

@Mojo(name="nar", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class NarMojo
extends AbstractMojo {
    private static final String CONTROLLER_SERVICE_CLASS_NAME = "org.apache.nifi.controller.ControllerService";
    private static final String DOCUMENTATION_WRITER_CLASS_NAME = "org.apache.nifi.documentation.xml.XmlDocumentationWriter";
    private static final String[] DEFAULT_EXCLUDES = new String[]{"**/package.html"};
    private static final String[] DEFAULT_INCLUDES = new String[]{"**/**"};
    private static final String BUILD_TIMESTAMP_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    protected MavenSession session;
    @Parameter(property="includes")
    protected String[] includes;
    @Parameter(property="excludes")
    protected String[] excludes;
    @Parameter(alias="narName", property="nar.finalName", defaultValue="${project.build.finalName}", required=true)
    protected String finalName;
    @Component(role=Archiver.class, hint="jar")
    private JarArchiver jarArchiver;
    @Parameter(property="archive")
    protected final MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    @Parameter(property="defaultManifestFiles", defaultValue="${project.build.outputDirectory}/META-INF/MANIFEST.MF", readonly=true, required=true)
    protected File defaultManifestFile;
    @Parameter(property="nar.useDefaultManifestFile", defaultValue="false")
    protected boolean useDefaultManifestFile;
    @Component
    protected MavenProjectHelper projectHelper;
    @Parameter(property="nar.forceCreation", defaultValue="false")
    protected boolean forceCreation;
    @Parameter(property="classifier")
    protected String classifier;
    @Component
    protected ArtifactInstaller installer;
    @Component
    protected ArtifactRepositoryFactory repositoryFactory;
    @Parameter(property="mdep.failOnMissingClassifierArtifact", defaultValue="true", required=false)
    protected boolean failOnMissingClassifierArtifact = true;
    @Parameter(property="includeTypes", required=false)
    protected String includeTypes;
    @Parameter(property="excludeTypes", required=false)
    protected String excludeTypes;
    @Parameter(property="includeScope", required=false)
    protected String includeScope;
    @Parameter(property="excludeScope", required=false)
    protected String excludeScope;
    @Parameter(property="includeClassifiers", required=false)
    protected String includeClassifiers;
    @Parameter(property="excludeClassifiers", required=false)
    protected String excludeClassifiers;
    @Parameter(property="classifier", required=false)
    protected String copyDepClassifier;
    @Parameter(property="type", required=false, defaultValue="nar")
    protected String type;
    @Parameter(property="excludeArtifacts", required=false)
    protected String excludeArtifactIds;
    @Parameter(property="includeArtifacts", required=false)
    protected String includeArtifactIds;
    @Parameter(property="excludeArtifacts", required=false)
    protected String excludeGroupIds;
    @Parameter(property="includeGroupIds", required=false)
    protected String includeGroupIds;
    @Parameter(property="markersDirectory", required=false, defaultValue="${project.build.directory}/dependency-maven-plugin-markers")
    protected File markersDirectory;
    @Parameter(property="overWriteReleases", required=false)
    protected boolean overWriteReleases;
    @Parameter(property="overWriteSnapshots", required=false)
    protected boolean overWriteSnapshots;
    @Parameter(property="overWriteIfNewer", required=false, defaultValue="true")
    protected boolean overWriteIfNewer;
    @Parameter(property="projectBuildDirectory", required=false, defaultValue="${project.build.directory}")
    protected File projectBuildDirectory;
    @Component
    protected ArtifactFactory factory;
    @Component
    protected ArtifactResolver resolver;
    @Component(role=ArtifactCollector.class)
    protected ArtifactCollector artifactCollector;
    @Component(role=ArtifactMetadataSource.class)
    protected ArtifactMetadataSource artifactMetadataSource;
    @Parameter(property="localRepository", required=true, readonly=true)
    protected ArtifactRepository local;
    @Parameter(property="project.remoteArtifactRepositories", required=true, readonly=true)
    protected List remoteRepos;
    @Component
    protected ArchiverManager archiverManager;
    @Parameter(property="reactorProjects", required=true, readonly=true)
    protected List reactorProjects;
    @Parameter(property="silent", required=false, defaultValue="false")
    public boolean silent;
    @Component
    private DependencyGraphBuilder dependencyGraphBuilder;
    @Component
    private ArtifactHandlerManager artifactHandlerManager;
    @Parameter(property="outputAbsoluteArtifactFilename", defaultValue="false", required=false)
    protected boolean outputAbsoluteArtifactFilename;
    @Parameter(property="narGroup", defaultValue="${project.groupId}", required=true)
    protected String narGroup;
    @Parameter(property="narId", defaultValue="${project.artifactId}", required=true)
    protected String narId;
    @Parameter(property="narVersion", defaultValue="${project.version}", required=true)
    protected String narVersion;
    @Parameter(property="narDependencyGroup", required=false)
    protected String narDependencyGroup = null;
    @Parameter(property="narDependencyId", required=false)
    protected String narDependencyId = null;
    @Parameter(property="narDependencyVersion", required=false)
    protected String narDependencyVersion = null;
    @Parameter(property="buildTag", defaultValue="${project.scm.tag}", required=false)
    protected String buildTag;
    @Parameter(property="buildBranch", defaultValue="${buildBranch}", required=false)
    protected String buildBranch;
    @Parameter(property="buildRevision", defaultValue="${buildRevision}", required=false)
    protected String buildRevision;
    @Parameter(property="cloneDuringInstanceClassLoading", defaultValue="false", required=false)
    protected boolean cloneDuringInstanceClassLoading;
    @Parameter(property="enforceDocGeneration", defaultValue="false", required=false)
    protected boolean enforceDocGeneration;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private RepositorySystemSession repoSession;
    @Component
    private ProjectBuilder projectBuilder;
    @Parameter(defaultValue="${project.build.outputTimestamp}")
    private String outputTimestamp;

    public void execute() throws MojoExecutionException {
        this.copyDependencies();
        try {
            this.generateDocumentation();
        }
        catch (Throwable t) {
            if (this.enforceDocGeneration) {
                this.getLog().error((CharSequence)"Could not generate extensions' documentation", t);
                throw t;
            }
            this.getLog().warn((CharSequence)"Could not generate extensions' documentation", t);
        }
        this.makeNar();
    }

    private File getExtensionsDocumentationFile() {
        File directory = new File(this.projectBuildDirectory, "META-INF/docs");
        return new File(directory, "extension-manifest.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateDocumentation() throws MojoExecutionException {
        ExtensionClassLoader extensionClassLoader;
        this.getLog().info((CharSequence)"Generating documentation for NiFi extensions in the NAR...");
        ExtensionClassLoaderFactory classLoaderFactory = this.createClassLoaderFactory();
        try {
            extensionClassLoader = classLoaderFactory.createExtensionClassLoader();
        }
        catch (Exception e) {
            if (this.enforceDocGeneration) {
                throw new MojoExecutionException("Failed to create Extension Documentation", e);
            }
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)"Unable to create a ClassLoader for documenting extensions. If this NAR contains any NiFi Extensions, those extensions will not be documented.", (Throwable)e);
            } else {
                this.getLog().warn((CharSequence)"Unable to create a ClassLoader for documenting extensions. If this NAR contains any NiFi Extensions, those extensions will not be documented. Enable mvn DEBUG output for more information (mvn -X).");
            }
            return;
        }
        File docsFile = this.getExtensionsDocumentationFile();
        this.createDirectory(docsFile.getParentFile());
        File additionalDetailsDir = new File(docsFile.getParentFile(), "additional-details");
        this.createDirectory(additionalDetailsDir);
        try (FileOutputStream out = new FileOutputStream(docsFile);
             XMLStreamWriter xmlWriter = XMLOutputFactory.newInstance().createXMLStreamWriter(out, "UTF-8");){
            Class<?> docWriterClass;
            xmlWriter.writeStartElement("extensionManifest");
            this.writeXmlTag(xmlWriter, "groupId", this.narGroup);
            this.writeXmlTag(xmlWriter, "artifactId", this.narId);
            this.writeXmlTag(xmlWriter, "version", this.narVersion);
            NarDependency narDependency = this.getNarDependency();
            if (narDependency != null) {
                xmlWriter.writeStartElement("parentNar");
                this.writeXmlTag(xmlWriter, "groupId", this.notEmpty(this.narDependencyGroup) ? this.narDependencyGroup : narDependency.getGroupId());
                this.writeXmlTag(xmlWriter, "artifactId", this.notEmpty(this.narDependencyId) ? this.narDependencyId : narDependency.getArtifactId());
                this.writeXmlTag(xmlWriter, "version", this.notEmpty(this.narDependencyVersion) ? this.narDependencyVersion : narDependency.getVersion());
                xmlWriter.writeEndElement();
            }
            String nifiApiVersion = extensionClassLoader.getNiFiApiVersion();
            xmlWriter.writeStartElement("systemApiVersion");
            xmlWriter.writeCharacters(nifiApiVersion);
            xmlWriter.writeEndElement();
            xmlWriter.writeStartElement("buildInfo");
            if (this.notEmpty(this.buildTag)) {
                this.writeXmlTag(xmlWriter, "tag", this.buildTag);
            }
            if (this.notEmpty(this.buildBranch)) {
                this.writeXmlTag(xmlWriter, "branch", this.buildBranch);
            }
            if (this.notEmpty(this.buildRevision)) {
                this.writeXmlTag(xmlWriter, "revision", this.buildRevision);
            }
            xmlWriter.writeEndElement();
            xmlWriter.writeStartElement("extensions");
            try {
                docWriterClass = Class.forName(DOCUMENTATION_WRITER_CLASS_NAME, false, extensionClassLoader);
            }
            catch (ClassNotFoundException e) {
                this.getLog().warn((CharSequence)"Cannot locate class org.apache.nifi.documentation.xml.XmlDocumentationWriter, so no documentation will be generated for the extensions in this NAR");
                xmlWriter.close();
                if (out != null) {
                    if (var6_8 != null) {
                        try {
                            ((OutputStream)out).close();
                        }
                        catch (Throwable throwable) {
                            var6_8.addSuppressed(throwable);
                        }
                    } else {
                        ((OutputStream)out).close();
                    }
                }
                return;
            }
            this.getLog().debug((CharSequence)("Creating Extension Definition Factory for NiFi API version " + nifiApiVersion));
            ExtensionDefinitionFactory extensionDefinitionFactory = new ExtensionDefinitionFactory(extensionClassLoader);
            ClassLoader currentContextClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(extensionClassLoader);
                Set<ExtensionDefinition> processorDefinitions = extensionDefinitionFactory.discoverExtensions(ExtensionType.PROCESSOR);
                this.writeDocumentation(processorDefinitions, extensionClassLoader, docWriterClass, xmlWriter, additionalDetailsDir);
                Set<ExtensionDefinition> controllerServiceDefinitions = extensionDefinitionFactory.discoverExtensions(ExtensionType.CONTROLLER_SERVICE);
                this.writeDocumentation(controllerServiceDefinitions, extensionClassLoader, docWriterClass, xmlWriter, additionalDetailsDir);
                Set<ExtensionDefinition> reportingTaskDefinitions = extensionDefinitionFactory.discoverExtensions(ExtensionType.REPORTING_TASK);
                this.writeDocumentation(reportingTaskDefinitions, extensionClassLoader, docWriterClass, xmlWriter, additionalDetailsDir);
            }
            finally {
                if (currentContextClassLoader != null) {
                    Thread.currentThread().setContextClassLoader(currentContextClassLoader);
                }
            }
            xmlWriter.writeEndElement();
            xmlWriter.writeEndElement();
        }
        catch (Exception ioe) {
            throw new MojoExecutionException("Failed to create Extension Documentation", ioe);
        }
    }

    private void writeXmlTag(XMLStreamWriter xmlWriter, String tagName, String value) throws XMLStreamException {
        xmlWriter.writeStartElement(tagName);
        xmlWriter.writeCharacters(value);
        xmlWriter.writeEndElement();
    }

    private void writeDocumentation(Set<ExtensionDefinition> extensionDefinitions, ExtensionClassLoader classLoader, Class<?> docWriterClass, XMLStreamWriter xmlWriter, File additionalDetailsDir) throws InvocationTargetException, NoSuchMethodException, ClassNotFoundException, InstantiationException, IllegalAccessException, IOException {
        TreeSet<ExtensionDefinition> sorted = new TreeSet<ExtensionDefinition>(new Comparator<ExtensionDefinition>(){

            @Override
            public int compare(ExtensionDefinition e1, ExtensionDefinition e2) {
                return e1.getExtensionName().compareTo(e2.getExtensionName());
            }
        });
        sorted.addAll(extensionDefinitions);
        for (ExtensionDefinition definition : sorted) {
            this.writeDocumentation(definition, classLoader, docWriterClass, xmlWriter);
        }
        Set<String> extensionNames = sorted.stream().map(ExtensionDefinition::getExtensionName).collect(Collectors.toSet());
        try {
            this.writeAdditionalDetails(classLoader, extensionNames, additionalDetailsDir);
        }
        catch (Exception e) {
            throw new IOException("Unable to extract Additional Details", e);
        }
    }

    private void writeDocumentation(ExtensionDefinition extensionDefinition, ExtensionClassLoader classLoader, Class<?> docWriterClass, XMLStreamWriter xmlWriter) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException, ClassNotFoundException, IOException {
        this.getLog().debug((CharSequence)("Generating documentation for " + extensionDefinition.getExtensionName() + " using ClassLoader:\n" + classLoader.toTree()));
        Object docWriter = docWriterClass.getConstructor(XMLStreamWriter.class).newInstance(xmlWriter);
        Class<?> configurableComponentClass = Class.forName("org.apache.nifi.components.ConfigurableComponent", false, classLoader);
        Class<?> extensionClass = Class.forName(extensionDefinition.getExtensionName(), false, classLoader);
        Object extensionInstance = extensionClass.newInstance();
        Method initMethod = docWriterClass.getMethod("initialize", configurableComponentClass);
        initMethod.invoke(docWriter, extensionInstance);
        Map<String, ServiceAPIDefinition> propertyServiceDefinitions = this.getRequiredServiceDefinitions(extensionClass, extensionInstance);
        Set<ServiceAPIDefinition> providedServiceDefinitions = extensionDefinition.getProvidedServiceAPIs();
        if ((providedServiceDefinitions == null || providedServiceDefinitions.isEmpty()) && (propertyServiceDefinitions == null || propertyServiceDefinitions.isEmpty())) {
            Method writeMethod = docWriterClass.getMethod("write", configurableComponentClass);
            writeMethod.invoke(docWriter, extensionInstance);
        } else {
            Class<?> serviceApiClass = Class.forName("org.apache.nifi.documentation.StandardServiceAPI", false, classLoader);
            List<Object> providedServices = this.getDocumentationServiceAPIs(serviceApiClass, providedServiceDefinitions);
            Map<String, Object> propertyServices = this.getDocumentationServiceAPIs(serviceApiClass, propertyServiceDefinitions);
            Method writeMethod = docWriterClass.getMethod("write", configurableComponentClass, Collection.class, Map.class);
            writeMethod.invoke(docWriter, extensionInstance, providedServices, propertyServices);
        }
    }

    private List<Object> getDocumentationServiceAPIs(Class<?> serviceApiClass, Set<ServiceAPIDefinition> serviceDefinitions) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor<?> ctr = serviceApiClass.getConstructor(String.class, String.class, String.class, String.class);
        ArrayList<Object> providedServices = new ArrayList<Object>();
        for (ServiceAPIDefinition definition : serviceDefinitions) {
            Object serviceApi = ctr.newInstance(definition.getServiceAPIClassName(), definition.getServiceGroupId(), definition.getServiceArtifactId(), definition.getServiceVersion());
            providedServices.add(serviceApi);
        }
        return providedServices;
    }

    private Map<String, Object> getDocumentationServiceAPIs(Class<?> serviceApiClass, Map<String, ServiceAPIDefinition> serviceDefinitions) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor<?> ctr = serviceApiClass.getConstructor(String.class, String.class, String.class, String.class);
        HashMap<String, Object> providedServices = new HashMap<String, Object>();
        for (Map.Entry<String, ServiceAPIDefinition> entry : serviceDefinitions.entrySet()) {
            String propName = entry.getKey();
            ServiceAPIDefinition definition = entry.getValue();
            Object serviceApi = ctr.newInstance(definition.getServiceAPIClassName(), definition.getServiceGroupId(), definition.getServiceArtifactId(), definition.getServiceVersion());
            providedServices.put(propName, serviceApi);
        }
        return providedServices;
    }

    private Map<String, ServiceAPIDefinition> getRequiredServiceDefinitions(Class<?> extensionClass, Object extensionInstance) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        HashMap<String, ServiceAPIDefinition> requiredServiceAPIDefinitions = new HashMap<String, ServiceAPIDefinition>();
        Method writeMethod = extensionClass.getMethod("getPropertyDescriptors", new Class[0]);
        List propertyDescriptors = (List)writeMethod.invoke(extensionInstance, new Object[0]);
        if (propertyDescriptors == null) {
            return requiredServiceAPIDefinitions;
        }
        for (Object propDescriptor : propertyDescriptors) {
            Class serviceDefinitionClass;
            Method nameMethod = propDescriptor.getClass().getMethod("getName", new Class[0]);
            String propName = (String)nameMethod.invoke(propDescriptor, new Object[0]);
            Method serviceDefinitionMethod = propDescriptor.getClass().getMethod("getControllerServiceDefinition", new Class[0]);
            Object serviceDefinition = serviceDefinitionMethod.invoke(propDescriptor, new Object[0]);
            if (serviceDefinition == null || CONTROLLER_SERVICE_CLASS_NAME.equals((serviceDefinitionClass = (Class)serviceDefinition).getName())) continue;
            ExtensionClassLoader extensionClassLoader = (ExtensionClassLoader)serviceDefinitionClass.getClassLoader();
            Artifact narArtifact = extensionClassLoader.getNarArtifact();
            if (narArtifact == null) {
                this.getLog().warn((CharSequence)("Could not find NAR Artifact for Controller Service Definition " + serviceDefinitionClass.getName() + ". Documentation may  not show appropriate linkage to Controller Service."));
                continue;
            }
            StandardServiceAPIDefinition serviceAPIDefinition = new StandardServiceAPIDefinition(serviceDefinitionClass.getName(), narArtifact.getGroupId(), narArtifact.getArtifactId(), narArtifact.getBaseVersion());
            requiredServiceAPIDefinitions.put(propName, serviceAPIDefinition);
        }
        return requiredServiceAPIDefinitions;
    }

    private void writeAdditionalDetails(ExtensionClassLoader classLoader, Set<String> extensionNames, File additionalDetailsDir) throws URISyntaxException, IOException, MojoExecutionException {
        for (URL url : classLoader.getURLs()) {
            File file = new File(url.toURI());
            String filename = file.getName();
            if (!filename.endsWith(".jar")) continue;
            this.writeAdditionalDetails(file, extensionNames, additionalDetailsDir);
        }
    }

    private void writeAdditionalDetails(File file, Set<String> extensionNames, File additionalDetailsDir) throws IOException, MojoExecutionException {
        JarFile jarFile = new JarFile(file);
        Enumeration<JarEntry> jarEnumeration = jarFile.entries();
        while (jarEnumeration.hasMoreElements()) {
            String componentName;
            int nextSlashIndex;
            JarEntry jarEntry = jarEnumeration.nextElement();
            String entryName = jarEntry.getName();
            if (!entryName.startsWith("docs/") || (nextSlashIndex = entryName.indexOf("/", 5)) < 0 || !extensionNames.contains(componentName = entryName.substring(5, nextSlashIndex)) || jarEntry.isDirectory() || entryName.length() < nextSlashIndex + 1) continue;
            this.getLog().debug((CharSequence)("Found file " + entryName + " in " + file + " that consists of documentation for " + componentName));
            File componentDirectory = new File(additionalDetailsDir, componentName);
            String remainingPath = entryName.substring(nextSlashIndex + 1);
            File destinationFile = new File(componentDirectory, remainingPath);
            this.createDirectory(destinationFile.getParentFile());
            InputStream in = jarFile.getInputStream(jarEntry);
            Throwable throwable = null;
            try {
                FileOutputStream out = new FileOutputStream(destinationFile);
                Throwable throwable2 = null;
                try {
                    this.copy(in, out);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (out == null) continue;
                    if (throwable2 != null) {
                        try {
                            ((OutputStream)out).close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    ((OutputStream)out).close();
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (in == null) continue;
                if (throwable != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                in.close();
            }
        }
    }

    private void copy(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[8192];
        while ((len = in.read(buffer)) >= 0) {
            out.write(buffer, 0, len);
        }
    }

    private ExtensionClassLoaderFactory createClassLoaderFactory() {
        return new ExtensionClassLoaderFactory.Builder().artifactResolver(this.resolver).dependencyGraphBuilder(this.dependencyGraphBuilder).localRepository(this.local).log(this.getLog()).project(this.project).projectBuilder(this.projectBuilder).repositorySession(this.repoSession).artifactHandlerManager(this.artifactHandlerManager).build();
    }

    private void createDirectory(File file) throws MojoExecutionException {
        if (!file.exists()) {
            try {
                Files.createDirectories(file.toPath(), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not create directory " + file, (Exception)e);
            }
        }
    }

    private void copyDependencies() throws MojoExecutionException {
        DependencyStatusSets dss = this.getDependencySets(this.failOnMissingClassifierArtifact);
        Set artifacts = dss.getResolvedDependencies();
        for (Artifact artifact : artifacts) {
            this.copyArtifact(artifact);
        }
        artifacts = dss.getSkippedDependencies();
        for (Artifact artifact : artifacts) {
            this.getLog().debug((CharSequence)(artifact.getFile().getName() + " already exists in destination."));
        }
    }

    protected void copyArtifact(Artifact artifact) throws MojoExecutionException {
        String destFileName = DependencyUtil.getFormattedFileName((Artifact)artifact, (boolean)false);
        File destDir = DependencyUtil.getFormattedOutputDirectory((boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (File)this.getDependenciesDirectory(), (Artifact)artifact);
        File destFile = new File(destDir, destFileName);
        this.copyFile(artifact.getFile(), destFile);
    }

    protected Artifact getResolvedPomArtifact(Artifact artifact) {
        Artifact pomArtifact = this.factory.createArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), "", "pom");
        try {
            this.resolver.resolve(pomArtifact, this.remoteRepos, this.local);
        }
        catch (ArtifactNotFoundException | ArtifactResolutionException e) {
            this.getLog().info((CharSequence)e.getMessage());
        }
        return pomArtifact;
    }

    protected ArtifactsFilter getMarkedArtifactFilter() {
        return new DestFileFilter(this.overWriteReleases, this.overWriteSnapshots, this.overWriteIfNewer, false, false, false, false, false, this.getDependenciesDirectory());
    }

    protected DependencyStatusSets getDependencySets(boolean stopOnFailure) throws MojoExecutionException {
        FilterArtifacts filter = new FilterArtifacts();
        filter.addFilter((ArtifactsFilter)new ProjectTransitivityFilter(this.project.getDependencyArtifacts(), false));
        filter.addFilter((ArtifactsFilter)new ScopeFilter(this.includeScope, this.excludeScope));
        filter.addFilter((ArtifactsFilter)new TypeFilter(this.includeTypes, this.excludeTypes));
        filter.addFilter((ArtifactsFilter)new ClassifierFilter(this.includeClassifiers, this.excludeClassifiers));
        filter.addFilter((ArtifactsFilter)new GroupIdFilter(this.includeGroupIds, this.excludeGroupIds));
        filter.addFilter((ArtifactsFilter)new ArtifactIdFilter(this.includeArtifactIds, this.excludeArtifactIds));
        filter.addFilter((ArtifactsFilter)new TypeFilter("", "nar"));
        Set artifacts = this.project.getArtifacts();
        try {
            artifacts = filter.filter(artifacts);
        }
        catch (ArtifactFilterException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        DependencyStatusSets status = StringUtils.isNotEmpty((String)this.copyDepClassifier) ? this.getClassifierTranslatedDependencies(artifacts, stopOnFailure) : this.filterMarkedDependencies(artifacts);
        return status;
    }

    protected DependencyStatusSets getClassifierTranslatedDependencies(Set artifacts, boolean stopOnFailure) throws MojoExecutionException {
        HashSet unResolvedArtifacts = new HashSet();
        Set resolvedArtifacts = artifacts;
        DependencyStatusSets status = new DependencyStatusSets();
        if (StringUtils.isNotEmpty((String)this.copyDepClassifier)) {
            ClassifierTypeTranslator translator = new ClassifierTypeTranslator(this.copyDepClassifier, this.type, this.factory);
            artifacts = translator.translate(artifacts, this.getLog());
            status = this.filterMarkedDependencies(artifacts);
            artifacts = status.getResolvedDependencies();
            DefaultArtifactsResolver artifactsResolver = new DefaultArtifactsResolver(this.resolver, this.local, this.remoteRepos, stopOnFailure);
            resolvedArtifacts = artifactsResolver.resolve(artifacts, this.getLog());
            unResolvedArtifacts.addAll(artifacts);
            unResolvedArtifacts.removeAll(resolvedArtifacts);
        }
        status.setResolvedDependencies(resolvedArtifacts);
        status.setUnResolvedDependencies(unResolvedArtifacts);
        return status;
    }

    protected DependencyStatusSets filterMarkedDependencies(Set artifacts) throws MojoExecutionException {
        Set unMarkedArtifacts;
        FilterArtifacts filter = new FilterArtifacts();
        filter.clearFilters();
        filter.addFilter(this.getMarkedArtifactFilter());
        try {
            unMarkedArtifacts = filter.filter(artifacts);
        }
        catch (ArtifactFilterException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        HashSet skippedArtifacts = new HashSet();
        skippedArtifacts.addAll(artifacts);
        skippedArtifacts.removeAll(unMarkedArtifacts);
        return new DependencyStatusSets(unMarkedArtifacts, null, skippedArtifacts);
    }

    protected void copyFile(File artifact, File destFile) throws MojoExecutionException {
        try {
            this.getLog().info((CharSequence)("Copying " + (this.outputAbsoluteArtifactFilename ? artifact.getAbsolutePath() : artifact.getName()) + " to " + destFile));
            FileUtils.copyFile((File)artifact, (File)destFile);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error copying artifact from " + artifact + " to " + destFile, e);
        }
    }

    private File getClassesDirectory() {
        File outputDirectory = this.projectBuildDirectory;
        return new File(outputDirectory, "classes");
    }

    private File getDependenciesDirectory() {
        return new File(this.getClassesDirectory(), "META-INF/bundled-dependencies");
    }

    private void makeNar() throws MojoExecutionException {
        File narFile = this.createArchive();
        if (this.classifier != null) {
            this.projectHelper.attachArtifact(this.project, "nar", this.classifier, narFile);
        } else {
            this.project.getArtifact().setFile(narFile);
        }
    }

    public File createArchive() throws MojoExecutionException {
        File outputDirectory = this.projectBuildDirectory;
        File narFile = this.getNarFile(outputDirectory, this.finalName, this.classifier);
        MavenArchiver archiver = new MavenArchiver();
        archiver.setCreatedBy("Apache NiFi Nar Maven Plugin", "org.apache.nifi", "nifi-nar-maven-plugin");
        archiver.setArchiver(this.jarArchiver);
        archiver.setOutputFile(narFile);
        Date timestamp = archiver.configureReproducible(this.outputTimestamp);
        this.archive.setForced(this.forceCreation);
        try {
            File contentDirectory = this.getClassesDirectory();
            if (contentDirectory.exists()) {
                archiver.getArchiver().addDirectory(contentDirectory, this.getIncludes(), this.getExcludes());
            } else {
                this.getLog().warn((CharSequence)"NAR will be empty - no content was marked for inclusion!");
            }
            File extensionDocsFile = this.getExtensionsDocumentationFile();
            if (extensionDocsFile.exists()) {
                archiver.getArchiver().addFile(extensionDocsFile, "META-INF/docs/" + extensionDocsFile.getName());
            } else {
                this.getLog().warn((CharSequence)("NAR will not contain any Extensions' documentation - no META-INF/" + extensionDocsFile.getName() + " file found!"));
            }
            File additionalDetailsDirectory = new File(this.getExtensionsDocumentationFile().getParentFile(), "additional-details");
            if (additionalDetailsDirectory.exists()) {
                archiver.getArchiver().addDirectory(additionalDetailsDirectory, "META-INF/docs/additional-details/");
            }
            File existingManifest = this.defaultManifestFile;
            if (this.useDefaultManifestFile && existingManifest.exists() && this.archive.getManifestFile() == null) {
                this.getLog().info((CharSequence)("Adding existing MANIFEST to archive. Found under: " + existingManifest.getPath()));
                this.archive.setManifestFile(existingManifest);
            }
            this.archive.addManifestEntry("Nar-Id", this.narId);
            this.archive.addManifestEntry("Nar-Group", this.narGroup);
            this.archive.addManifestEntry("Nar-Version", this.narVersion);
            NarDependency narDependency = this.getNarDependency();
            if (narDependency != null) {
                String narDependencyGroup = this.notEmpty(this.narDependencyGroup) ? this.narDependencyGroup : narDependency.getGroupId();
                String narDependencyId = this.notEmpty(this.narDependencyId) ? this.narDependencyId : narDependency.getArtifactId();
                String narDependencyVersion = this.notEmpty(this.narDependencyVersion) ? this.narDependencyVersion : narDependency.getVersion();
                this.archive.addManifestEntry("Nar-Dependency-Group", narDependencyGroup);
                this.archive.addManifestEntry("Nar-Dependency-Id", narDependencyId);
                this.archive.addManifestEntry("Nar-Dependency-Version", narDependencyVersion);
            }
            if (this.notEmpty(this.buildTag)) {
                this.archive.addManifestEntry("Build-Tag", this.buildTag);
            }
            if (this.notEmpty(this.buildBranch)) {
                this.archive.addManifestEntry("Build-Branch", this.buildBranch);
            }
            if (this.notEmpty(this.buildRevision)) {
                this.archive.addManifestEntry("Build-Revision", this.buildRevision);
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat(BUILD_TIMESTAMP_FORMAT);
            this.archive.addManifestEntry("Build-Timestamp", dateFormat.format(timestamp == null ? new Date() : timestamp));
            this.archive.addManifestEntry("Clone-During-Instance-Class-Loading", String.valueOf(this.cloneDuringInstanceClassLoading));
            archiver.createArchive(this.session, this.project, this.archive);
            return narFile;
        }
        catch (IOException | DependencyResolutionRequiredException | MojoExecutionException | ArchiverException | ManifestException e) {
            throw new MojoExecutionException("Error assembling NAR", (Exception)e);
        }
    }

    private boolean notEmpty(String value) {
        return value != null && !value.isEmpty();
    }

    private String[] getIncludes() {
        if (this.includes != null && this.includes.length > 0) {
            return this.includes;
        }
        return DEFAULT_INCLUDES;
    }

    private String[] getExcludes() {
        if (this.excludes != null && this.excludes.length > 0) {
            return this.excludes;
        }
        return DEFAULT_EXCLUDES;
    }

    protected File getNarFile(File basedir, String finalName, String classifier) {
        if (classifier == null) {
            classifier = "";
        } else if (classifier.trim().length() > 0 && !classifier.startsWith("-")) {
            classifier = "-" + classifier;
        }
        return new File(basedir, finalName + classifier + ".nar");
    }

    private NarDependency getNarDependency() throws MojoExecutionException {
        NarDependency narDependency = null;
        FilterArtifacts filter = new FilterArtifacts();
        filter.addFilter((ArtifactsFilter)new TypeFilter("nar", ""));
        Set artifacts = this.project.getArtifacts();
        try {
            artifacts = filter.filter(artifacts);
        }
        catch (ArtifactFilterException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        if (artifacts.size() > 1) {
            throw new MojoExecutionException("Each NAR represents a ClassLoader. A NAR dependency allows that NAR's ClassLoader to be used as the parent of this NAR's ClassLoader. As a result, only a single NAR dependency is allowed.");
        }
        if (artifacts.size() == 1) {
            Artifact artifact = (Artifact)artifacts.iterator().next();
            narDependency = new NarDependency(artifact.getGroupId(), artifact.getArtifactId(), artifact.getBaseVersion());
        }
        return narDependency;
    }

    private static class NarDependency {
        final String groupId;
        final String artifactId;
        final String version;

        public NarDependency(String groupId, String artifactId, String version) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public String getVersion() {
            return this.version;
        }
    }
}

