/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.extension.definition.extraction;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.nifi.extension.definition.ExtensionDefinition;
import org.apache.nifi.extension.definition.ExtensionType;
import org.apache.nifi.extension.definition.ServiceAPIDefinition;
import org.apache.nifi.extension.definition.extraction.ExtensionClassLoader;
import org.apache.nifi.extension.definition.extraction.StandardExtensionDefinition;
import org.apache.nifi.extension.definition.extraction.StandardServiceAPIDefinition;

public class ExtensionDefinitionFactory {
    private static final String SERVICES_DIRECTORY = "META-INF/services/";
    private static final Map<ExtensionType, String> INTERFACE_NAMES = new HashMap<ExtensionType, String>();
    private final ClassLoader extensionClassLoader;

    public ExtensionDefinitionFactory(ClassLoader classLoader) {
        this.extensionClassLoader = classLoader;
    }

    public Set<ExtensionDefinition> discoverExtensions(ExtensionType extensionType) throws IOException {
        String interfaceName = INTERFACE_NAMES.get((Object)extensionType);
        Set<String> classNames = this.discoverClassNames(interfaceName);
        if (classNames.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<ExtensionDefinition> definitions = new HashSet<ExtensionDefinition>();
        for (String className : classNames) {
            try {
                definitions.add(this.createExtensionDefinition(extensionType, className));
            }
            catch (Exception e) {
                throw new IOException("Failed to create Extension Definition for " + (Object)((Object)extensionType) + " " + className, e);
            }
        }
        return definitions;
    }

    private ExtensionDefinition createExtensionDefinition(ExtensionType extensionType, String className) throws ClassNotFoundException {
        Class<?> extensionClass = Class.forName(className, false, this.extensionClassLoader);
        Set<ServiceAPIDefinition> serviceApis = this.getProvidedServiceAPIs(extensionType, extensionClass);
        return new StandardExtensionDefinition(extensionType, className, serviceApis);
    }

    private Set<ServiceAPIDefinition> getProvidedServiceAPIs(ExtensionType extensionType, Class<?> extensionClass) throws ClassNotFoundException {
        if (extensionType != ExtensionType.CONTROLLER_SERVICE) {
            return Collections.emptySet();
        }
        HashSet<ServiceAPIDefinition> serviceApis = new HashSet<ServiceAPIDefinition>();
        Class<?> controllerServiceClass = Class.forName("org.apache.nifi.controller.ControllerService", false, this.extensionClassLoader);
        this.addProvidedServiceAPIs(controllerServiceClass, extensionClass, serviceApis);
        return serviceApis;
    }

    private void addProvidedServiceAPIs(Class<?> controllerServiceClass, Class<?> extensionClass, Set<ServiceAPIDefinition> serviceApis) {
        Class<?>[] extensionInterfaces = extensionClass.getInterfaces();
        if (extensionInterfaces == null) {
            return;
        }
        for (Class<?> immediateInterface : extensionInterfaces) {
            HashSet interfaceHierarchy = new HashSet();
            interfaceHierarchy.add(immediateInterface);
            this.getInterfaceHierarchy(immediateInterface, interfaceHierarchy);
            for (Class clazz : interfaceHierarchy) {
                this.processImplementedInterface(clazz, controllerServiceClass, serviceApis);
            }
        }
        if (extensionClass.getSuperclass() != null) {
            this.addProvidedServiceAPIs(controllerServiceClass, extensionClass.getSuperclass(), serviceApis);
        }
    }

    private void getInterfaceHierarchy(Class<?> implementedInterface, Set<Class<?>> interfaceHierarchy) {
        Class<?>[] parentInterfaces = implementedInterface.getInterfaces();
        if (parentInterfaces == null) {
            return;
        }
        for (Class<?> parentInterface : parentInterfaces) {
            if (interfaceHierarchy.contains(parentInterface)) continue;
            interfaceHierarchy.add(parentInterface);
            this.getInterfaceHierarchy(parentInterface, interfaceHierarchy);
        }
    }

    private void processImplementedInterface(Class<?> implementedInterface, Class<?> controllerServiceClass, Set<ServiceAPIDefinition> serviceApis) {
        ClassLoader interfaceClassLoader;
        if (controllerServiceClass.isAssignableFrom(implementedInterface) && !controllerServiceClass.equals(implementedInterface) && (interfaceClassLoader = implementedInterface.getClassLoader()) instanceof ExtensionClassLoader) {
            Artifact interfaceNarArtifact = ((ExtensionClassLoader)interfaceClassLoader).getNarArtifact();
            StandardServiceAPIDefinition serviceDefinition = new StandardServiceAPIDefinition(implementedInterface.getName(), interfaceNarArtifact.getGroupId(), interfaceNarArtifact.getArtifactId(), interfaceNarArtifact.getBaseVersion());
            serviceApis.add(serviceDefinition);
        }
    }

    private Set<String> discoverClassNames(String extensionType) throws IOException {
        HashSet<String> classNames = new HashSet<String>();
        Enumeration<URL> resources = this.extensionClassLoader.getResources(SERVICES_DIRECTORY + extensionType);
        while (resources.hasMoreElements()) {
            URL resourceUrl = resources.nextElement();
            classNames.addAll(this.discoverClassNames(this.extensionClassLoader, resourceUrl));
        }
        return classNames;
    }

    private Set<String> discoverClassNames(ClassLoader classLoader, URL serviceUrl) throws IOException {
        HashSet<String> classNames = new HashSet<String>();
        try (InputStream in = serviceUrl.openStream();
             InputStreamReader rawReader = new InputStreamReader(in);
             BufferedReader reader = new BufferedReader(rawReader);){
            String line;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                classNames.add(line);
            }
        }
        return classNames;
    }

    static {
        INTERFACE_NAMES.put(ExtensionType.PROCESSOR, "org.apache.nifi.processor.Processor");
        INTERFACE_NAMES.put(ExtensionType.CONTROLLER_SERVICE, "org.apache.nifi.controller.ControllerService");
        INTERFACE_NAMES.put(ExtensionType.REPORTING_TASK, "org.apache.nifi.reporting.ReportingTask");
    }
}

