/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processor.util;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLContext;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.security.util.CertificateUtils;
import org.apache.nifi.security.util.KeystoreType;
import org.apache.nifi.security.util.SslContextFactory;

public class SSLProperties {
    public static final PropertyDescriptor TRUSTSTORE = new PropertyDescriptor.Builder().name("Truststore Filename").description("The fully-qualified filename of the Truststore").defaultValue(null).addValidator(StandardValidators.FILE_EXISTS_VALIDATOR).sensitive(false).build();
    public static final PropertyDescriptor TRUSTSTORE_TYPE = new PropertyDescriptor.Builder().name("Truststore Type").description("The Type of the Truststore. Either JKS or PKCS12").allowableValues(new String[]{"JKS", "PKCS12"}).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).defaultValue(null).sensitive(false).build();
    public static final PropertyDescriptor TRUSTSTORE_PASSWORD = new PropertyDescriptor.Builder().name("Truststore Password").description("The password for the Truststore").defaultValue(null).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).sensitive(true).build();
    public static final PropertyDescriptor KEYSTORE = new PropertyDescriptor.Builder().name("Keystore Filename").description("The fully-qualified filename of the Keystore").defaultValue(null).addValidator(StandardValidators.FILE_EXISTS_VALIDATOR).sensitive(false).build();
    public static final PropertyDescriptor KEYSTORE_TYPE = new PropertyDescriptor.Builder().name("Keystore Type").description("The Type of the Keystore").allowableValues(new String[]{"JKS", "PKCS12"}).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).sensitive(false).build();
    public static final PropertyDescriptor KEYSTORE_PASSWORD = new PropertyDescriptor.Builder().name("Keystore Password").defaultValue(null).description("The password for the Keystore").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).sensitive(true).build();
    private static final String DEFAULT_SSL_PROTOCOL_ALGORITHM = "TLS";
    private static final Set<PropertyDescriptor> KEYSTORE_DESCRIPTORS = new HashSet<PropertyDescriptor>();
    private static final Set<PropertyDescriptor> TRUSTSTORE_DESCRIPTORS = new HashSet<PropertyDescriptor>();

    public static Collection<ValidationResult> validateStore(Map<PropertyDescriptor, String> properties) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        results.addAll(SSLProperties.validateStore(properties, KeystoreValidationGroup.KEYSTORE));
        results.addAll(SSLProperties.validateStore(properties, KeystoreValidationGroup.TRUSTSTORE));
        return results;
    }

    public static Collection<ValidationResult> validateStore(Map<PropertyDescriptor, String> properties, KeystoreValidationGroup keyStoreOrTrustStore) {
        String type;
        String password;
        String filename;
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        if (keyStoreOrTrustStore == KeystoreValidationGroup.KEYSTORE) {
            filename = properties.get(KEYSTORE);
            password = properties.get(KEYSTORE_PASSWORD);
            type = properties.get(KEYSTORE_TYPE);
        } else {
            filename = properties.get(TRUSTSTORE);
            password = properties.get(TRUSTSTORE_PASSWORD);
            type = properties.get(TRUSTSTORE_TYPE);
        }
        String keystoreDesc = keyStoreOrTrustStore == KeystoreValidationGroup.KEYSTORE ? "Keystore" : "Truststore";
        int nulls = SSLProperties.countNulls(filename, password, type);
        if (nulls != 3 && nulls != 0) {
            results.add(new ValidationResult.Builder().valid(false).explanation("Must set either 0 or 3 properties for " + keystoreDesc).subject(keystoreDesc + " Properties").build());
        } else if (nulls == 0) {
            File file = new File(filename);
            if (!file.exists() || !file.canRead()) {
                results.add(new ValidationResult.Builder().valid(false).subject(keystoreDesc + " Properties").explanation("Cannot access file " + file.getAbsolutePath()).build());
            } else {
                try {
                    boolean storeValid = CertificateUtils.isStoreValid((URL)file.toURI().toURL(), (KeystoreType)KeystoreType.valueOf((String)type), (char[])password.toCharArray());
                    if (!storeValid) {
                        results.add(new ValidationResult.Builder().subject(keystoreDesc + " Properties").valid(false).explanation("Invalid KeyStore Password or Type specified for file " + filename).build());
                    }
                }
                catch (MalformedURLException e) {
                    results.add(new ValidationResult.Builder().subject(keystoreDesc + " Properties").valid(false).explanation("Malformed URL from file: " + e).build());
                }
            }
        }
        return results;
    }

    private static int countNulls(Object ... objects) {
        int count = 0;
        for (Object x : objects) {
            if (x != null) continue;
            ++count;
        }
        return count;
    }

    public static List<PropertyDescriptor> getKeystoreDescriptors(boolean required) {
        ArrayList<PropertyDescriptor> descriptors = new ArrayList<PropertyDescriptor>();
        for (PropertyDescriptor descriptor : KEYSTORE_DESCRIPTORS) {
            PropertyDescriptor.Builder builder = new PropertyDescriptor.Builder().fromPropertyDescriptor(descriptor).required(required);
            if (required && descriptor.getName().equals(KEYSTORE_TYPE.getName())) {
                builder.defaultValue("JKS");
            }
            descriptors.add(builder.build());
        }
        return descriptors;
    }

    public static List<PropertyDescriptor> getTruststoreDescriptors(boolean required) {
        ArrayList<PropertyDescriptor> descriptors = new ArrayList<PropertyDescriptor>();
        for (PropertyDescriptor descriptor : TRUSTSTORE_DESCRIPTORS) {
            PropertyDescriptor.Builder builder = new PropertyDescriptor.Builder().fromPropertyDescriptor(descriptor).required(required);
            if (required && descriptor.getName().equals(TRUSTSTORE_TYPE.getName())) {
                builder.defaultValue("JKS");
            }
            descriptors.add(builder.build());
        }
        return descriptors;
    }

    public static SSLContext createSSLContext(ProcessContext context, SslContextFactory.ClientAuth clientAuth) throws UnrecoverableKeyException, KeyManagementException, KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        String keystoreFile = context.getProperty(KEYSTORE).getValue();
        if (keystoreFile == null) {
            return SslContextFactory.createTrustSslContext((String)context.getProperty(TRUSTSTORE).getValue(), (char[])context.getProperty(TRUSTSTORE_PASSWORD).getValue().toCharArray(), (String)context.getProperty(TRUSTSTORE_TYPE).getValue(), (String)DEFAULT_SSL_PROTOCOL_ALGORITHM);
        }
        String truststoreFile = context.getProperty(TRUSTSTORE).getValue();
        if (truststoreFile == null) {
            return SslContextFactory.createSslContext((String)context.getProperty(KEYSTORE).getValue(), (char[])context.getProperty(KEYSTORE_PASSWORD).getValue().toCharArray(), (String)context.getProperty(KEYSTORE_TYPE).getValue(), (String)DEFAULT_SSL_PROTOCOL_ALGORITHM);
        }
        return SslContextFactory.createSslContext((String)context.getProperty(KEYSTORE).getValue(), (char[])context.getProperty(KEYSTORE_PASSWORD).getValue().toCharArray(), (String)context.getProperty(KEYSTORE_TYPE).getValue(), (String)context.getProperty(TRUSTSTORE).getValue(), (char[])context.getProperty(TRUSTSTORE_PASSWORD).getValue().toCharArray(), (String)context.getProperty(TRUSTSTORE_TYPE).getValue(), (SslContextFactory.ClientAuth)clientAuth, (String)DEFAULT_SSL_PROTOCOL_ALGORITHM);
    }

    static {
        KEYSTORE_DESCRIPTORS.add(KEYSTORE);
        KEYSTORE_DESCRIPTORS.add(KEYSTORE_TYPE);
        KEYSTORE_DESCRIPTORS.add(KEYSTORE_PASSWORD);
        TRUSTSTORE_DESCRIPTORS.add(TRUSTSTORE);
        TRUSTSTORE_DESCRIPTORS.add(TRUSTSTORE_TYPE);
        TRUSTSTORE_DESCRIPTORS.add(TRUSTSTORE_PASSWORD);
    }

    public static enum KeystoreValidationGroup {
        KEYSTORE,
        TRUSTSTORE;

    }
}

