/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processor.util.listen.event;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.Validate;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.util.listen.event.Event;

public class EventQueue<E extends Event> {
    public static final long DEFAULT_OFFER_WAIT_MS = 100L;
    private final long offerWaitMs;
    private final BlockingQueue<E> events;
    private final ComponentLog logger;

    public EventQueue(BlockingQueue<E> events, ComponentLog logger) {
        this(events, 100L, logger);
    }

    public EventQueue(BlockingQueue<E> events, long offerWaitMs, ComponentLog logger) {
        this.events = events;
        this.offerWaitMs = offerWaitMs;
        this.logger = logger;
        Validate.notNull(this.events);
        Validate.notNull((Object)this.logger);
    }

    public void offer(E event) throws InterruptedException {
        boolean queued = this.events.offer(event, this.offerWaitMs, TimeUnit.MILLISECONDS);
        if (!queued) {
            this.logger.error("Internal queue at maximum capacity, could not queue event");
        }
    }
}

