/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.nifi.util.StringUtils;

public abstract class NiFiProperties {
    public static final String PROPERTIES_FILE_PATH = "nifi.properties.file.path";
    public static final String FLOW_CONFIGURATION_FILE = "nifi.flow.configuration.file";
    public static final String FLOW_CONFIGURATION_ARCHIVE_ENABLED = "nifi.flow.configuration.archive.enabled";
    public static final String FLOW_CONFIGURATION_ARCHIVE_DIR = "nifi.flow.configuration.archive.dir";
    public static final String FLOW_CONFIGURATION_ARCHIVE_MAX_TIME = "nifi.flow.configuration.archive.max.time";
    public static final String FLOW_CONFIGURATION_ARCHIVE_MAX_STORAGE = "nifi.flow.configuration.archive.max.storage";
    public static final String FLOW_CONFIGURATION_ARCHIVE_MAX_COUNT = "nifi.flow.configuration.archive.max.count";
    public static final String AUTHORIZER_CONFIGURATION_FILE = "nifi.authorizer.configuration.file";
    public static final String LOGIN_IDENTITY_PROVIDER_CONFIGURATION_FILE = "nifi.login.identity.provider.configuration.file";
    public static final String REPOSITORY_DATABASE_DIRECTORY = "nifi.database.directory";
    public static final String RESTORE_DIRECTORY = "nifi.restore.directory";
    public static final String WRITE_DELAY_INTERVAL = "nifi.flowservice.writedelay.interval";
    public static final String AUTO_RESUME_STATE = "nifi.flowcontroller.autoResumeState";
    public static final String FLOW_CONTROLLER_GRACEFUL_SHUTDOWN_PERIOD = "nifi.flowcontroller.graceful.shutdown.period";
    public static final String NAR_LIBRARY_DIRECTORY = "nifi.nar.library.directory";
    public static final String NAR_LIBRARY_DIRECTORY_PREFIX = "nifi.nar.library.directory.";
    public static final String NAR_LIBRARY_AUTOLOAD_DIRECTORY = "nifi.nar.library.autoload.directory";
    public static final String NAR_WORKING_DIRECTORY = "nifi.nar.working.directory";
    public static final String COMPONENT_DOCS_DIRECTORY = "nifi.documentation.working.directory";
    public static final String SENSITIVE_PROPS_KEY = "nifi.sensitive.props.key";
    public static final String SENSITIVE_PROPS_ALGORITHM = "nifi.sensitive.props.algorithm";
    public static final String SENSITIVE_PROPS_PROVIDER = "nifi.sensitive.props.provider";
    public static final String H2_URL_APPEND = "nifi.h2.url.append";
    public static final String REMOTE_INPUT_HOST = "nifi.remote.input.host";
    public static final String REMOTE_INPUT_PORT = "nifi.remote.input.socket.port";
    public static final String SITE_TO_SITE_SECURE = "nifi.remote.input.secure";
    public static final String SITE_TO_SITE_HTTP_ENABLED = "nifi.remote.input.http.enabled";
    public static final String SITE_TO_SITE_HTTP_TRANSACTION_TTL = "nifi.remote.input.http.transaction.ttl";
    public static final String REMOTE_CONTENTS_CACHE_EXPIRATION = "nifi.remote.contents.cache.expiration";
    public static final String TEMPLATE_DIRECTORY = "nifi.templates.directory";
    public static final String ADMINISTRATIVE_YIELD_DURATION = "nifi.administrative.yield.duration";
    public static final String PERSISTENT_STATE_DIRECTORY = "nifi.persistent.state.directory";
    public static final String BORED_YIELD_DURATION = "nifi.bored.yield.duration";
    public static final String PROCESSOR_SCHEDULING_TIMEOUT = "nifi.processor.scheduling.timeout";
    public static final String BACKPRESSURE_COUNT = "nifi.queue.backpressure.count";
    public static final String BACKPRESSURE_SIZE = "nifi.queue.backpressure.size";
    public static final String REPOSITORY_CONTENT_PREFIX = "nifi.content.repository.directory.";
    public static final String CONTENT_REPOSITORY_IMPLEMENTATION = "nifi.content.repository.implementation";
    public static final String MAX_APPENDABLE_CLAIM_SIZE = "nifi.content.claim.max.appendable.size";
    public static final String MAX_FLOWFILES_PER_CLAIM = "nifi.content.claim.max.flow.files";
    public static final String CONTENT_ARCHIVE_MAX_RETENTION_PERIOD = "nifi.content.repository.archive.max.retention.period";
    public static final String CONTENT_ARCHIVE_MAX_USAGE_PERCENTAGE = "nifi.content.repository.archive.max.usage.percentage";
    public static final String CONTENT_ARCHIVE_BACK_PRESSURE_PERCENTAGE = "nifi.content.repository.archive.backpressure.percentage";
    public static final String CONTENT_ARCHIVE_ENABLED = "nifi.content.repository.archive.enabled";
    public static final String CONTENT_ARCHIVE_CLEANUP_FREQUENCY = "nifi.content.repository.archive.cleanup.frequency";
    public static final String CONTENT_VIEWER_URL = "nifi.content.viewer.url";
    public static final String FLOWFILE_REPOSITORY_IMPLEMENTATION = "nifi.flowfile.repository.implementation";
    public static final String FLOWFILE_REPOSITORY_ALWAYS_SYNC = "nifi.flowfile.repository.always.sync";
    public static final String FLOWFILE_REPOSITORY_DIRECTORY = "nifi.flowfile.repository.directory";
    public static final String FLOWFILE_REPOSITORY_PARTITIONS = "nifi.flowfile.repository.partitions";
    public static final String FLOWFILE_REPOSITORY_CHECKPOINT_INTERVAL = "nifi.flowfile.repository.checkpoint.interval";
    public static final String FLOWFILE_SWAP_MANAGER_IMPLEMENTATION = "nifi.swap.manager.implementation";
    public static final String QUEUE_SWAP_THRESHOLD = "nifi.queue.swap.threshold";
    public static final String SWAP_IN_THREADS = "nifi.swap.in.threads";
    public static final String SWAP_IN_PERIOD = "nifi.swap.in.period";
    public static final String SWAP_OUT_THREADS = "nifi.swap.out.threads";
    public static final String SWAP_OUT_PERIOD = "nifi.swap.out.period";
    public static final String PROVENANCE_REPO_IMPLEMENTATION_CLASS = "nifi.provenance.repository.implementation";
    public static final String PROVENANCE_REPO_DIRECTORY_PREFIX = "nifi.provenance.repository.directory.";
    public static final String PROVENANCE_MAX_STORAGE_TIME = "nifi.provenance.repository.max.storage.time";
    public static final String PROVENANCE_MAX_STORAGE_SIZE = "nifi.provenance.repository.max.storage.size";
    public static final String PROVENANCE_ROLLOVER_TIME = "nifi.provenance.repository.rollover.time";
    public static final String PROVENANCE_ROLLOVER_SIZE = "nifi.provenance.repository.rollover.size";
    public static final String PROVENANCE_QUERY_THREAD_POOL_SIZE = "nifi.provenance.repository.query.threads";
    public static final String PROVENANCE_INDEX_THREAD_POOL_SIZE = "nifi.provenance.repository.index.threads";
    public static final String PROVENANCE_COMPRESS_ON_ROLLOVER = "nifi.provenance.repository.compress.on.rollover";
    public static final String PROVENANCE_INDEXED_FIELDS = "nifi.provenance.repository.indexed.fields";
    public static final String PROVENANCE_INDEXED_ATTRIBUTES = "nifi.provenance.repository.indexed.attributes";
    public static final String PROVENANCE_INDEX_SHARD_SIZE = "nifi.provenance.repository.index.shard.size";
    public static final String PROVENANCE_JOURNAL_COUNT = "nifi.provenance.repository.journal.count";
    public static final String PROVENANCE_REPO_ENCRYPTION_KEY = "nifi.provenance.repository.encryption.key";
    public static final String PROVENANCE_REPO_ENCRYPTION_KEY_ID = "nifi.provenance.repository.encryption.key.id";
    public static final String PROVENANCE_REPO_ENCRYPTION_KEY_PROVIDER_IMPLEMENTATION_CLASS = "nifi.provenance.repository.encryption.key.provider.implementation";
    public static final String PROVENANCE_REPO_ENCRYPTION_KEY_PROVIDER_LOCATION = "nifi.provenance.repository.encryption.key.provider.location";
    public static final String PROVENANCE_REPO_DEBUG_FREQUENCY = "nifi.provenance.repository.debug.frequency";
    public static final String COMPONENT_STATUS_REPOSITORY_IMPLEMENTATION = "nifi.components.status.repository.implementation";
    public static final String COMPONENT_STATUS_SNAPSHOT_FREQUENCY = "nifi.components.status.snapshot.frequency";
    public static final String SECURITY_KEYSTORE = "nifi.security.keystore";
    public static final String SECURITY_KEYSTORE_TYPE = "nifi.security.keystoreType";
    public static final String SECURITY_KEYSTORE_PASSWD = "nifi.security.keystorePasswd";
    public static final String SECURITY_KEY_PASSWD = "nifi.security.keyPasswd";
    public static final String SECURITY_TRUSTSTORE = "nifi.security.truststore";
    public static final String SECURITY_TRUSTSTORE_TYPE = "nifi.security.truststoreType";
    public static final String SECURITY_TRUSTSTORE_PASSWD = "nifi.security.truststorePasswd";
    public static final String SECURITY_USER_AUTHORIZER = "nifi.security.user.authorizer";
    public static final String SECURITY_USER_LOGIN_IDENTITY_PROVIDER = "nifi.security.user.login.identity.provider";
    public static final String SECURITY_OCSP_RESPONDER_URL = "nifi.security.ocsp.responder.url";
    public static final String SECURITY_OCSP_RESPONDER_CERTIFICATE = "nifi.security.ocsp.responder.certificate";
    public static final String SECURITY_IDENTITY_MAPPING_PATTERN_PREFIX = "nifi.security.identity.mapping.pattern.";
    public static final String SECURITY_IDENTITY_MAPPING_VALUE_PREFIX = "nifi.security.identity.mapping.value.";
    public static final String SECURITY_IDENTITY_MAPPING_TRANSFORM_PREFIX = "nifi.security.identity.mapping.transform.";
    public static final String SECURITY_GROUP_MAPPING_PATTERN_PREFIX = "nifi.security.group.mapping.pattern.";
    public static final String SECURITY_GROUP_MAPPING_VALUE_PREFIX = "nifi.security.group.mapping.value.";
    public static final String SECURITY_GROUP_MAPPING_TRANSFORM_PREFIX = "nifi.security.group.mapping.transform.";
    public static final String SECURITY_USER_OIDC_DISCOVERY_URL = "nifi.security.user.oidc.discovery.url";
    public static final String SECURITY_USER_OIDC_CONNECT_TIMEOUT = "nifi.security.user.oidc.connect.timeout";
    public static final String SECURITY_USER_OIDC_READ_TIMEOUT = "nifi.security.user.oidc.read.timeout";
    public static final String SECURITY_USER_OIDC_CLIENT_ID = "nifi.security.user.oidc.client.id";
    public static final String SECURITY_USER_OIDC_CLIENT_SECRET = "nifi.security.user.oidc.client.secret";
    public static final String SECURITY_USER_OIDC_PREFERRED_JWSALGORITHM = "nifi.security.user.oidc.preferred.jwsalgorithm";
    public static final String SECURITY_USER_KNOX_URL = "nifi.security.user.knox.url";
    public static final String SECURITY_USER_KNOX_PUBLIC_KEY = "nifi.security.user.knox.publicKey";
    public static final String SECURITY_USER_KNOX_COOKIE_NAME = "nifi.security.user.knox.cookieName";
    public static final String SECURITY_USER_KNOX_AUDIENCES = "nifi.security.user.knox.audiences";
    public static final String WEB_WAR_DIR = "nifi.web.war.directory";
    public static final String WEB_HTTP_PORT = "nifi.web.http.port";
    public static final String WEB_HTTP_PORT_FORWARDING = "nifi.web.http.port.forwarding";
    public static final String WEB_HTTP_HOST = "nifi.web.http.host";
    public static final String WEB_HTTP_NETWORK_INTERFACE_PREFIX = "nifi.web.http.network.interface.";
    public static final String WEB_HTTPS_PORT = "nifi.web.https.port";
    public static final String WEB_HTTPS_PORT_FORWARDING = "nifi.web.https.port.forwarding";
    public static final String WEB_HTTPS_HOST = "nifi.web.https.host";
    public static final String WEB_HTTPS_NETWORK_INTERFACE_PREFIX = "nifi.web.https.network.interface.";
    public static final String WEB_WORKING_DIR = "nifi.web.jetty.working.directory";
    public static final String WEB_THREADS = "nifi.web.jetty.threads";
    public static final String WEB_MAX_HEADER_SIZE = "nifi.web.max.header.size";
    public static final String WEB_PROXY_CONTEXT_PATH = "nifi.web.proxy.context.path";
    public static final String WEB_PROXY_HOST = "nifi.web.proxy.host";
    public static final String UI_BANNER_TEXT = "nifi.ui.banner.text";
    public static final String UI_AUTO_REFRESH_INTERVAL = "nifi.ui.autorefresh.interval";
    public static final String CLUSTER_PROTOCOL_HEARTBEAT_INTERVAL = "nifi.cluster.protocol.heartbeat.interval";
    public static final String CLUSTER_PROTOCOL_IS_SECURE = "nifi.cluster.protocol.is.secure";
    public static final String CLUSTER_IS_NODE = "nifi.cluster.is.node";
    public static final String CLUSTER_NODE_ADDRESS = "nifi.cluster.node.address";
    public static final String CLUSTER_NODE_PROTOCOL_PORT = "nifi.cluster.node.protocol.port";
    public static final String CLUSTER_NODE_PROTOCOL_THREADS = "nifi.cluster.node.protocol.threads";
    public static final String CLUSTER_NODE_PROTOCOL_MAX_THREADS = "nifi.cluster.node.protocol.max.threads";
    public static final String CLUSTER_NODE_CONNECTION_TIMEOUT = "nifi.cluster.node.connection.timeout";
    public static final String CLUSTER_NODE_READ_TIMEOUT = "nifi.cluster.node.read.timeout";
    public static final String CLUSTER_NODE_MAX_CONCURRENT_REQUESTS = "nifi.cluster.node.max.concurrent.requests";
    public static final String CLUSTER_FIREWALL_FILE = "nifi.cluster.firewall.file";
    public static final String FLOW_ELECTION_MAX_WAIT_TIME = "nifi.cluster.flow.election.max.wait.time";
    public static final String FLOW_ELECTION_MAX_CANDIDATES = "nifi.cluster.flow.election.max.candidates";
    public static final String LOAD_BALANCE_ADDRESS = "nifi.cluster.load.balance.address";
    public static final String LOAD_BALANCE_PORT = "nifi.cluster.load.balance.port";
    public static final String LOAD_BALANCE_CONNECTIONS_PER_NODE = "nifi.cluster.load.balance.connections.per.node";
    public static final String LOAD_BALANCE_MAX_THREAD_COUNT = "nifi.cluster.load.balance.max.thread.count";
    public static final String LOAD_BALANCE_COMMS_TIMEOUT = "nifi.cluster.load.balance.comms.timeout";
    public static final String ZOOKEEPER_CONNECT_STRING = "nifi.zookeeper.connect.string";
    public static final String ZOOKEEPER_CONNECT_TIMEOUT = "nifi.zookeeper.connect.timeout";
    public static final String ZOOKEEPER_SESSION_TIMEOUT = "nifi.zookeeper.session.timeout";
    public static final String ZOOKEEPER_ROOT_NODE = "nifi.zookeeper.root.node";
    public static final String ZOOKEEPER_AUTH_TYPE = "nifi.zookeeper.auth.type";
    public static final String ZOOKEEPER_KERBEROS_REMOVE_HOST_FROM_PRINCIPAL = "nifi.zookeeper.kerberos.removeHostFromPrincipal";
    public static final String ZOOKEEPER_KERBEROS_REMOVE_REALM_FROM_PRINCIPAL = "nifi.zookeeper.kerberos.removeRealmFromPrincipal";
    public static final String KERBEROS_KRB5_FILE = "nifi.kerberos.krb5.file";
    public static final String KERBEROS_SERVICE_PRINCIPAL = "nifi.kerberos.service.principal";
    public static final String KERBEROS_SERVICE_KEYTAB_LOCATION = "nifi.kerberos.service.keytab.location";
    public static final String KERBEROS_SPNEGO_PRINCIPAL = "nifi.kerberos.spnego.principal";
    public static final String KERBEROS_SPNEGO_KEYTAB_LOCATION = "nifi.kerberos.spnego.keytab.location";
    public static final String KERBEROS_AUTHENTICATION_EXPIRATION = "nifi.kerberos.spnego.authentication.expiration";
    public static final String STATE_MANAGEMENT_CONFIG_FILE = "nifi.state.management.configuration.file";
    public static final String STATE_MANAGEMENT_LOCAL_PROVIDER_ID = "nifi.state.management.provider.local";
    public static final String STATE_MANAGEMENT_CLUSTER_PROVIDER_ID = "nifi.state.management.provider.cluster";
    public static final String STATE_MANAGEMENT_START_EMBEDDED_ZOOKEEPER = "nifi.state.management.embedded.zookeeper.start";
    public static final String STATE_MANAGEMENT_ZOOKEEPER_PROPERTIES = "nifi.state.management.embedded.zookeeper.properties";
    public static final String VARIABLE_REGISTRY_PROPERTIES = "nifi.variable.registry.properties";
    public static final Boolean DEFAULT_AUTO_RESUME_STATE = true;
    public static final String DEFAULT_AUTHORIZER_CONFIGURATION_FILE = "conf/authorizers.xml";
    public static final String DEFAULT_LOGIN_IDENTITY_PROVIDER_CONFIGURATION_FILE = "conf/login-identity-providers.xml";
    public static final Integer DEFAULT_REMOTE_INPUT_PORT = null;
    public static final Path DEFAULT_TEMPLATE_DIRECTORY = Paths.get("conf", "templates");
    public static final int DEFAULT_WEB_THREADS = 200;
    public static final String DEFAULT_WEB_MAX_HEADER_SIZE = "16 KB";
    public static final String DEFAULT_WEB_WORKING_DIR = "./work/jetty";
    public static final String DEFAULT_NAR_WORKING_DIR = "./work/nar";
    public static final String DEFAULT_COMPONENT_DOCS_DIRECTORY = "./work/docs/components";
    public static final String DEFAULT_NAR_LIBRARY_DIR = "./lib";
    public static final String DEFAULT_NAR_LIBRARY_AUTOLOAD_DIR = "./extensions";
    public static final String DEFAULT_FLOWFILE_REPO_PARTITIONS = "256";
    public static final String DEFAULT_FLOWFILE_CHECKPOINT_INTERVAL = "2 min";
    public static final int DEFAULT_MAX_FLOWFILES_PER_CLAIM = 100;
    public static final String DEFAULT_MAX_APPENDABLE_CLAIM_SIZE = "1 MB";
    public static final int DEFAULT_QUEUE_SWAP_THRESHOLD = 20000;
    public static final String DEFAULT_SWAP_STORAGE_LOCATION = "./flowfile_repository/swap";
    public static final String DEFAULT_SWAP_IN_PERIOD = "1 sec";
    public static final String DEFAULT_SWAP_OUT_PERIOD = "5 sec";
    public static final int DEFAULT_SWAP_IN_THREADS = 4;
    public static final int DEFAULT_SWAP_OUT_THREADS = 4;
    public static final long DEFAULT_BACKPRESSURE_COUNT = 10000L;
    public static final String DEFAULT_BACKPRESSURE_SIZE = "1 GB";
    public static final String DEFAULT_ADMINISTRATIVE_YIELD_DURATION = "30 sec";
    public static final String DEFAULT_PERSISTENT_STATE_DIRECTORY = "./conf/state";
    public static final String DEFAULT_COMPONENT_STATUS_SNAPSHOT_FREQUENCY = "5 mins";
    public static final String DEFAULT_BORED_YIELD_DURATION = "10 millis";
    public static final String DEFAULT_ZOOKEEPER_CONNECT_TIMEOUT = "3 secs";
    public static final String DEFAULT_ZOOKEEPER_SESSION_TIMEOUT = "3 secs";
    public static final String DEFAULT_ZOOKEEPER_ROOT_NODE = "/nifi";
    public static final String DEFAULT_ZOOKEEPER_AUTH_TYPE = "default";
    public static final String DEFAULT_ZOOKEEPER_KERBEROS_REMOVE_HOST_FROM_PRINCIPAL = "true";
    public static final String DEFAULT_ZOOKEEPER_KERBEROS_REMOVE_REALM_FROM_PRINCIPAL = "true";
    public static final String DEFAULT_SITE_TO_SITE_HTTP_TRANSACTION_TTL = "30 secs";
    public static final String DEFAULT_FLOW_CONFIGURATION_ARCHIVE_ENABLED = "true";
    public static final String DEFAULT_FLOW_CONFIGURATION_ARCHIVE_MAX_TIME = "30 days";
    public static final String DEFAULT_FLOW_CONFIGURATION_ARCHIVE_MAX_STORAGE = "500 MB";
    public static final String DEFAULT_SECURITY_USER_OIDC_CONNECT_TIMEOUT = "5 secs";
    public static final String DEFAULT_SECURITY_USER_OIDC_READ_TIMEOUT = "5 secs";
    public static final String DEFAULT_CLUSTER_PROTOCOL_HEARTBEAT_INTERVAL = "5 sec";
    public static final String DEFAULT_CLUSTER_PROTOCOL_MULTICAST_SERVICE_BROADCAST_DELAY = "500 ms";
    public static final int DEFAULT_CLUSTER_PROTOCOL_MULTICAST_SERVICE_LOCATOR_ATTEMPTS = 3;
    public static final String DEFAULT_CLUSTER_PROTOCOL_MULTICAST_SERVICE_LOCATOR_ATTEMPTS_DELAY = "1 sec";
    public static final String DEFAULT_CLUSTER_NODE_READ_TIMEOUT = "5 sec";
    public static final String DEFAULT_CLUSTER_NODE_CONNECTION_TIMEOUT = "5 sec";
    public static final int DEFAULT_CLUSTER_NODE_MAX_CONCURRENT_REQUESTS = 100;
    public static final int DEFAULT_CLUSTER_NODE_PROTOCOL_THREADS = 10;
    public static final int DEFAULT_CLUSTER_NODE_PROTOCOL_MAX_THREADS = 50;
    public static final String DEFAULT_REQUEST_REPLICATION_CLAIM_TIMEOUT = "15 secs";
    public static final String DEFAULT_FLOW_ELECTION_MAX_WAIT_TIME = "5 mins";
    public static final int DEFAULT_LOAD_BALANCE_PORT = 6342;
    public static final int DEFAULT_LOAD_BALANCE_CONNECTIONS_PER_NODE = 4;
    public static final int DEFAULT_LOAD_BALANCE_MAX_THREAD_COUNT = 8;
    public static final String DEFAULT_LOAD_BALANCE_COMMS_TIMEOUT = "30 sec";
    public static final String DEFAULT_STATE_MANAGEMENT_CONFIG_FILE = "conf/state-management.xml";
    public static final String DEFAULT_KERBEROS_AUTHENTICATION_EXPIRATION = "12 hours";

    public abstract String getProperty(String var1);

    public abstract Set<String> getPropertyKeys();

    public File getFlowConfigurationFile() {
        try {
            return new File(this.getProperty(FLOW_CONFIGURATION_FILE));
        }
        catch (Exception ex) {
            return null;
        }
    }

    public File getFlowConfigurationFileDir() {
        try {
            return this.getFlowConfigurationFile().getParentFile();
        }
        catch (Exception ex) {
            return null;
        }
    }

    private Integer getPropertyAsPort(String propertyName, Integer defaultValue) {
        String port = this.getProperty(propertyName);
        if (StringUtils.isEmpty(port)) {
            return defaultValue;
        }
        try {
            int val = Integer.parseInt(port);
            if (val <= 0 || val > 65535) {
                throw new RuntimeException("Valid port range is 0 - 65535 but got " + val);
            }
            return val;
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public int getQueueSwapThreshold() {
        String thresholdValue = this.getProperty(QUEUE_SWAP_THRESHOLD);
        if (thresholdValue == null) {
            return 20000;
        }
        try {
            return Integer.parseInt(thresholdValue);
        }
        catch (NumberFormatException e) {
            return 20000;
        }
    }

    public Integer getIntegerProperty(String propertyName, Integer defaultValue) {
        String value = this.getProperty(propertyName);
        if (value == null || value.trim().isEmpty()) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value.trim());
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public int getSwapInThreads() {
        return this.getIntegerProperty(SWAP_IN_THREADS, 4);
    }

    public int getSwapOutThreads() {
        String value = this.getProperty(SWAP_OUT_THREADS);
        if (value == null) {
            return 4;
        }
        try {
            return Integer.parseInt(this.getProperty(SWAP_OUT_THREADS));
        }
        catch (Exception e) {
            return 4;
        }
    }

    public String getSwapInPeriod() {
        return this.getProperty(SWAP_IN_PERIOD, "1 sec");
    }

    public String getSwapOutPeriod() {
        return this.getProperty(SWAP_OUT_PERIOD, "5 sec");
    }

    public String getAdministrativeYieldDuration() {
        return this.getProperty(ADMINISTRATIVE_YIELD_DURATION, "30 sec");
    }

    public String getRemoteInputHost() {
        String value = this.getProperty(REMOTE_INPUT_HOST);
        return StringUtils.isBlank(value) ? null : value;
    }

    public Integer getRemoteInputPort() {
        return this.getPropertyAsPort(REMOTE_INPUT_PORT, DEFAULT_REMOTE_INPUT_PORT);
    }

    public Boolean isSiteToSiteSecure() {
        String secureVal = this.getProperty(SITE_TO_SITE_SECURE, "true");
        return !"false".equalsIgnoreCase(secureVal);
    }

    public Boolean isSiteToSiteHttpEnabled() {
        String remoteInputHttpEnabled = this.getProperty(SITE_TO_SITE_HTTP_ENABLED, "false");
        return "true".equalsIgnoreCase(remoteInputHttpEnabled);
    }

    public Integer getRemoteInputHttpPort() {
        if (!this.isSiteToSiteHttpEnabled().booleanValue()) {
            return null;
        }
        String propertyKey = this.isSiteToSiteSecure().booleanValue() ? (StringUtils.isBlank(this.getProperty(WEB_HTTPS_PORT_FORWARDING)) ? WEB_HTTPS_PORT : WEB_HTTPS_PORT_FORWARDING) : (StringUtils.isBlank(this.getProperty(WEB_HTTP_PORT_FORWARDING)) ? WEB_HTTP_PORT : WEB_HTTP_PORT_FORWARDING);
        Integer port = this.getIntegerProperty(propertyKey, null);
        if (port == null) {
            throw new RuntimeException("Remote input HTTP" + (this.isSiteToSiteSecure() != false ? "S" : "") + " is enabled but " + propertyKey + " is not specified.");
        }
        return port;
    }

    public Path getTemplateDirectory() {
        String strVal = this.getProperty(TEMPLATE_DIRECTORY);
        return strVal == null ? DEFAULT_TEMPLATE_DIRECTORY : Paths.get(strVal, new String[0]);
    }

    public String getFlowServiceWriteDelay() {
        return this.getProperty(WRITE_DELAY_INTERVAL);
    }

    public boolean getAutoResumeState() {
        String rawAutoResumeState = this.getProperty(AUTO_RESUME_STATE, DEFAULT_AUTO_RESUME_STATE.toString());
        return Boolean.parseBoolean(rawAutoResumeState);
    }

    public int getFlowFileRepositoryPartitions() {
        String rawProperty = this.getProperty(FLOWFILE_REPOSITORY_PARTITIONS, DEFAULT_FLOWFILE_REPO_PARTITIONS);
        return Integer.parseInt(rawProperty);
    }

    public String getFlowFileRepositoryCheckpointInterval() {
        return this.getProperty(FLOWFILE_REPOSITORY_CHECKPOINT_INTERVAL, DEFAULT_FLOWFILE_CHECKPOINT_INTERVAL);
    }

    public File getRestoreDirectory() {
        String value = this.getProperty(RESTORE_DIRECTORY);
        if (StringUtils.isBlank(value)) {
            return null;
        }
        return new File(value);
    }

    public File getAuthorizerConfigurationFile() {
        String value = this.getProperty(AUTHORIZER_CONFIGURATION_FILE);
        if (StringUtils.isBlank(value)) {
            return new File(DEFAULT_AUTHORIZER_CONFIGURATION_FILE);
        }
        return new File(value);
    }

    public File getLoginIdentityProviderConfigurationFile() {
        String value = this.getProperty(LOGIN_IDENTITY_PROVIDER_CONFIGURATION_FILE);
        if (StringUtils.isBlank(value)) {
            return new File(DEFAULT_LOGIN_IDENTITY_PROVIDER_CONFIGURATION_FILE);
        }
        return new File(value);
    }

    public Integer getPort() {
        Integer port = null;
        try {
            port = Integer.parseInt(this.getProperty(WEB_HTTP_PORT));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return port;
    }

    public Integer getSslPort() {
        Integer sslPort = null;
        try {
            sslPort = Integer.parseInt(this.getProperty(WEB_HTTPS_PORT));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return sslPort;
    }

    public boolean isHTTPSConfigured() {
        return this.getSslPort() != null;
    }

    public Integer getConfiguredHttpOrHttpsPort() throws RuntimeException {
        if (this.getSslPort() != null) {
            return this.getSslPort();
        }
        if (this.getPort() != null) {
            return this.getPort();
        }
        throw new RuntimeException("The HTTP or HTTPS port must be configured");
    }

    public String getWebMaxHeaderSize() {
        return this.getProperty(WEB_MAX_HEADER_SIZE, DEFAULT_WEB_MAX_HEADER_SIZE);
    }

    public int getWebThreads() {
        return this.getIntegerProperty(WEB_THREADS, 200);
    }

    public int getClusterNodeMaxConcurrentRequests() {
        return this.getIntegerProperty(CLUSTER_NODE_MAX_CONCURRENT_REQUESTS, 100);
    }

    public File getWebWorkingDirectory() {
        return new File(this.getProperty(WEB_WORKING_DIR, DEFAULT_WEB_WORKING_DIR));
    }

    public File getComponentDocumentationWorkingDirectory() {
        return new File(this.getProperty(COMPONENT_DOCS_DIRECTORY, DEFAULT_COMPONENT_DOCS_DIRECTORY));
    }

    public File getNarWorkingDirectory() {
        return new File(this.getProperty(NAR_WORKING_DIRECTORY, DEFAULT_NAR_WORKING_DIR));
    }

    public File getFrameworkWorkingDirectory() {
        return new File(this.getNarWorkingDirectory(), "framework");
    }

    public File getExtensionsWorkingDirectory() {
        return new File(this.getNarWorkingDirectory(), "extensions");
    }

    public List<Path> getNarLibraryDirectories() {
        ArrayList<Path> narLibraryPaths = new ArrayList<Path>();
        for (String propertyName : this.getPropertyKeys()) {
            String narLib;
            if (!StringUtils.startsWith(propertyName, NAR_LIBRARY_DIRECTORY_PREFIX) && !NAR_LIBRARY_DIRECTORY.equals(propertyName) && !NAR_LIBRARY_AUTOLOAD_DIRECTORY.equals(propertyName) || StringUtils.isBlank(narLib = this.getProperty(propertyName))) continue;
            narLibraryPaths.add(Paths.get(narLib, new String[0]));
        }
        if (narLibraryPaths.isEmpty()) {
            narLibraryPaths.add(Paths.get(DEFAULT_NAR_LIBRARY_DIR, new String[0]));
        }
        return narLibraryPaths;
    }

    public File getNarAutoLoadDirectory() {
        return new File(this.getProperty(NAR_LIBRARY_AUTOLOAD_DIRECTORY, DEFAULT_NAR_LIBRARY_AUTOLOAD_DIR));
    }

    public String getBannerText() {
        return this.getProperty(UI_BANNER_TEXT, "");
    }

    public String getAutoRefreshInterval() {
        return this.getProperty(UI_AUTO_REFRESH_INTERVAL);
    }

    public String getClusterProtocolHeartbeatInterval() {
        return this.getProperty(CLUSTER_PROTOCOL_HEARTBEAT_INTERVAL, "5 sec");
    }

    public String getNodeHeartbeatInterval() {
        return this.getClusterProtocolHeartbeatInterval();
    }

    public String getClusterNodeReadTimeout() {
        return this.getProperty(CLUSTER_NODE_READ_TIMEOUT, "5 sec");
    }

    public String getClusterNodeConnectionTimeout() {
        return this.getProperty(CLUSTER_NODE_CONNECTION_TIMEOUT, "5 sec");
    }

    public File getPersistentStateDirectory() {
        String dirName = this.getProperty(PERSISTENT_STATE_DIRECTORY, DEFAULT_PERSISTENT_STATE_DIRECTORY);
        File file = new File(dirName);
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    public boolean isNode() {
        return Boolean.parseBoolean(this.getProperty(CLUSTER_IS_NODE));
    }

    public InetSocketAddress getClusterNodeProtocolAddress() {
        try {
            String socketAddress = this.getProperty(CLUSTER_NODE_ADDRESS);
            if (StringUtils.isBlank(socketAddress)) {
                socketAddress = "localhost";
            }
            int socketPort = this.getClusterNodeProtocolPort();
            return InetSocketAddress.createUnresolved(socketAddress, socketPort);
        }
        catch (Exception ex) {
            throw new RuntimeException("Invalid node protocol address/port due to: " + ex, ex);
        }
    }

    public InetSocketAddress getClusterLoadBalanceAddress() {
        try {
            String address = this.getProperty(LOAD_BALANCE_ADDRESS);
            if (StringUtils.isBlank(address)) {
                address = this.getProperty(CLUSTER_NODE_ADDRESS);
            }
            if (StringUtils.isBlank(address)) {
                address = "localhost";
            }
            int port = this.getIntegerProperty(LOAD_BALANCE_PORT, 6342);
            return InetSocketAddress.createUnresolved(address, port);
        }
        catch (Exception e) {
            throw new RuntimeException("Invalid load balance address/port due to: " + e, e);
        }
    }

    public Integer getClusterNodeProtocolPort() {
        try {
            return Integer.parseInt(this.getProperty(CLUSTER_NODE_PROTOCOL_PORT));
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    @Deprecated
    public int getClusterNodeProtocolThreads() {
        return this.getClusterNodeProtocolCorePoolSize();
    }

    public int getClusterNodeProtocolCorePoolSize() {
        try {
            return Integer.parseInt(this.getProperty(CLUSTER_NODE_PROTOCOL_THREADS));
        }
        catch (NumberFormatException nfe) {
            return 10;
        }
    }

    public int getClusterNodeProtocolMaxPoolSize() {
        try {
            return Integer.parseInt(this.getProperty(CLUSTER_NODE_PROTOCOL_MAX_THREADS));
        }
        catch (NumberFormatException nfe) {
            return 50;
        }
    }

    public boolean isClustered() {
        return Boolean.parseBoolean(this.getProperty(CLUSTER_IS_NODE));
    }

    public File getClusterNodeFirewallFile() {
        String firewallFile = this.getProperty(CLUSTER_FIREWALL_FILE);
        if (StringUtils.isBlank(firewallFile)) {
            return null;
        }
        return new File(firewallFile);
    }

    public String getClusterProtocolManagerToNodeApiScheme() {
        String isSecureProperty = this.getProperty(CLUSTER_PROTOCOL_IS_SECURE);
        if (Boolean.valueOf(isSecureProperty).booleanValue()) {
            return "https";
        }
        return "http";
    }

    public File getKerberosConfigurationFile() {
        String krb5File = this.getProperty(KERBEROS_KRB5_FILE);
        if (krb5File != null && krb5File.trim().length() > 0) {
            return new File(krb5File.trim());
        }
        return null;
    }

    public String getKerberosServicePrincipal() {
        String servicePrincipal = this.getProperty(KERBEROS_SERVICE_PRINCIPAL);
        if (!StringUtils.isBlank(servicePrincipal)) {
            return servicePrincipal.trim();
        }
        return null;
    }

    public String getKerberosServiceKeytabLocation() {
        String keytabLocation = this.getProperty(KERBEROS_SERVICE_KEYTAB_LOCATION);
        if (!StringUtils.isBlank(keytabLocation)) {
            return keytabLocation.trim();
        }
        return null;
    }

    public String getKerberosSpnegoPrincipal() {
        String spengoPrincipal = this.getProperty(KERBEROS_SPNEGO_PRINCIPAL);
        if (!StringUtils.isBlank(spengoPrincipal)) {
            return spengoPrincipal.trim();
        }
        return null;
    }

    public String getKerberosSpnegoKeytabLocation() {
        String keytabLocation = this.getProperty(KERBEROS_SPNEGO_KEYTAB_LOCATION);
        if (!StringUtils.isBlank(keytabLocation)) {
            return keytabLocation.trim();
        }
        return null;
    }

    public String getKerberosAuthenticationExpiration() {
        String authenticationExpirationString = this.getProperty(KERBEROS_AUTHENTICATION_EXPIRATION, DEFAULT_KERBEROS_AUTHENTICATION_EXPIRATION);
        if (!StringUtils.isBlank(authenticationExpirationString)) {
            return authenticationExpirationString.trim();
        }
        return null;
    }

    public boolean isKerberosSpnegoSupportEnabled() {
        return !StringUtils.isBlank(this.getKerberosSpnegoPrincipal()) && !StringUtils.isBlank(this.getKerberosSpnegoKeytabLocation());
    }

    public boolean isLoginIdentityProviderEnabled() {
        return !StringUtils.isBlank(this.getProperty(SECURITY_USER_LOGIN_IDENTITY_PROVIDER));
    }

    public boolean isOidcEnabled() {
        return !StringUtils.isBlank(this.getOidcDiscoveryUrl());
    }

    public String getOidcDiscoveryUrl() {
        return this.getProperty(SECURITY_USER_OIDC_DISCOVERY_URL);
    }

    public String getOidcConnectTimeout() {
        return this.getProperty(SECURITY_USER_OIDC_CONNECT_TIMEOUT, "5 secs");
    }

    public String getOidcReadTimeout() {
        return this.getProperty(SECURITY_USER_OIDC_READ_TIMEOUT, "5 secs");
    }

    public String getOidcClientId() {
        return this.getProperty(SECURITY_USER_OIDC_CLIENT_ID);
    }

    public String getOidcClientSecret() {
        return this.getProperty(SECURITY_USER_OIDC_CLIENT_SECRET);
    }

    public String getOidcPreferredJwsAlgorithm() {
        return this.getProperty(SECURITY_USER_OIDC_PREFERRED_JWSALGORITHM);
    }

    public boolean isKnoxSsoEnabled() {
        return !StringUtils.isBlank(this.getKnoxUrl());
    }

    public String getKnoxUrl() {
        return this.getProperty(SECURITY_USER_KNOX_URL);
    }

    public Set<String> getKnoxAudiences() {
        String rawAudiences = this.getProperty(SECURITY_USER_KNOX_AUDIENCES);
        if (StringUtils.isBlank(rawAudiences)) {
            return null;
        }
        String[] audienceTokens = rawAudiences.split(",");
        return Stream.of(audienceTokens).map(String::trim).filter(aud -> !StringUtils.isEmpty(aud)).collect(Collectors.toSet());
    }

    public Path getKnoxPublicKeyPath() {
        return Paths.get(this.getProperty(SECURITY_USER_KNOX_PUBLIC_KEY), new String[0]);
    }

    public String getKnoxCookieName() {
        return this.getProperty(SECURITY_USER_KNOX_COOKIE_NAME);
    }

    public boolean isClientAuthRequiredForRestApi() {
        return !this.isLoginIdentityProviderEnabled() && !this.isKerberosSpnegoSupportEnabled() && !this.isOidcEnabled() && !this.isKnoxSsoEnabled();
    }

    public InetSocketAddress getNodeApiAddress() {
        Integer port;
        String host;
        String scheme;
        String rawScheme = this.getClusterProtocolManagerToNodeApiScheme();
        String string = scheme = rawScheme == null ? "http" : rawScheme;
        if ("http".equalsIgnoreCase(scheme)) {
            host = StringUtils.isBlank(this.getProperty(WEB_HTTP_HOST)) ? "localhost" : this.getProperty(WEB_HTTP_HOST);
            port = this.getPort();
            if (port == null) {
                throw new RuntimeException(String.format("The %s must be specified if running in a cluster with %s set to false.", WEB_HTTP_PORT, CLUSTER_PROTOCOL_IS_SECURE));
            }
        } else {
            host = StringUtils.isBlank(this.getProperty(WEB_HTTPS_HOST)) ? "localhost" : this.getProperty(WEB_HTTPS_HOST);
            port = this.getSslPort();
            if (port == null) {
                throw new RuntimeException(String.format("The %s must be specified if running in a cluster with %s set to true.", WEB_HTTPS_PORT, CLUSTER_PROTOCOL_IS_SECURE));
            }
        }
        return InetSocketAddress.createUnresolved(host, port);
    }

    public Path getDatabaseRepositoryPath() {
        return Paths.get(this.getProperty(REPOSITORY_DATABASE_DIRECTORY), new String[0]);
    }

    public Path getFlowFileRepositoryPath() {
        return Paths.get(this.getProperty(FLOWFILE_REPOSITORY_DIRECTORY), new String[0]);
    }

    public Map<String, Path> getContentRepositoryPaths() {
        HashMap<String, Path> contentRepositoryPaths = new HashMap<String, Path>();
        for (String propertyName : this.getPropertyKeys()) {
            if (!StringUtils.startsWith(propertyName, REPOSITORY_CONTENT_PREFIX)) continue;
            String key = StringUtils.substringAfter(propertyName, REPOSITORY_CONTENT_PREFIX);
            contentRepositoryPaths.put(key, Paths.get(this.getProperty(propertyName), new String[0]));
        }
        return contentRepositoryPaths;
    }

    public Map<String, Path> getProvenanceRepositoryPaths() {
        HashMap<String, Path> provenanceRepositoryPaths = new HashMap<String, Path>();
        for (String propertyName : this.getPropertyKeys()) {
            if (!StringUtils.startsWith(propertyName, PROVENANCE_REPO_DIRECTORY_PREFIX)) continue;
            String key = StringUtils.substringAfter(propertyName, PROVENANCE_REPO_DIRECTORY_PREFIX);
            provenanceRepositoryPaths.put(key, Paths.get(this.getProperty(propertyName), new String[0]));
        }
        return provenanceRepositoryPaths;
    }

    public int getMaxFlowFilesPerClaim() {
        try {
            return Integer.parseInt(this.getProperty(MAX_FLOWFILES_PER_CLAIM));
        }
        catch (NumberFormatException nfe) {
            return 100;
        }
    }

    public String getMaxAppendableClaimSize() {
        return this.getProperty(MAX_APPENDABLE_CLAIM_SIZE, DEFAULT_MAX_APPENDABLE_CLAIM_SIZE);
    }

    public String getProperty(String key, String defaultValue) {
        String value = this.getProperty(key);
        return value == null || value.trim().isEmpty() ? defaultValue : value;
    }

    public String getBoredYieldDuration() {
        return this.getProperty(BORED_YIELD_DURATION, DEFAULT_BORED_YIELD_DURATION);
    }

    public File getStateManagementConfigFile() {
        return new File(this.getProperty(STATE_MANAGEMENT_CONFIG_FILE, DEFAULT_STATE_MANAGEMENT_CONFIG_FILE));
    }

    public String getLocalStateProviderId() {
        return this.getProperty(STATE_MANAGEMENT_LOCAL_PROVIDER_ID);
    }

    public String getClusterStateProviderId() {
        return this.getProperty(STATE_MANAGEMENT_CLUSTER_PROVIDER_ID);
    }

    public File getEmbeddedZooKeeperPropertiesFile() {
        String filename = this.getProperty(STATE_MANAGEMENT_ZOOKEEPER_PROPERTIES);
        return filename == null ? null : new File(filename);
    }

    public boolean isStartEmbeddedZooKeeper() {
        return Boolean.parseBoolean(this.getProperty(STATE_MANAGEMENT_START_EMBEDDED_ZOOKEEPER));
    }

    public boolean isFlowConfigurationArchiveEnabled() {
        return Boolean.parseBoolean(this.getProperty(FLOW_CONFIGURATION_ARCHIVE_ENABLED, "true"));
    }

    public String getFlowConfigurationArchiveDir() {
        return this.getProperty(FLOW_CONFIGURATION_ARCHIVE_DIR);
    }

    public String getFlowElectionMaxWaitTime() {
        return this.getProperty(FLOW_ELECTION_MAX_WAIT_TIME, "5 mins");
    }

    public Integer getFlowElectionMaxCandidates() {
        return this.getIntegerProperty(FLOW_ELECTION_MAX_CANDIDATES, null);
    }

    public String getFlowConfigurationArchiveMaxTime() {
        return this.getProperty(FLOW_CONFIGURATION_ARCHIVE_MAX_TIME, null);
    }

    public String getFlowConfigurationArchiveMaxStorage() {
        return this.getProperty(FLOW_CONFIGURATION_ARCHIVE_MAX_STORAGE, null);
    }

    public Integer getFlowConfigurationArchiveMaxCount() {
        return this.getIntegerProperty(FLOW_CONFIGURATION_ARCHIVE_MAX_COUNT, null);
    }

    public String getVariableRegistryProperties() {
        return this.getProperty(VARIABLE_REGISTRY_PROPERTIES);
    }

    public Path[] getVariableRegistryPropertiesPaths() {
        ArrayList<Path> vrPropertiesPaths = new ArrayList<Path>();
        String vrPropertiesFiles = this.getVariableRegistryProperties();
        if (!StringUtils.isEmpty(vrPropertiesFiles)) {
            List<String> vrPropertiesFileList = Arrays.asList(vrPropertiesFiles.split(","));
            for (String propertiesFile : vrPropertiesFileList) {
                vrPropertiesPaths.add(Paths.get(propertiesFile, new String[0]));
            }
            return vrPropertiesPaths.toArray(new Path[vrPropertiesPaths.size()]);
        }
        return new Path[0];
    }

    public Map<String, String> getHttpNetworkInterfaces() {
        HashMap<String, String> networkInterfaces = new HashMap<String, String>();
        for (String propertyName : this.getPropertyKeys()) {
            if (!StringUtils.startsWith(propertyName, WEB_HTTP_NETWORK_INTERFACE_PREFIX)) continue;
            String key = StringUtils.substringAfter(propertyName, WEB_HTTP_NETWORK_INTERFACE_PREFIX);
            networkInterfaces.put(key, this.getProperty(propertyName));
        }
        return networkInterfaces;
    }

    public Map<String, String> getHttpsNetworkInterfaces() {
        HashMap<String, String> networkInterfaces = new HashMap<String, String>();
        for (String propertyName : this.getPropertyKeys()) {
            if (!StringUtils.startsWith(propertyName, WEB_HTTPS_NETWORK_INTERFACE_PREFIX)) continue;
            String key = StringUtils.substringAfter(propertyName, WEB_HTTPS_NETWORK_INTERFACE_PREFIX);
            networkInterfaces.put(key, this.getProperty(propertyName));
        }
        return networkInterfaces;
    }

    public int size() {
        return this.getPropertyKeys().size();
    }

    public String getProvenanceRepoEncryptionKeyId() {
        return this.getProperty(PROVENANCE_REPO_ENCRYPTION_KEY_ID);
    }

    public String getProvenanceRepoEncryptionKey() {
        String keyId = this.getProvenanceRepoEncryptionKeyId();
        String keyKey = StringUtils.isBlank(keyId) ? PROVENANCE_REPO_ENCRYPTION_KEY : "nifi.provenance.repository.encryption.key.id." + keyId;
        return this.getProperty(keyKey, this.getProperty(PROVENANCE_REPO_ENCRYPTION_KEY));
    }

    public Map<String, String> getProvenanceRepoEncryptionKeys() {
        HashMap<String, String> keys = new HashMap<String, String>();
        List<String> keyProperties = this.getProvenanceRepositoryEncryptionKeyProperties();
        for (String prop : keyProperties) {
            String value = this.getProperty(prop);
            if (StringUtils.isBlank(value)) continue;
            prop = prop.equalsIgnoreCase(PROVENANCE_REPO_ENCRYPTION_KEY) ? this.getProvenanceRepoEncryptionKeyId() : prop.substring(prop.lastIndexOf(".") + 1);
            keys.put(prop, value);
        }
        return keys;
    }

    public String getWhitelistedHosts() {
        return StringUtils.join(this.getWhitelistedHostsAsList(), ",");
    }

    public List<String> getWhitelistedHostsAsList() {
        String rawProperty = this.getProperty(WEB_PROXY_HOST, "");
        List<String> hosts = Arrays.asList(rawProperty.split(","));
        return hosts.stream().map(this::normalizeHost).filter(host -> !StringUtils.isBlank(host)).collect(Collectors.toList());
    }

    String normalizeHost(String host) {
        if (host == null || host.equalsIgnoreCase("")) {
            return "";
        }
        return host.trim();
    }

    public String getWhitelistedContextPaths() {
        return StringUtils.join(this.getWhitelistedContextPathsAsList(), ",");
    }

    public List<String> getWhitelistedContextPathsAsList() {
        String rawProperty = this.getProperty(WEB_PROXY_CONTEXT_PATH, "");
        List<String> contextPaths = Arrays.asList(rawProperty.split(","));
        return contextPaths.stream().map(this::normalizeContextPath).collect(Collectors.toList());
    }

    private String normalizeContextPath(String cp) {
        if (cp == null || cp.equalsIgnoreCase("")) {
            return "";
        }
        String trimmedCP = cp.trim();
        trimmedCP = trimmedCP.startsWith("/") ? trimmedCP : "/" + trimmedCP;
        trimmedCP = trimmedCP.endsWith("/") ? trimmedCP.substring(0, trimmedCP.length() - 1) : trimmedCP;
        return trimmedCP;
    }

    private List<String> getProvenanceRepositoryEncryptionKeyProperties() {
        return this.getPropertyKeys().stream().filter(k -> k.startsWith("nifi.provenance.repository.encryption.key.id.") || k.equalsIgnoreCase(PROVENANCE_REPO_ENCRYPTION_KEY)).collect(Collectors.toList());
    }

    public Long getDefaultBackPressureObjectThreshold() {
        long backPressureCount;
        try {
            String backPressureCountStr = this.getProperty(BACKPRESSURE_COUNT);
            backPressureCount = backPressureCountStr == null || backPressureCountStr.trim().isEmpty() ? 10000L : Long.parseLong(backPressureCountStr);
        }
        catch (NumberFormatException nfe) {
            backPressureCount = 10000L;
        }
        return backPressureCount;
    }

    public String getDefaultBackPressureDataSizeThreshold() {
        return this.getProperty(BACKPRESSURE_SIZE, DEFAULT_BACKPRESSURE_SIZE);
    }

    public static NiFiProperties createBasicNiFiProperties(String propertiesFilePath, Map<String, String> additionalProperties) {
        String nfPropertiesFilePath;
        Map<String, String> addProps = additionalProperties == null ? Collections.EMPTY_MAP : additionalProperties;
        final Properties properties = new Properties();
        String string = nfPropertiesFilePath = propertiesFilePath == null ? System.getProperty(PROPERTIES_FILE_PATH) : propertiesFilePath;
        if (nfPropertiesFilePath != null) {
            File propertiesFile = new File(nfPropertiesFilePath.trim());
            if (!propertiesFile.exists()) {
                throw new RuntimeException("Properties file doesn't exist '" + propertiesFile.getAbsolutePath() + "'");
            }
            if (!propertiesFile.canRead()) {
                throw new RuntimeException("Properties file exists but cannot be read '" + propertiesFile.getAbsolutePath() + "'");
            }
            BufferedInputStream inStream = null;
            try {
                inStream = new BufferedInputStream(new FileInputStream(propertiesFile));
                properties.load(inStream);
            }
            catch (Exception ex) {
                throw new RuntimeException("Cannot load properties file due to " + ex.getLocalizedMessage(), ex);
            }
            finally {
                if (null != inStream) {
                    try {
                        ((InputStream)inStream).close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        addProps.entrySet().stream().forEach(entry -> properties.setProperty((String)entry.getKey(), (String)entry.getValue()));
        return new NiFiProperties(){

            @Override
            public String getProperty(String key) {
                return properties.getProperty(key);
            }

            @Override
            public Set<String> getPropertyKeys() {
                return properties.stringPropertyNames();
            }
        };
    }

    public void validate() {
        String remoteInputHost = this.getProperty(REMOTE_INPUT_HOST);
        if (!StringUtils.isBlank(remoteInputHost) && remoteInputHost.split(":").length > 1) {
            throw new IllegalArgumentException(remoteInputHost + " is not a correct value for " + REMOTE_INPUT_HOST + ". It should be a valid hostname without protocol or port.");
        }
    }
}

