/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processor.util.pattern;

import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessSessionFactory;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processor.util.pattern.DiscontinuedException;
import org.apache.nifi.processor.util.pattern.ErrorTypes;
import org.apache.nifi.processor.util.pattern.ExceptionHandler;
import org.apache.nifi.processor.util.pattern.PartialFunctions;

public class RollbackOnFailure {
    private final boolean rollbackOnFailure;
    private final boolean transactional;
    private boolean discontinue;
    private int processedCount = 0;
    public static final PropertyDescriptor ROLLBACK_ON_FAILURE = RollbackOnFailure.createRollbackOnFailureProperty("");

    public RollbackOnFailure(boolean rollbackOnFailure, boolean transactional) {
        this.rollbackOnFailure = rollbackOnFailure;
        this.transactional = transactional;
    }

    public static PropertyDescriptor createRollbackOnFailureProperty(String additionalDescription) {
        return new PropertyDescriptor.Builder().name("rollback-on-failure").displayName("Rollback On Failure").description("Specify how to handle error. By default (false), if an error occurs while processing a FlowFile, the FlowFile will be routed to 'failure' or 'retry' relationship based on error type, and processor can continue with next FlowFile. Instead, you may want to rollback currently processed FlowFiles and stop further processing immediately. In that case, you can do so by enabling this 'Rollback On Failure' property.  If enabled, failed FlowFiles will stay in the input relationship without penalizing it and being processed repeatedly until it gets processed successfully or removed by other means. It is important to set adequate 'Yield Duration' to avoid retrying too frequently." + additionalDescription).allowableValues(new String[]{"true", "false"}).addValidator(StandardValidators.BOOLEAN_VALIDATOR).defaultValue("false").required(true).build();
    }

    public static <FCT extends RollbackOnFailure> BiFunction<FCT, ErrorTypes, ErrorTypes.Result> createAdjustError(ComponentLog logger) {
        return (c, t) -> {
            ErrorTypes.Result adjusted = null;
            switch (t.destination()) {
                case ProcessException: {
                    if (c.canRollback()) break;
                    c.discontinue();
                    adjusted = new ErrorTypes.Result(ErrorTypes.Destination.Self, ErrorTypes.Penalty.Yield);
                    break;
                }
                case Failure: 
                case Retry: {
                    if (!c.isRollbackOnFailure()) break;
                    c.discontinue();
                    adjusted = c.canRollback() ? new ErrorTypes.Result(ErrorTypes.Destination.ProcessException, ErrorTypes.Penalty.Yield) : new ErrorTypes.Result(ErrorTypes.Destination.Self, ErrorTypes.Penalty.Yield);
                }
            }
            if (adjusted != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Adjusted {} to {} based on context rollbackOnFailure={}, processedCount={}, transactional={}", new Object[]{t, adjusted, c.isRollbackOnFailure(), c.getProcessedCount(), c.isTransactional()});
                }
                return adjusted;
            }
            return t.result();
        };
    }

    public static <FCT extends RollbackOnFailure> PartialFunctions.AdjustRoute<FCT> createAdjustRoute(Relationship ... failureRelationships) {
        return (context, session, fc, result) -> {
            if (fc.isRollbackOnFailure()) {
                for (Relationship failureRelationship : failureRelationships) {
                    if (!result.contains(failureRelationship)) continue;
                    if (fc.canRollback()) {
                        throw new ProcessException(String.format("A FlowFile is routed to %s. Rollback session based on context rollbackOnFailure=%s, processedCount=%d, transactional=%s", failureRelationship.getName(), fc.isRollbackOnFailure(), fc.getProcessedCount(), fc.isTransactional()));
                    }
                    Map<Relationship, List<FlowFile>> routedFlowFiles = result.getRoutedFlowFiles();
                    List<FlowFile> failedFlowFiles = routedFlowFiles.remove(failureRelationship);
                    result.routeTo(failedFlowFiles, Relationship.SELF);
                }
            }
        };
    }

    public static <FCT extends RollbackOnFailure, I> ExceptionHandler.OnError<FCT, I> createOnError(ExceptionHandler.OnError<FCT, I> onError) {
        return onError.andThen((context, input, result, e) -> {
            if (context.shouldDiscontinue()) {
                throw new DiscontinuedException("Discontinue processing due to " + e, e);
            }
        });
    }

    public static <FCT extends RollbackOnFailure> void onTrigger(ProcessContext context, ProcessSessionFactory sessionFactory, FCT functionContext, ComponentLog logger, PartialFunctions.OnTrigger onTrigger) throws ProcessException {
        PartialFunctions.onTrigger(context, sessionFactory, logger, onTrigger, (ProcessSession session, Throwable t) -> {
            boolean shouldPenalize = !functionContext.isRollbackOnFailure();
            session.rollback(shouldPenalize);
            if (functionContext.isRollbackOnFailure()) {
                logger.warn("Administratively yielding {} after rolling back due to {}", new Object[]{context.getName(), t, t});
                context.yield();
            }
        });
    }

    public int proceed() {
        return ++this.processedCount;
    }

    public int getProcessedCount() {
        return this.processedCount;
    }

    public boolean isRollbackOnFailure() {
        return this.rollbackOnFailure;
    }

    public boolean isTransactional() {
        return this.transactional;
    }

    public boolean canRollback() {
        return this.transactional || this.processedCount == 0;
    }

    public boolean shouldDiscontinue() {
        return this.discontinue;
    }

    public void discontinue() {
        this.discontinue = true;
    }
}

