/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.krb;

import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.commons.lang3.Validate;
import org.apache.nifi.security.krb.AbstractKerberosUser;
import org.apache.nifi.security.krb.PasswordConfiguration;
import org.apache.nifi.security.krb.UsernamePasswordCallbackHandler;

public class KerberosPasswordUser
extends AbstractKerberosUser {
    private final String password;

    public KerberosPasswordUser(String principal, String password) {
        super(principal);
        this.password = password;
        Validate.notBlank((CharSequence)this.password);
    }

    @Override
    protected LoginContext createLoginContext(Subject subject) throws LoginException {
        PasswordConfiguration configuration = new PasswordConfiguration();
        UsernamePasswordCallbackHandler callbackHandler = new UsernamePasswordCallbackHandler(this.principal, this.password);
        return new LoginContext("PasswordConf", subject, callbackHandler, configuration);
    }
}

