/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.xml;

import java.io.InputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stream.StreamSource;

public class XmlUtils {
    public static XMLStreamReader createSafeReader(InputStream inputStream) throws XMLStreamException {
        if (inputStream == null) {
            throw new IllegalArgumentException("The provided input stream cannot be null");
        }
        return XmlUtils.createSafeReader(new StreamSource(inputStream));
    }

    public static XMLStreamReader createSafeReader(StreamSource source) throws XMLStreamException {
        if (source == null) {
            throw new IllegalArgumentException("The provided source cannot be null");
        }
        XMLInputFactory xif = XMLInputFactory.newFactory();
        xif.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        xif.setProperty("javax.xml.stream.supportDTD", false);
        return xif.createXMLStreamReader(source);
    }
}

