/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.krb;

import java.util.HashMap;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.apache.commons.lang3.StringUtils;

public class KeytabConfiguration
extends Configuration {
    static final boolean IS_IBM = System.getProperty("java.vendor", "").contains("IBM");
    static final String IBM_KRB5_LOGIN_MODULE = "com.ibm.security.auth.module.Krb5LoginModule";
    static final String SUN_KRB5_LOGIN_MODULE = "com.sun.security.auth.module.Krb5LoginModule";
    private final String principal;
    private final String keytabFile;
    private final AppConfigurationEntry kerberosKeytabConfigEntry;

    public KeytabConfiguration(String principal, String keytabFile) {
        if (StringUtils.isBlank((CharSequence)principal)) {
            throw new IllegalArgumentException("Principal cannot be null");
        }
        if (StringUtils.isBlank((CharSequence)keytabFile)) {
            throw new IllegalArgumentException("Keytab file cannot be null");
        }
        this.principal = principal;
        this.keytabFile = keytabFile;
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("principal", principal);
        options.put("refreshKrb5Config", "true");
        if (IS_IBM) {
            options.put("useKeytab", keytabFile);
            options.put("credsType", "both");
        } else {
            options.put("keyTab", keytabFile);
            options.put("useKeyTab", "true");
            options.put("isInitiator", "true");
            options.put("doNotPrompt", "true");
            options.put("storeKey", "true");
        }
        String krbLoginModuleName = IS_IBM ? IBM_KRB5_LOGIN_MODULE : SUN_KRB5_LOGIN_MODULE;
        this.kerberosKeytabConfigEntry = new AppConfigurationEntry(krbLoginModuleName, AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options);
    }

    @Override
    public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
        return new AppConfigurationEntry[]{this.kerberosKeytabConfigEntry};
    }

    public String getPrincipal() {
        return this.principal;
    }

    public String getKeytabFile() {
        return this.keytabFile;
    }
}

