/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.framework.security.util;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import org.apache.nifi.framework.security.util.SslContextFactory;
import org.apache.nifi.framework.security.util.SslServerSocketFactoryCreationException;
import org.apache.nifi.util.NiFiProperties;

public class SslServerSocketFactory
extends SSLServerSocketFactory {
    private SSLServerSocketFactory sslServerSocketFactory;

    public SslServerSocketFactory() {
        SSLContext sslCtx = SslContextFactory.createSslContext(NiFiProperties.getInstance());
        if (sslCtx == null) {
            try {
                this.sslServerSocketFactory = SSLContext.getDefault().getServerSocketFactory();
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new SslServerSocketFactoryCreationException(nsae);
            }
        } else {
            this.sslServerSocketFactory = sslCtx.getServerSocketFactory();
        }
    }

    @Override
    public ServerSocket createServerSocket(int i, int i1, InetAddress ia) throws IOException {
        return this.sslServerSocketFactory.createServerSocket(i, i1, ia);
    }

    @Override
    public ServerSocket createServerSocket(int i, int i1) throws IOException {
        return this.sslServerSocketFactory.createServerSocket(i, i1);
    }

    @Override
    public ServerSocket createServerSocket(int i) throws IOException {
        return this.sslServerSocketFactory.createServerSocket(i);
    }

    @Override
    public ServerSocket createServerSocket() throws IOException {
        return this.sslServerSocketFactory.createServerSocket();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.sslServerSocketFactory.getSupportedCipherSuites();
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.sslServerSocketFactory.getDefaultCipherSuites();
    }
}

