/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.service.lookup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.nifi.annotation.lifecycle.OnDisabled;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;

public abstract class AbstractSingleAttributeBasedControllerServiceLookup<S extends ControllerService>
extends AbstractControllerService {
    protected volatile Map<String, S> serviceMap;

    public abstract Class<S> getServiceType();

    protected abstract String getLookupAttribute();

    public S lookupService(Map<String, String> attributes) {
        if (attributes == null) {
            throw new ProcessException("Attributes map is null");
        }
        if (!attributes.containsKey(this.getLookupAttribute())) {
            throw new ProcessException("Attributes must contain an attribute name '" + this.getLookupAttribute() + "'");
        }
        String lookupKey = Optional.of(this.getLookupAttribute()).map(attributes::get).orElseThrow(() -> new ProcessException(this.getLookupAttribute() + " cannot be null or blank"));
        ControllerService service = (ControllerService)this.serviceMap.get(lookupKey);
        if (service == null) {
            throw new ProcessException("No " + this.getServiceName() + " found for " + this.getLookupAttribute());
        }
        return (S)service;
    }

    @OnEnabled
    public void onEnabled(ConfigurationContext context) {
        HashMap serviceMap = new HashMap();
        context.getProperties().keySet().stream().filter(PropertyDescriptor::isDynamic).forEach(propertyDescriptor -> {
            ControllerService service = context.getProperty(propertyDescriptor).asControllerService(this.getServiceType());
            serviceMap.put(propertyDescriptor.getName(), service);
        });
        this.serviceMap = Collections.unmodifiableMap(serviceMap);
    }

    @OnDisabled
    public void onDisabled() {
        this.serviceMap = null;
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return this.lookupKeyPropertyDescriptor(propertyDescriptorName);
    }

    protected Collection<ValidationResult> customValidate(ValidationContext context) {
        return this.validateForAtLeastOneService(context);
    }

    protected PropertyDescriptor lookupKeyPropertyDescriptor(String propertyDescriptorName) {
        return new PropertyDescriptor.Builder().name(propertyDescriptorName).description("The " + this.getServiceName() + " to return when " + this.getLookupAttribute() + " = '" + propertyDescriptorName + "'").identifiesControllerService(this.getServiceType()).addValidator(StandardValidators.NON_BLANK_VALIDATOR).build();
    }

    private Collection<ValidationResult> validateForAtLeastOneService(ValidationContext context) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        int numDefinedServices = 0;
        for (PropertyDescriptor descriptor : context.getProperties().keySet()) {
            if (descriptor.isDynamic()) {
                ++numDefinedServices;
            }
            String referencedId = context.getProperty(descriptor).getValue();
            if (!this.getIdentifier().equals(referencedId)) continue;
            --numDefinedServices;
            results.add(new ValidationResult.Builder().subject(descriptor.getDisplayName()).explanation("the current service cannot be registered as a " + this.getServiceName() + " to lookup").valid(false).build());
        }
        if (numDefinedServices == 0) {
            results.add(new ValidationResult.Builder().subject(((Object)((Object)this)).getClass().getSimpleName()).explanation("at least one " + this.getServiceName() + " must be defined via dynamic properties").valid(false).build());
        }
        return results;
    }

    protected String getServiceName() {
        return this.getServiceType().getSimpleName();
    }
}

