/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.BufferOverflowException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.text.StringSubstitutor;
import org.apache.nifi.annotation.behavior.DefaultRunDuration;
import org.apache.nifi.annotation.behavior.EventDriven;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SideEffectFree;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.SystemResource;
import org.apache.nifi.annotation.behavior.SystemResourceConsideration;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.attribute.expression.language.exception.AttributeExpressionLanguageException;
import org.apache.nifi.attribute.expression.language.exception.IllegalAttributeException;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.expression.AttributeValueDecorator;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.DataUnit;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessorInitializationContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.io.StreamCallback;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.stream.io.StreamUtils;
import org.apache.nifi.stream.io.util.LineDemarcator;
import org.apache.nifi.util.StopWatch;

@EventDriven
@SideEffectFree
@SupportsBatching(defaultDuration=DefaultRunDuration.TWENTY_FIVE_MILLIS)
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"Text", "Regular Expression", "Update", "Change", "Replace", "Modify", "Regex"})
@CapabilityDescription(value="Updates the content of a FlowFile by searching for some textual value in the FlowFile content (via Regular Expression/regex, or literal value) and replacing the section of the content that matches with some alternate value. It can also be used to append or prepend text to the contents of a FlowFile.")
@SystemResourceConsideration(resource=SystemResource.MEMORY)
public class ReplaceText
extends AbstractProcessor {
    private static Pattern REPLACEMENT_NORMALIZATION_PATTERN = Pattern.compile("(\\$\\D)");
    public static final String LINE_BY_LINE = "Line-by-Line";
    public static final String ALL = "All";
    public static final String FIRST_LINE = "First-Line";
    public static final String EXCEPT_FIRST_LINE = "Except-First-Line";
    public static final String LAST_LINE = "Last-Line";
    public static final String EXCEPT_LAST_LINE = "Except-Last-Line";
    public static final String ENTIRE_TEXT = "Entire text";
    public static final String prependValue = "Prepend";
    public static final String appendValue = "Append";
    public static final String surroundValue = "Surround";
    public static final String regexReplaceValue = "Regex Replace";
    public static final String literalReplaceValue = "Literal Replace";
    public static final String alwaysReplace = "Always Replace";
    public static final String SUBSTITUTE_VARIABLES_VALUE = "Substitute Variables";
    private static final Pattern unescapedBackReferencePattern = Pattern.compile("[^\\\\]\\$(\\d+)");
    private static final String DEFAULT_REGEX = "(?s)(^.*$)";
    private static final String DEFAULT_REPLACEMENT_VALUE = "$1";
    static final AllowableValue PREPEND = new AllowableValue("Prepend", "Prepend", "Insert the Replacement Value at the beginning of the FlowFile or the beginning of each line (depending on the Evaluation Mode). For \"Line-by-Line\" Evaluation Mode, the value will be prepended to each line. Similarly, for \"First-Line\", \"Last-Line\", \"Except-Last-Line\" and \"Except-First-Line\" Evaluation Modes,the value will be prepended to header alone, footer alone, all lines except header and all lines except footer respectively. For \"Entire Text\" evaluation mode,the value will be prepended to the entire text.");
    static final AllowableValue APPEND = new AllowableValue("Append", "Append", "Insert the Replacement Value at the end of the FlowFile or the end of each line (depending on the Evaluation Mode). For \"Line-by-Line\" Evaluation Mode, the value will be appended to each line. Similarly, for \"First-Line\", \"Last-Line\", \"Except-Last-Line\" and \"Except-First-Line\" Evaluation Modes,the value will be appended to header alone, footer alone, all lines except header and all lines except footer respectively. For \"Entire Text\" evaluation mode,the value will be appended to the entire text.");
    static final AllowableValue SURROUND = new AllowableValue("Surround", "Surround", "Prepends text before the start of the FlowFile (or the start of each line, depending on the configuration of the Evaluation Mode property) as well as appending text to the end of the FlowFile (or the end of each line, depending on the configuration of the Evaluation Mode property)");
    static final AllowableValue LITERAL_REPLACE = new AllowableValue("Literal Replace", "Literal Replace", "Search for all instances of the Search Value and replace the matches with the Replacement Value.");
    static final AllowableValue REGEX_REPLACE = new AllowableValue("Regex Replace", "Regex Replace", "Interpret the Search Value as a Regular Expression and replace all matches with the Replacement Value. The Replacement Value may reference Capturing Groups used in the Search Value by using a dollar-sign followed by the Capturing Group number, such as $1 or $2. If the Search Value is set to .* then everything is replaced without even evaluating the Regular Expression.");
    static final AllowableValue ALWAYS_REPLACE = new AllowableValue("Always Replace", "Always Replace", "Always replaces the entire line or the entire contents of the FlowFile (depending on the value of the <Evaluation Mode> property) and does not bother searching for any value. When this strategy is chosen, the <Search Value> property is ignored.");
    static final AllowableValue SUBSTITUTE_VARIABLES = new AllowableValue("Substitute Variables", "Substitute Variables", "Substitute variable references (specified in ${var} form) using FlowFile attributes for looking up the replacement value by variable name. When this strategy is chosen, both the <Search Value> and <Replacement Value> properties are ignored.");
    public static final PropertyDescriptor REPLACEMENT_STRATEGY = new PropertyDescriptor.Builder().name("Replacement Strategy").description("The strategy for how and what to replace within the FlowFile's text content.").allowableValues(new AllowableValue[]{PREPEND, APPEND, SURROUND, REGEX_REPLACE, LITERAL_REPLACE, ALWAYS_REPLACE, SUBSTITUTE_VARIABLES}).defaultValue(REGEX_REPLACE.getValue()).required(true).build();
    public static final PropertyDescriptor SEARCH_VALUE = new PropertyDescriptor.Builder().name("Regular Expression").displayName("Search Value").description("The Search Value to search for in the FlowFile content. Only used for 'Literal Replace' and 'Regex Replace' matching strategies").required(true).addValidator(Validator.VALID).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).dependsOn(REPLACEMENT_STRATEGY, new AllowableValue[]{REGEX_REPLACE, LITERAL_REPLACE}).defaultValue("(?s)(^.*$)").build();
    public static final PropertyDescriptor REPLACEMENT_VALUE = new PropertyDescriptor.Builder().name("Replacement Value").description("The value to insert using the 'Replacement Strategy'. Using \"Regex Replace\" back-references to Regular Expression capturing groups are supported, but back-references that reference capturing groups that do not exist in the regular expression will be treated as literal value. Back References may also be referenced using the Expression Language, as '$1', '$2', etc. The single-tick marks MUST be included, as these variables are not \"Standard\" attribute names (attribute names must be quoted unless they contain only numbers, letters, and _).").required(true).defaultValue("$1").addValidator(Validator.VALID).dependsOn(REPLACEMENT_STRATEGY, new AllowableValue[]{REGEX_REPLACE, LITERAL_REPLACE, ALWAYS_REPLACE, PREPEND, APPEND}).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    static final PropertyDescriptor PREPEND_TEXT = new PropertyDescriptor.Builder().name("Text to Prepend").displayName("Text to Prepend").description("The text to prepend to the start of the FlowFile, or each line, depending on teh configured value of the Evaluation Mode property").required(true).addValidator(Validator.VALID).dependsOn(REPLACEMENT_STRATEGY, new AllowableValue[]{SURROUND}).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    static final PropertyDescriptor APPEND_TEXT = new PropertyDescriptor.Builder().name("Text to Append").displayName("Text to Append").description("The text to append to the end of the FlowFile, or each line, depending on teh configured value of the Evaluation Mode property").required(true).addValidator(Validator.VALID).dependsOn(REPLACEMENT_STRATEGY, new AllowableValue[]{SURROUND}).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    public static final PropertyDescriptor CHARACTER_SET = new PropertyDescriptor.Builder().name("Character Set").description("The Character Set in which the file is encoded").required(true).addValidator(StandardValidators.CHARACTER_SET_VALIDATOR).defaultValue("UTF-8").build();
    public static final PropertyDescriptor MAX_BUFFER_SIZE = new PropertyDescriptor.Builder().name("Maximum Buffer Size").description("Specifies the maximum amount of data to buffer (per file or per line, depending on the Evaluation Mode) in order to apply the replacement. If 'Entire Text' (in Evaluation Mode) is selected and the FlowFile is larger than this value, the FlowFile will be routed to 'failure'. In 'Line-by-Line' Mode, if a single line is larger than this value, the FlowFile will be routed to 'failure'. A default value of 1 MB is provided, primarily for 'Entire Text' mode. In 'Line-by-Line' Mode, a value such as 8 KB or 16 KB is suggested. This value is ignored if the <Replacement Strategy> property is set to one of: Append, Prepend, Always Replace").required(true).addValidator(StandardValidators.DATA_SIZE_VALIDATOR).defaultValue("1 MB").build();
    public static final PropertyDescriptor EVALUATION_MODE = new PropertyDescriptor.Builder().name("Evaluation Mode").description("Run the 'Replacement Strategy' against each line separately (Line-by-Line) or buffer the entire file into memory (Entire Text) and run against that.").allowableValues(new String[]{"Line-by-Line", "Entire text"}).defaultValue("Line-by-Line").required(true).build();
    public static final PropertyDescriptor LINE_BY_LINE_EVALUATION_MODE = new PropertyDescriptor.Builder().name("Line-by-Line Evaluation Mode").description("Run the 'Replacement Strategy' against each line separately (Line-by-Line) for all lines in the FlowFile, First Line (Header) alone, Last Line (Footer) alone, Except the First Line (Header) or Except the Last Line (Footer).").allowableValues(new String[]{"All", "First-Line", "Last-Line", "Except-First-Line", "Except-Last-Line"}).defaultValue("All").required(false).build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("FlowFiles that have been successfully processed are routed to this relationship. This includes both FlowFiles that had text replaced and those that did not.").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("FlowFiles that could not be updated are routed to this relationship").build();
    private List<PropertyDescriptor> properties;
    private Set<Relationship> relationships;
    private ReplacementStrategyExecutor replacementStrategyExecutor;

    protected void init(ProcessorInitializationContext context) {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(REPLACEMENT_STRATEGY);
        properties.add(SEARCH_VALUE);
        properties.add(REPLACEMENT_VALUE);
        properties.add(PREPEND_TEXT);
        properties.add(APPEND_TEXT);
        properties.add(CHARACTER_SET);
        properties.add(MAX_BUFFER_SIZE);
        properties.add(EVALUATION_MODE);
        properties.add(LINE_BY_LINE_EVALUATION_MODE);
        this.properties = Collections.unmodifiableList(properties);
        HashSet<Relationship> relationships = new HashSet<Relationship>();
        relationships.add(REL_SUCCESS);
        relationships.add(REL_FAILURE);
        this.relationships = Collections.unmodifiableSet(relationships);
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.properties;
    }

    public Set<Relationship> getRelationships() {
        return this.relationships;
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        ArrayList<ValidationResult> errors = new ArrayList<ValidationResult>(super.customValidate(validationContext));
        switch (validationContext.getProperty(REPLACEMENT_STRATEGY).getValue()) {
            case "Literal Replace": {
                errors.add(StandardValidators.NON_EMPTY_VALIDATOR.validate(SEARCH_VALUE.getName(), validationContext.getProperty(SEARCH_VALUE).getValue(), validationContext));
                break;
            }
            case "Regex Replace": {
                errors.add(StandardValidators.createRegexValidator((int)0, (int)Integer.MAX_VALUE, (boolean)true).validate(SEARCH_VALUE.getName(), validationContext.getProperty(SEARCH_VALUE).getValue(), validationContext));
                break;
            }
        }
        return errors;
    }

    @OnScheduled
    public void setup(ProcessContext context) {
        String replacementStrategy = context.getProperty(REPLACEMENT_STRATEGY).getValue();
        String evaluateMode = context.getProperty(EVALUATION_MODE).getValue();
        switch (replacementStrategy) {
            case "Prepend": {
                this.replacementStrategyExecutor = new PrependReplace();
                break;
            }
            case "Append": {
                this.replacementStrategyExecutor = new SurroundReplace(null, REPLACEMENT_VALUE);
                break;
            }
            case "Surround": {
                this.replacementStrategyExecutor = new SurroundReplace(PREPEND_TEXT, APPEND_TEXT);
                break;
            }
            case "Regex Replace": {
                if (context.getProperty(SEARCH_VALUE).getValue().equals(".*")) {
                    this.replacementStrategyExecutor = new AlwaysReplace();
                    break;
                }
                if (context.getProperty(SEARCH_VALUE).getValue().equals(DEFAULT_REGEX) && evaluateMode.equalsIgnoreCase(ENTIRE_TEXT) && context.getProperty(REPLACEMENT_VALUE).getValue().isEmpty()) {
                    this.replacementStrategyExecutor = new AlwaysReplace();
                    break;
                }
                String regex = context.getProperty(SEARCH_VALUE).evaluateAttributeExpressions().getValue();
                this.replacementStrategyExecutor = new RegexReplace(regex);
                break;
            }
            case "Literal Replace": {
                this.replacementStrategyExecutor = new LiteralReplace();
                break;
            }
            case "Always Replace": {
                this.replacementStrategyExecutor = new AlwaysReplace();
                break;
            }
            case "Substitute Variables": {
                this.replacementStrategyExecutor = new SubstituteVariablesReplace();
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        ComponentLog logger = this.getLogger();
        Charset charset = Charset.forName(context.getProperty(CHARACTER_SET).getValue());
        int maxBufferSize = context.getProperty(MAX_BUFFER_SIZE).asDataSize(DataUnit.B).intValue();
        String evaluateMode = context.getProperty(EVALUATION_MODE).getValue();
        if (evaluateMode.equalsIgnoreCase(ENTIRE_TEXT) && flowFile.getSize() > (long)maxBufferSize && this.replacementStrategyExecutor.isAllDataBufferedForEntireText()) {
            logger.warn("Transferred {} to 'failure' because it was larger than the buffer size");
            session.transfer(flowFile, REL_FAILURE);
            return;
        }
        StopWatch stopWatch = new StopWatch(true);
        try {
            flowFile = this.replacementStrategyExecutor.replace(flowFile, session, context, evaluateMode, charset, maxBufferSize);
        }
        catch (StackOverflowError e) {
            logger.info("Transferred {} to 'failure'", new Object[]{flowFile, e});
            session.transfer(flowFile, REL_FAILURE);
            return;
        }
        catch (BufferOverflowException e) {
            logger.warn("Transferred {} to 'failure'", new Object[]{flowFile, e});
            session.transfer(flowFile, REL_FAILURE);
            return;
        }
        catch (AttributeExpressionLanguageException | IllegalAttributeException e) {
            logger.warn("Transferred {} to 'failure'", new Object[]{flowFile, e});
            session.transfer(flowFile, REL_FAILURE);
            return;
        }
        logger.info("Transferred {} to 'success'", new Object[]{flowFile});
        session.getProvenanceReporter().modifyContent(flowFile, stopWatch.getElapsed(TimeUnit.MILLISECONDS));
        session.transfer(flowFile, REL_SUCCESS);
    }

    private static String escapeLiteralBackReferences(String unescaped, int numCapturingGroups) {
        if (numCapturingGroups == 0) {
            return unescaped;
        }
        String value = unescaped;
        Matcher backRefMatcher = unescapedBackReferencePattern.matcher(value);
        while (backRefMatcher.find()) {
            int originalBackRefIndex;
            int backRefIndex;
            String backRefNum = backRefMatcher.group(1);
            if (backRefNum.startsWith("0")) continue;
            for (backRefIndex = originalBackRefIndex = Integer.parseInt(backRefNum); backRefIndex > numCapturingGroups && backRefIndex >= 10; backRefIndex /= 10) {
            }
            if (backRefIndex <= numCapturingGroups) continue;
            StringBuilder sb = new StringBuilder(value.length() + 1);
            int groupStart = backRefMatcher.start(1);
            sb.append(value, 0, groupStart - 1);
            sb.append("\\");
            sb.append(value.substring(groupStart - 1));
            value = sb.toString();
        }
        return value;
    }

    private static String normalizeReplacementString(String replacement) {
        String replacementFinal = replacement;
        if (REPLACEMENT_NORMALIZATION_PATTERN.matcher(replacement).find()) {
            replacementFinal = Matcher.quoteReplacement(replacement);
        }
        return replacementFinal;
    }

    private static class StreamReplaceCallback
    implements StreamCallback {
        private final Charset charset;
        private final int maxBufferSize;
        private final String lineByLineEvaluationMode;
        private final ReplaceLine replaceLine;

        private StreamReplaceCallback(Charset charset, int maxBufferSize, String lineByLineEvaluationMode, ReplaceLine replaceLine) {
            this.charset = charset;
            this.maxBufferSize = maxBufferSize;
            this.lineByLineEvaluationMode = lineByLineEvaluationMode;
            this.replaceLine = replaceLine;
        }

        public void process(InputStream in, OutputStream out) throws IOException {
            try (LineDemarcator demarcator = new LineDemarcator(in, this.charset, this.maxBufferSize, 8192);
                 BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(out, this.charset));){
                String succeedingLine;
                String precedingLine = demarcator.nextLine();
                boolean firstLine = true;
                while (null != (succeedingLine = demarcator.nextLine())) {
                    if (firstLine && this.lineByLineEvaluationMode.equalsIgnoreCase(ReplaceText.FIRST_LINE)) {
                        this.replaceLine.apply(bw, precedingLine);
                        firstLine = false;
                    } else if (firstLine && this.lineByLineEvaluationMode.equalsIgnoreCase(ReplaceText.EXCEPT_FIRST_LINE)) {
                        firstLine = false;
                        bw.write(precedingLine);
                    } else if (this.lineByLineEvaluationMode.equalsIgnoreCase(ReplaceText.LINE_BY_LINE) || this.lineByLineEvaluationMode.equalsIgnoreCase(ReplaceText.EXCEPT_LAST_LINE) || this.lineByLineEvaluationMode.equalsIgnoreCase(ReplaceText.ALL) || !firstLine && this.lineByLineEvaluationMode.equalsIgnoreCase(ReplaceText.EXCEPT_FIRST_LINE)) {
                        this.replaceLine.apply(bw, precedingLine);
                    } else {
                        bw.write(precedingLine);
                    }
                    precedingLine = succeedingLine;
                }
                if (null != precedingLine) {
                    if (this.lineByLineEvaluationMode.equalsIgnoreCase(ReplaceText.EXCEPT_LAST_LINE) || !firstLine && this.lineByLineEvaluationMode.equalsIgnoreCase(ReplaceText.FIRST_LINE) || firstLine && this.lineByLineEvaluationMode.equalsIgnoreCase(ReplaceText.EXCEPT_FIRST_LINE)) {
                        bw.write(precedingLine);
                    } else {
                        this.replaceLine.apply(bw, precedingLine);
                    }
                }
            }
        }
    }

    @FunctionalInterface
    private static interface ReplaceLine {
        public void apply(BufferedWriter var1, String var2) throws IOException;
    }

    private static interface ReplacementStrategyExecutor {
        public FlowFile replace(FlowFile var1, ProcessSession var2, ProcessContext var3, String var4, Charset var5, int var6);

        public boolean isAllDataBufferedForEntireText();
    }

    private static class SubstituteVariablesReplace
    implements ReplacementStrategyExecutor {
        private SubstituteVariablesReplace() {
        }

        @Override
        public FlowFile replace(FlowFile flowFile, ProcessSession session, ProcessContext context, String evaluateMode, final Charset charset, int maxBufferSize) {
            final Map flowFileAttributes = flowFile.getAttributes();
            if (evaluateMode.equalsIgnoreCase(ReplaceText.ENTIRE_TEXT)) {
                final int flowFileSize = (int)flowFile.getSize();
                int bufferSize = Math.min(maxBufferSize, flowFileSize);
                final byte[] buffer = new byte[bufferSize];
                flowFile = session.write(flowFile, new StreamCallback(){

                    public void process(InputStream in, OutputStream out) throws IOException {
                        StreamUtils.fillBuffer((InputStream)in, (byte[])buffer, (boolean)false);
                        String originalContent = new String(buffer, 0, flowFileSize, charset);
                        String substitutedContent = StringSubstitutor.replace((Object)originalContent, (Map)flowFileAttributes);
                        out.write(substitutedContent.getBytes(charset));
                    }
                });
            } else {
                flowFile = session.write(flowFile, (StreamCallback)new StreamReplaceCallback(charset, maxBufferSize, context.getProperty(LINE_BY_LINE_EVALUATION_MODE).getValue(), (bw, oneLine) -> {
                    String substitutedLine = StringSubstitutor.replace((Object)oneLine, (Map)flowFileAttributes);
                    bw.write(substitutedLine);
                }));
            }
            return flowFile;
        }

        @Override
        public boolean isAllDataBufferedForEntireText() {
            return true;
        }
    }

    private static class LiteralReplace
    implements ReplacementStrategyExecutor {
        private LiteralReplace() {
        }

        @Override
        public FlowFile replace(FlowFile flowFile, ProcessSession session, ProcessContext context, String evaluateMode, final Charset charset, int maxBufferSize) {
            final String replacementValue = context.getProperty(REPLACEMENT_VALUE).evaluateAttributeExpressions(flowFile).getValue();
            final String searchValue = context.getProperty(SEARCH_VALUE).evaluateAttributeExpressions(flowFile).getValue();
            if (evaluateMode.equalsIgnoreCase(ReplaceText.ENTIRE_TEXT)) {
                final int flowFileSize = (int)flowFile.getSize();
                int bufferSize = Math.min(maxBufferSize, flowFileSize);
                final byte[] buffer = new byte[bufferSize];
                flowFile = session.write(flowFile, new StreamCallback(){

                    public void process(InputStream in, OutputStream out) throws IOException {
                        StreamUtils.fillBuffer((InputStream)in, (byte[])buffer, (boolean)false);
                        String contentString = new String(buffer, 0, flowFileSize, charset);
                        String updatedValue = contentString.replace(searchValue, replacementValue);
                        out.write(updatedValue.getBytes(charset));
                    }
                });
            } else {
                Pattern searchPattern = Pattern.compile(searchValue, 16);
                flowFile = session.write(flowFile, (StreamCallback)new StreamReplaceCallback(charset, maxBufferSize, context.getProperty(LINE_BY_LINE_EVALUATION_MODE).getValue(), (bw, oneLine) -> {
                    int matches = 0;
                    int lastEnd = 0;
                    int index = oneLine.indexOf(searchValue, lastEnd);
                    while (index >= 0) {
                        bw.write(oneLine, lastEnd, index - lastEnd);
                        bw.write(replacementValue);
                        ++matches;
                        lastEnd = index + searchValue.length();
                        index = oneLine.indexOf(searchValue, lastEnd);
                    }
                    if (matches > 0) {
                        bw.write(oneLine, lastEnd, oneLine.length() - lastEnd);
                    } else {
                        bw.write(oneLine);
                    }
                }));
            }
            return flowFile;
        }

        @Override
        public boolean isAllDataBufferedForEntireText() {
            return true;
        }
    }

    private static class RegexReplace
    implements ReplacementStrategyExecutor {
        private final int numCapturingGroups;
        private final AttributeValueDecorator escapeBackRefDecorator = new AttributeValueDecorator(){

            public String decorate(String attributeValue) {
                return attributeValue.replaceAll("(\\$\\d+?)", "\\\\$1");
            }
        };

        public RegexReplace(String regex) {
            this.numCapturingGroups = Pattern.compile(regex).matcher("").groupCount();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public FlowFile replace(FlowFile flowFile, ProcessSession session, ProcessContext context, String evaluateMode, Charset charset, int maxBufferSize) {
            AttributeValueDecorator quotedAttributeDecorator = Pattern::quote;
            String searchRegex = context.getProperty(SEARCH_VALUE).evaluateAttributeExpressions(flowFile, quotedAttributeDecorator).getValue();
            Pattern searchPattern = Pattern.compile(searchRegex);
            HashMap<String, String> additionalAttrs = new HashMap<String, String>(this.numCapturingGroups);
            if (evaluateMode.equalsIgnoreCase(ReplaceText.ENTIRE_TEXT)) {
                int flowFileSize = (int)flowFile.getSize();
                int bufferSize = Math.min(maxBufferSize, flowFileSize);
                byte[] buffer = new byte[bufferSize];
                session.read(flowFile, in -> StreamUtils.fillBuffer((InputStream)in, (byte[])buffer, (boolean)false));
                String contentString = new String(buffer, 0, flowFileSize, charset);
                Matcher matcher = searchPattern.matcher(contentString);
                PropertyValue replacementValueProperty = context.getProperty(REPLACEMENT_VALUE);
                int matches = 0;
                StringBuffer sb = new StringBuffer();
                while (matcher.find()) {
                    ++matches;
                    for (int i = 0; i <= matcher.groupCount(); ++i) {
                        additionalAttrs.put("$" + i, matcher.group(i));
                    }
                    String replacement = replacementValueProperty.evaluateAttributeExpressions(flowFile, additionalAttrs, this.escapeBackRefDecorator).getValue();
                    replacement = ReplaceText.escapeLiteralBackReferences(replacement, this.numCapturingGroups);
                    String replacementFinal = ReplaceText.normalizeReplacementString(replacement);
                    matcher.appendReplacement(sb, replacementFinal);
                }
                if (matches <= 0) return flowFile;
                matcher.appendTail(sb);
                String updatedValue = sb.toString();
                return session.write(flowFile, out -> out.write(updatedValue.getBytes(charset)));
            }
            Matcher matcher = searchPattern.matcher("");
            return session.write(flowFile, (StreamCallback)new StreamReplaceCallback(charset, maxBufferSize, context.getProperty(LINE_BY_LINE_EVALUATION_MODE).getValue(), (bw, oneLine) -> {
                matcher.reset(oneLine);
                int matches = 0;
                StringBuffer sb = new StringBuffer();
                while (matcher.find()) {
                    ++matches;
                    for (int i = 0; i <= matcher.groupCount(); ++i) {
                        additionalAttrs.put("$" + i, matcher.group(i));
                    }
                    String replacement = context.getProperty(REPLACEMENT_VALUE).evaluateAttributeExpressions(flowFile, additionalAttrs, this.escapeBackRefDecorator).getValue();
                    replacement = ReplaceText.escapeLiteralBackReferences(replacement, this.numCapturingGroups);
                    String replacementFinal = ReplaceText.normalizeReplacementString(replacement);
                    matcher.appendReplacement(sb, replacementFinal);
                }
                if (matches > 0) {
                    matcher.appendTail(sb);
                    String updatedValue = sb.toString();
                    bw.write(updatedValue);
                } else {
                    bw.write(oneLine);
                }
            }));
        }

        @Override
        public boolean isAllDataBufferedForEntireText() {
            return true;
        }
    }

    private static class SurroundReplace
    implements ReplacementStrategyExecutor {
        private final PropertyDescriptor prependValueDescriptor;
        private final PropertyDescriptor appendValueDescriptor;

        public SurroundReplace(PropertyDescriptor prependValueDescriptor, PropertyDescriptor appendValueDescriptor) {
            this.prependValueDescriptor = prependValueDescriptor;
            this.appendValueDescriptor = appendValueDescriptor;
        }

        @Override
        public FlowFile replace(FlowFile flowFile, ProcessSession session, ProcessContext context, String evaluateMode, final Charset charset, int maxBufferSize) {
            final String prependValue = this.prependValueDescriptor == null ? null : context.getProperty(this.prependValueDescriptor).evaluateAttributeExpressions(flowFile).getValue();
            final String appendValue = context.getProperty(this.appendValueDescriptor).evaluateAttributeExpressions(flowFile).getValue();
            flowFile = evaluateMode.equalsIgnoreCase(ReplaceText.ENTIRE_TEXT) ? session.write(flowFile, new StreamCallback(){

                public void process(InputStream in, OutputStream out) throws IOException {
                    if (prependValue != null && !prependValue.isEmpty()) {
                        out.write(prependValue.getBytes(charset));
                    }
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                    out.write(appendValue.getBytes(charset));
                }
            }) : session.write(flowFile, (StreamCallback)new StreamReplaceCallback(charset, maxBufferSize, context.getProperty(LINE_BY_LINE_EVALUATION_MODE).getValue(), (bw, oneLine) -> {
                if (prependValue != null && !prependValue.isEmpty()) {
                    bw.write(prependValue);
                }
                boolean foundNewLine = false;
                for (int i = 0; i < oneLine.length(); ++i) {
                    char c = oneLine.charAt(i);
                    if (foundNewLine) {
                        bw.write(c);
                        continue;
                    }
                    if (c == '\r' || c == '\n') {
                        bw.write(appendValue);
                        foundNewLine = true;
                    }
                    bw.write(c);
                }
                if (!foundNewLine) {
                    bw.write(appendValue);
                }
            }));
            return flowFile;
        }

        @Override
        public boolean isAllDataBufferedForEntireText() {
            return false;
        }
    }

    private static class PrependReplace
    implements ReplacementStrategyExecutor {
        private PrependReplace() {
        }

        @Override
        public FlowFile replace(FlowFile flowFile, ProcessSession session, ProcessContext context, String evaluateMode, final Charset charset, int maxBufferSize) {
            final String replacementValue = context.getProperty(REPLACEMENT_VALUE).evaluateAttributeExpressions(flowFile).getValue();
            flowFile = evaluateMode.equalsIgnoreCase(ReplaceText.ENTIRE_TEXT) ? session.write(flowFile, new StreamCallback(){

                public void process(InputStream in, OutputStream out) throws IOException {
                    out.write(replacementValue.getBytes(charset));
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                }
            }) : session.write(flowFile, (StreamCallback)new StreamReplaceCallback(charset, maxBufferSize, context.getProperty(LINE_BY_LINE_EVALUATION_MODE).getValue(), (bw, oneLine) -> bw.write(replacementValue.concat(oneLine))));
            return flowFile;
        }

        @Override
        public boolean isAllDataBufferedForEntireText() {
            return false;
        }
    }

    private static class AlwaysReplace
    implements ReplacementStrategyExecutor {
        private AlwaysReplace() {
        }

        @Override
        public FlowFile replace(FlowFile flowFile, ProcessSession session, ProcessContext context, String evaluateMode, Charset charset, int maxBufferSize) {
            String replacementValue = context.getProperty(REPLACEMENT_VALUE).evaluateAttributeExpressions(flowFile).getValue();
            StringBuilder lineEndingBuilder = new StringBuilder(2);
            flowFile = evaluateMode.equalsIgnoreCase(ReplaceText.ENTIRE_TEXT) ? session.write(flowFile, out -> out.write(replacementValue.getBytes(charset))) : session.write(flowFile, (StreamCallback)new StreamReplaceCallback(charset, maxBufferSize, context.getProperty(LINE_BY_LINE_EVALUATION_MODE).getValue(), (bw, oneLine) -> {
                char c;
                lineEndingBuilder.setLength(0);
                for (int i = oneLine.length() - 1; i >= 0 && ((c = oneLine.charAt(i)) == '\r' || c == '\n'); --i) {
                    lineEndingBuilder.append(c);
                }
                bw.write(replacementValue);
                bw.write(lineEndingBuilder.reverse().toString());
            }));
            return flowFile;
        }

        @Override
        public boolean isAllDataBufferedForEntireText() {
            return false;
        }
    }
}

