/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.db.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.processors.standard.db.ColumnDescription;
import org.apache.nifi.processors.standard.db.DatabaseAdapter;

public class MSSQLDatabaseAdapter
implements DatabaseAdapter {
    @Override
    public String getName() {
        return "MS SQL 2012+";
    }

    @Override
    public String getDescription() {
        return "Generates MS SQL Compatible SQL, for version 2012 or greater";
    }

    @Override
    public String getSelectStatement(String tableName, String columnNames, String whereClause, String orderByClause, Long limit, Long offset) {
        return this.getSelectStatement(tableName, columnNames, whereClause, orderByClause, limit, offset, null);
    }

    @Override
    public String getSelectStatement(String tableName, String columnNames, String whereClause, String orderByClause, Long limit, Long offset, String columnForPartitioning) {
        if (StringUtils.isEmpty((CharSequence)tableName)) {
            throw new IllegalArgumentException("Table name cannot be null or empty");
        }
        StringBuilder query = new StringBuilder("SELECT ");
        if (limit != null && offset == null && StringUtils.isEmpty((CharSequence)columnForPartitioning)) {
            query.append("TOP ");
            query.append(limit);
            query.append(" ");
        }
        if (StringUtils.isEmpty((CharSequence)columnNames) || columnNames.trim().equals("*")) {
            query.append("*");
        } else {
            query.append(columnNames);
        }
        query.append(" FROM ");
        query.append(tableName);
        if (!StringUtils.isEmpty((CharSequence)whereClause)) {
            query.append(" WHERE ");
            query.append(whereClause);
            if (!StringUtils.isEmpty((CharSequence)columnForPartitioning)) {
                query.append(" AND ");
                query.append(columnForPartitioning);
                query.append(" >= ");
                query.append(offset != null ? offset : "0");
                if (limit != null) {
                    query.append(" AND ");
                    query.append(columnForPartitioning);
                    query.append(" < ");
                    query.append((offset == null ? 0L : offset) + limit);
                }
            }
        }
        if (!StringUtils.isEmpty((CharSequence)orderByClause) && StringUtils.isEmpty((CharSequence)columnForPartitioning)) {
            query.append(" ORDER BY ");
            query.append(orderByClause);
        }
        if (StringUtils.isEmpty((CharSequence)columnForPartitioning) && offset != null && limit != null && limit > 0L) {
            if (StringUtils.isEmpty((CharSequence)orderByClause)) {
                throw new IllegalArgumentException("Order by clause cannot be null or empty when using row paging");
            }
            query.append(" OFFSET ");
            query.append(offset);
            query.append(" ROWS");
            query.append(" FETCH NEXT ");
            query.append(limit);
            query.append(" ROWS ONLY");
        }
        return query.toString();
    }

    @Override
    public String unwrapIdentifier(String identifier) {
        return identifier == null ? null : identifier.replaceAll("[\"\\[\\]]", "");
    }

    @Override
    public List<String> getAlterTableStatements(String tableName, List<ColumnDescription> columnsToAdd, boolean quoteTableName, boolean quoteColumnNames) {
        ArrayList<String> columnsAndDatatypes = new ArrayList<String>(columnsToAdd.size());
        for (ColumnDescription column : columnsToAdd) {
            String dataType = this.getSQLForDataType(column.getDataType());
            StringBuilder sb = new StringBuilder("ADD ").append(quoteColumnNames ? this.getColumnQuoteString() : "").append(column.getColumnName()).append(quoteColumnNames ? this.getColumnQuoteString() : "").append(" ").append(dataType);
            columnsAndDatatypes.add(sb.toString());
        }
        StringBuilder alterTableStatement = new StringBuilder();
        return Collections.singletonList(alterTableStatement.append("ALTER TABLE ").append(quoteTableName ? this.getTableQuoteString() : "").append(tableName).append(quoteTableName ? this.getTableQuoteString() : "").append(" ").append(String.join((CharSequence)", ", columnsAndDatatypes)).toString());
    }
}

