/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.http;

import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.apache.nifi.processors.standard.http.CertificateAttribute;
import org.apache.nifi.processors.standard.http.CertificateAttributesProvider;
import org.apache.nifi.security.cert.CertificateAttributeReader;
import org.apache.nifi.security.cert.StandardCertificateAttributeReader;
import org.apache.nifi.security.cert.SubjectAlternativeName;

public class HandleHttpRequestCertificateAttributesProvider
implements CertificateAttributesProvider {
    protected static final String REQUEST_CERTIFICATES_ATTRIBUTE_NAME = "javax.servlet.request.X509Certificate";
    private static final String SAN_NAME_TYPE_FORMAT = "%s.%d.nameType";
    private static final String SAN_NAME_FORMAT = "%s.%d.name";
    private final CertificateAttributeReader certificateAttributeReader = new StandardCertificateAttributeReader();

    @Override
    public Map<String, String> getCertificateAttributes(HttpServletRequest request) {
        Map<String, String> attributes;
        Objects.requireNonNull(request, "HTTP Servlet Request required");
        Object requestCertificates = request.getAttribute(REQUEST_CERTIFICATES_ATTRIBUTE_NAME);
        if (requestCertificates instanceof X509Certificate[]) {
            X509Certificate[] certificates = (X509Certificate[])requestCertificates;
            if (certificates.length == 0) {
                attributes = Collections.emptyMap();
            } else {
                X509Certificate clientCertificate = certificates[0];
                attributes = this.getCertificateAttributes(clientCertificate);
            }
        } else {
            attributes = Collections.emptyMap();
        }
        return attributes;
    }

    private Map<String, String> getCertificateAttributes(X509Certificate certificate) {
        LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
        String subjectPrincipal = certificate.getSubjectX500Principal().getName();
        String issuerPrincipal = certificate.getIssuerX500Principal().getName();
        attributes.put(CertificateAttribute.HTTP_SUBJECT_DN.getName(), subjectPrincipal);
        attributes.put(CertificateAttribute.HTTP_ISSUER_DN.getName(), issuerPrincipal);
        Map<String, String> subjectAlternativeNameAttributes = this.getSubjectAlternativeNameAttributes(certificate);
        attributes.putAll(subjectAlternativeNameAttributes);
        return attributes;
    }

    private Map<String, String> getSubjectAlternativeNameAttributes(X509Certificate certificate) {
        LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
        int subjectAlternativeNameIndex = 0;
        List subjectAlternativeNames = this.certificateAttributeReader.getSubjectAlternativeNames(certificate);
        for (SubjectAlternativeName subjectAlternativeName : subjectAlternativeNames) {
            String nameTypeAttributeKey = String.format(SAN_NAME_TYPE_FORMAT, CertificateAttribute.HTTP_CERTIFICATE_SANS.getName(), subjectAlternativeNameIndex);
            String generalNameType = subjectAlternativeName.getGeneralNameType().getGeneralName();
            attributes.put(nameTypeAttributeKey, generalNameType);
            String nameAttributeKey = String.format(SAN_NAME_FORMAT, CertificateAttribute.HTTP_CERTIFICATE_SANS.getName(), subjectAlternativeNameIndex);
            String serializedName = subjectAlternativeName.getName();
            attributes.put(nameAttributeKey, serializedName);
            ++subjectAlternativeNameIndex;
        }
        return attributes;
    }
}

