/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.reporting.ganglia;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import com.yammer.metrics.reporting.GangliaReporter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.controller.status.ProcessGroupStatus;
import org.apache.nifi.controller.status.ProcessorStatus;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.reporting.AbstractReportingTask;
import org.apache.nifi.reporting.InitializationException;
import org.apache.nifi.reporting.ReportingContext;

@Tags(value={"ganglia", "stats"})
@CapabilityDescription(value="Reports metrics to Ganglia so that Ganglia can be used for external monitoring of the application. Metrics reported include JVM Metrics (optional); the following 5-minute NiFi statistics: FlowFiles Received, Bytes Received, FlowFiles Sent, Bytes Sent, Bytes Read, Bytes Written, Total Task Duration; and the current values for FlowFiles Queued, Bytes Queued, and number of Active Threads.")
public class StandardGangliaReporter
extends AbstractReportingTask {
    public static final PropertyDescriptor HOSTNAME = new PropertyDescriptor.Builder().name("Hostname").description("The fully-qualified name of the host on which Ganglia is running").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).defaultValue("localhost").build();
    public static final PropertyDescriptor PORT = new PropertyDescriptor.Builder().name("Port").description("The Port on which Ganglia is listening for incoming connections").required(true).addValidator(StandardValidators.PORT_VALIDATOR).defaultValue("8649").build();
    public static final PropertyDescriptor SEND_JVM_METRICS = new PropertyDescriptor.Builder().name("Send JVM Metrics").description("Specifies whether or not JVM Metrics should be gathered and sent, in addition to NiFi-specific metrics").required(true).allowableValues(new String[]{"true", "false"}).defaultValue("false").build();
    public static final String METRICS_GROUP = "NiFi";
    private MetricsRegistry metricsRegistry;
    private GangliaReporter gangliaReporter;
    private final AtomicReference<ProcessGroupStatus> latestStatus = new AtomicReference();

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(HOSTNAME);
        properties.add(PORT);
        properties.add(SEND_JVM_METRICS);
        return properties;
    }

    @OnScheduled
    public void onConfigure(ConfigurationContext config) throws InitializationException {
        this.metricsRegistry = new MetricsRegistry();
        this.metricsRegistry.newGauge(new MetricName(METRICS_GROUP, "int32", "FlowFiles Received Last 5 mins"), (Gauge)new Gauge<Integer>(){

            public Integer value() {
                ProcessGroupStatus status = (ProcessGroupStatus)StandardGangliaReporter.this.latestStatus.get();
                if (status == null) {
                    return 0;
                }
                Integer value = status.getFlowFilesReceived();
                return value == null ? 0 : value;
            }
        });
        this.metricsRegistry.newGauge(new MetricName(METRICS_GROUP, "int64", "Bytes Received Last 5 mins"), (Gauge)new Gauge<Long>(){

            public Long value() {
                ProcessGroupStatus status = (ProcessGroupStatus)StandardGangliaReporter.this.latestStatus.get();
                if (status == null) {
                    return 0L;
                }
                return status.getBytesReceived();
            }
        });
        this.metricsRegistry.newGauge(new MetricName(METRICS_GROUP, "int32", "FlowFiles Sent Last 5 mins"), (Gauge)new Gauge<Integer>(){

            public Integer value() {
                ProcessGroupStatus status = (ProcessGroupStatus)StandardGangliaReporter.this.latestStatus.get();
                if (status == null) {
                    return 0;
                }
                return status.getFlowFilesSent();
            }
        });
        this.metricsRegistry.newGauge(new MetricName(METRICS_GROUP, "int64", "Bytes Sent Last 5 mins"), (Gauge)new Gauge<Long>(){

            public Long value() {
                ProcessGroupStatus status = (ProcessGroupStatus)StandardGangliaReporter.this.latestStatus.get();
                if (status == null) {
                    return 0L;
                }
                return status.getBytesSent();
            }
        });
        this.metricsRegistry.newGauge(new MetricName(METRICS_GROUP, "int32", "FlowFiles Queued"), (Gauge)new Gauge<Integer>(){

            public Integer value() {
                ProcessGroupStatus status = (ProcessGroupStatus)StandardGangliaReporter.this.latestStatus.get();
                if (status == null) {
                    return 0;
                }
                Integer value = status.getQueuedCount();
                return value == null ? 0 : value;
            }
        });
        this.metricsRegistry.newGauge(new MetricName(METRICS_GROUP, "int64", "Bytes Queued"), (Gauge)new Gauge<Long>(){

            public Long value() {
                ProcessGroupStatus status = (ProcessGroupStatus)StandardGangliaReporter.this.latestStatus.get();
                if (status == null) {
                    return 0L;
                }
                Long value = status.getQueuedContentSize();
                return value == null ? 0L : value;
            }
        });
        this.metricsRegistry.newGauge(new MetricName(METRICS_GROUP, "int64", "Bytes Read (5 mins)"), (Gauge)new Gauge<Long>(){

            public Long value() {
                ProcessGroupStatus status = (ProcessGroupStatus)StandardGangliaReporter.this.latestStatus.get();
                if (status == null) {
                    return 0L;
                }
                Long value = status.getBytesRead();
                return value == null ? 0L : value;
            }
        });
        this.metricsRegistry.newGauge(new MetricName(METRICS_GROUP, "int64", "Bytes Written (5 mins)"), (Gauge)new Gauge<Long>(){

            public Long value() {
                ProcessGroupStatus status = (ProcessGroupStatus)StandardGangliaReporter.this.latestStatus.get();
                if (status == null) {
                    return 0L;
                }
                Long value = status.getBytesWritten();
                return value == null ? 0L : value;
            }
        });
        this.metricsRegistry.newGauge(new MetricName(METRICS_GROUP, "int32", "Active Threads"), (Gauge)new Gauge<Integer>(){

            public Integer value() {
                ProcessGroupStatus status = (ProcessGroupStatus)StandardGangliaReporter.this.latestStatus.get();
                if (status == null) {
                    return 0;
                }
                Integer value = status.getActiveThreadCount();
                return value == null ? 0 : value;
            }
        });
        this.metricsRegistry.newGauge(new MetricName(METRICS_GROUP, "int32", "Total Task Duration Seconds"), (Gauge)new Gauge<Integer>(){

            public Integer value() {
                ProcessGroupStatus status = (ProcessGroupStatus)StandardGangliaReporter.this.latestStatus.get();
                if (status == null) {
                    return 0;
                }
                long nanos = StandardGangliaReporter.this.calculateProcessingNanos(status);
                return (int)TimeUnit.NANOSECONDS.toSeconds(nanos);
            }
        });
        String gangliaHost = config.getProperty(HOSTNAME).getValue();
        int port = config.getProperty(PORT).asInteger();
        try {
            this.gangliaReporter = new GangliaReporter(this.metricsRegistry, gangliaHost, port, METRICS_GROUP){

                protected String sanitizeName(MetricName name) {
                    return name.getName();
                }
            };
            this.gangliaReporter.printVMMetrics = config.getProperty(SEND_JVM_METRICS).asBoolean();
        }
        catch (IOException e) {
            throw new InitializationException((Throwable)e);
        }
    }

    public void onTrigger(ReportingContext context) {
        ProcessGroupStatus rootGroupStatus = context.getEventAccess().getControllerStatus();
        this.latestStatus.set(rootGroupStatus);
        this.gangliaReporter.run();
        this.getLogger().info("{} Sent metrics to Ganglia", new Object[]{this});
    }

    private long calculateProcessingNanos(ProcessGroupStatus status) {
        long nanos = 0L;
        for (ProcessorStatus procStats : status.getProcessorStatus()) {
            nanos += procStats.getProcessingNanos();
        }
        for (ProcessGroupStatus childGroupStatus : status.getProcessGroupStatus()) {
            nanos += this.calculateProcessingNanos(childGroupStatus);
        }
        return nanos;
    }
}

