/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.remote.io.socket;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class NetworkUtils {
    public static final int availablePort() {
        ServerSocket s = null;
        try {
            s = new ServerSocket(0);
            s.setReuseAddress(true);
            int n = s.getLocalPort();
            return n;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to discover available port.", e);
        }
        finally {
            try {
                s.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final boolean isListening(String hostname, int port) {
        try (Socket s = new Socket(hostname, port);){
            boolean bl = s.isConnected();
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean isListening(String hostname, int port, int timeoutMillis) {
        Boolean result = false;
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try {
            result = executor.submit(() -> {
                while (!NetworkUtils.isListening(hostname, port)) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception exception) {}
                }
                return true;
            }).get(timeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (Exception exception) {
        }
        finally {
            try {
                executor.shutdown();
            }
            catch (Exception exception) {}
        }
        return result != null && result != false;
    }
}

