/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.remote.io.socket;

import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.SocketChannel;
import java.util.concurrent.TimeUnit;

public class SocketChannelOutputStream
extends OutputStream {
    private static final long CHANNEL_FULL_WAIT_NANOS = TimeUnit.NANOSECONDS.convert(1L, TimeUnit.MILLISECONDS);
    private final SocketChannel channel;
    private volatile int timeout = 30000;
    private final ByteBuffer oneByteBuffer = ByteBuffer.allocate(1);

    public SocketChannelOutputStream(SocketChannel socketChannel) throws IOException {
        socketChannel.configureBlocking(false);
        this.channel = socketChannel;
    }

    public void setTimeout(int timeoutMillis) {
        this.timeout = timeoutMillis;
    }

    @Override
    public void write(int b) throws IOException {
        this.oneByteBuffer.flip();
        this.oneByteBuffer.clear();
        this.oneByteBuffer.put((byte)b);
        this.oneByteBuffer.flip();
        int timeoutMillis = this.timeout;
        long maxTime = System.currentTimeMillis() + (long)timeoutMillis;
        long sleepNanos = 1L;
        while (this.oneByteBuffer.hasRemaining()) {
            int bytesWritten = this.channel.write(this.oneByteBuffer);
            if (bytesWritten == 0) {
                if (System.currentTimeMillis() > maxTime) {
                    throw new SocketTimeoutException("Timed out writing to socket");
                }
                try {
                    TimeUnit.NANOSECONDS.sleep(sleepNanos);
                }
                catch (InterruptedException e) {
                    this.close();
                    Thread.currentThread().interrupt();
                    throw new ClosedByInterruptException();
                }
                sleepNanos = Math.min(sleepNanos * 2L, CHANNEL_FULL_WAIT_NANOS);
                continue;
            }
            return;
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        ByteBuffer buffer = ByteBuffer.wrap(b, off, len);
        int timeoutMillis = this.timeout;
        long maxTime = System.currentTimeMillis() + (long)timeoutMillis;
        long sleepNanos = 1L;
        while (buffer.hasRemaining()) {
            int bytesWritten = this.channel.write(buffer);
            if (bytesWritten == 0) {
                if (System.currentTimeMillis() > maxTime) {
                    throw new SocketTimeoutException("Timed out writing to socket");
                }
                try {
                    TimeUnit.NANOSECONDS.sleep(sleepNanos);
                }
                catch (InterruptedException e) {
                    this.close();
                    Thread.currentThread().interrupt();
                    throw new ClosedByInterruptException();
                }
                sleepNanos = Math.min(sleepNanos * 2L, CHANNEL_FULL_WAIT_NANOS);
                continue;
            }
            maxTime = System.currentTimeMillis() + (long)timeoutMillis;
        }
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }
}

