/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util;

import java.lang.runtime.SwitchBootstraps;
import java.text.NumberFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.nifi.processor.DataUnit;
import org.apache.nifi.time.DurationFormat;

public class FormatUtils {
    public static final String TIME_DURATION_REGEX = DurationFormat.TIME_DURATION_REGEX;
    public static final Pattern TIME_DURATION_PATTERN = DurationFormat.TIME_DURATION_PATTERN;
    private static final LocalDate EPOCH_INITIAL_DATE = LocalDate.of(1970, 1, 1);

    public static String formatCount(long count) {
        return NumberFormat.getIntegerInstance().format(count);
    }

    public static String formatMinutesSeconds(long sourceDuration, TimeUnit sourceUnit) {
        long millis = TimeUnit.MILLISECONDS.convert(sourceDuration, sourceUnit);
        long millisInMinute = TimeUnit.MILLISECONDS.convert(1L, TimeUnit.MINUTES);
        int minutes = (int)(millis / millisInMinute);
        long secondsMillisLeft = millis - (long)minutes * millisInMinute;
        long millisInSecond = TimeUnit.MILLISECONDS.convert(1L, TimeUnit.SECONDS);
        int seconds = (int)(secondsMillisLeft / millisInSecond);
        long millisLeft = secondsMillisLeft - (long)seconds * millisInSecond;
        return FormatUtils.pad2Places(minutes) + ":" + FormatUtils.pad2Places(seconds) + "." + FormatUtils.pad3Places(millisLeft);
    }

    public static String formatHoursMinutesSeconds(long sourceDuration, TimeUnit sourceUnit) {
        long millis = TimeUnit.MILLISECONDS.convert(sourceDuration, sourceUnit);
        long millisInHour = TimeUnit.MILLISECONDS.convert(1L, TimeUnit.HOURS);
        int hours = (int)(millis / millisInHour);
        long minutesSecondsMillisLeft = millis - (long)hours * millisInHour;
        return FormatUtils.pad2Places(hours) + ":" + FormatUtils.formatMinutesSeconds(minutesSecondsMillisLeft, TimeUnit.MILLISECONDS);
    }

    private static String pad2Places(long val) {
        return val < 10L ? "0" + val : String.valueOf(val);
    }

    private static String pad3Places(long val) {
        return val < 100L ? "0" + FormatUtils.pad2Places(val) : String.valueOf(val);
    }

    public static String formatDataSize(double dataSize) {
        NumberFormat format = NumberFormat.getNumberInstance();
        format.setMaximumFractionDigits(2);
        double dataSizeToFormat = DataUnit.B.toTB(dataSize);
        if (dataSizeToFormat > 1.0) {
            return format.format(dataSizeToFormat) + " TB";
        }
        dataSizeToFormat = DataUnit.B.toGB(dataSize);
        if (dataSizeToFormat > 1.0) {
            return format.format(dataSizeToFormat) + " GB";
        }
        dataSizeToFormat = DataUnit.B.toMB(dataSize);
        if (dataSizeToFormat > 1.0) {
            return format.format(dataSizeToFormat) + " MB";
        }
        dataSizeToFormat = DataUnit.B.toKB(dataSize);
        if (dataSizeToFormat > 1.0) {
            return format.format(dataSizeToFormat) + " KB";
        }
        return format.format(dataSize) + " bytes";
    }

    public static long getTimeDuration(String value, TimeUnit desiredUnit) {
        return DurationFormat.getTimeDuration((String)value, (TimeUnit)desiredUnit);
    }

    public static double getPreciseTimeDuration(String value, TimeUnit desiredUnit) {
        return DurationFormat.getPreciseTimeDuration((String)value, (TimeUnit)desiredUnit);
    }

    public static String formatUtilization(double utilization) {
        return utilization + "%";
    }

    public static DateTimeFormatter prepareLenientCaseInsensitiveDateTimeFormatter(String pattern) {
        return new DateTimeFormatterBuilder().parseLenient().parseCaseInsensitive().appendPattern(pattern).toFormatter(Locale.US);
    }

    public static String formatNanos(long nanos, boolean includeTotalNanos) {
        StringBuilder sb = new StringBuilder();
        long seconds = nanos >= 1000000000L ? nanos / 1000000000L : 0L;
        long millis = nanos >= 1000000L ? nanos / 1000000L : 0L;
        long nanosLeft = nanos % 1000000L;
        if (seconds > 0L) {
            sb.append(seconds).append(" seconds");
        }
        if (millis > 0L) {
            if (seconds > 0L) {
                sb.append(", ");
                millis -= seconds * 1000L;
            }
            sb.append(millis).append(" millis");
        }
        if (seconds > 0L || millis > 0L) {
            sb.append(", ");
        }
        sb.append(nanosLeft).append(" nanos");
        if (includeTotalNanos) {
            sb.append(" (").append(nanos).append(" nanos)");
        }
        return sb.toString();
    }

    public static Instant parseToInstant(DateTimeFormatter formatter, String text) {
        TemporalAccessor parsed;
        if (text == null) {
            throw new IllegalArgumentException("Text cannot be null");
        }
        TemporalAccessor temporalAccessor = parsed = formatter.parseBest(text, Instant::from, LocalDateTime::from, LocalDate::from, YearMonth::from, Year::from, LocalTime::from);
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Instant.class, LocalDateTime.class, LocalDate.class, YearMonth.class, Year.class}, (Object)temporalAccessor, n)) {
            case 0 -> {
                Instant instant;
                yield instant = (Instant)temporalAccessor;
            }
            case 1 -> {
                LocalDateTime localDateTime = (LocalDateTime)temporalAccessor;
                yield FormatUtils.toInstantInSystemDefaultTimeZone(localDateTime);
            }
            case 2 -> {
                LocalDate localDate = (LocalDate)temporalAccessor;
                yield FormatUtils.toInstantInSystemDefaultTimeZone(localDate.atTime(0, 0));
            }
            case 3 -> {
                YearMonth yearMonth = (YearMonth)temporalAccessor;
                yield FormatUtils.toInstantInSystemDefaultTimeZone(yearMonth.atDay(1).atTime(0, 0));
            }
            case 4 -> {
                Year year = (Year)temporalAccessor;
                yield FormatUtils.toInstantInSystemDefaultTimeZone(year.atDay(1).atTime(0, 0));
            }
            default -> FormatUtils.toInstantInSystemDefaultTimeZone(((LocalTime)parsed).atDate(EPOCH_INITIAL_DATE));
        };
    }

    private static Instant toInstantInSystemDefaultTimeZone(LocalDateTime dateTime) {
        return dateTime.atZone(ZoneId.systemDefault()).toInstant();
    }
}

