/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.provenance;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import org.apache.nifi.authorization.AccessDeniedException;
import org.apache.nifi.authorization.AuthorizationResult;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.events.EventReporter;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.processor.DataUnit;
import org.apache.nifi.provenance.AsyncLineageSubmission;
import org.apache.nifi.provenance.AsyncQuerySubmission;
import org.apache.nifi.provenance.IdentifierLookup;
import org.apache.nifi.provenance.ProvenanceAuthorizableFactory;
import org.apache.nifi.provenance.ProvenanceEventBuilder;
import org.apache.nifi.provenance.ProvenanceEventRecord;
import org.apache.nifi.provenance.ProvenanceEventRepository;
import org.apache.nifi.provenance.ProvenanceEventType;
import org.apache.nifi.provenance.ProvenanceRepository;
import org.apache.nifi.provenance.SearchableFieldParser;
import org.apache.nifi.provenance.SearchableFields;
import org.apache.nifi.provenance.StandardLineageResult;
import org.apache.nifi.provenance.StandardProvenanceEventRecord;
import org.apache.nifi.provenance.StandardQueryResult;
import org.apache.nifi.provenance.lineage.ComputeLineageSubmission;
import org.apache.nifi.provenance.lineage.FlowFileLineage;
import org.apache.nifi.provenance.lineage.Lineage;
import org.apache.nifi.provenance.lineage.LineageComputationType;
import org.apache.nifi.provenance.search.Query;
import org.apache.nifi.provenance.search.QueryResult;
import org.apache.nifi.provenance.search.QuerySubmission;
import org.apache.nifi.provenance.search.SearchTerm;
import org.apache.nifi.provenance.search.SearchableField;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.util.RingBuffer;
import org.apache.nifi.web.ResourceNotFoundException;

public class VolatileProvenanceRepository
implements ProvenanceRepository {
    public static final String BUFFER_SIZE = "nifi.provenance.repository.buffer.size";
    public static final int DEFAULT_BUFFER_SIZE = 10000;
    public static String CONTAINER_NAME = "in-memory";
    private final RingBuffer<ProvenanceEventRecord> ringBuffer;
    private final int maxSize;
    private final List<SearchableField> searchableFields;
    private final List<SearchableField> searchableAttributes;
    private final ExecutorService queryExecService;
    private final ScheduledExecutorService scheduledExecService;
    private final ConcurrentMap<String, AsyncQuerySubmission> querySubmissionMap = new ConcurrentHashMap<String, AsyncQuerySubmission>();
    private final ConcurrentMap<String, AsyncLineageSubmission> lineageSubmissionMap = new ConcurrentHashMap<String, AsyncLineageSubmission>();
    private final AtomicLong idGenerator = new AtomicLong(0L);
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private Authorizer authorizer;
    private ProvenanceAuthorizableFactory resourceFactory;

    public VolatileProvenanceRepository() {
        this.ringBuffer = null;
        this.searchableFields = null;
        this.searchableAttributes = null;
        this.queryExecService = null;
        this.scheduledExecService = null;
        this.authorizer = null;
        this.resourceFactory = null;
        this.maxSize = 10000;
    }

    public VolatileProvenanceRepository(NiFiProperties nifiProperties) {
        this.maxSize = nifiProperties.getIntegerProperty(BUFFER_SIZE, Integer.valueOf(10000));
        this.ringBuffer = new RingBuffer(this.maxSize);
        String indexedFieldString = nifiProperties.getProperty("nifi.provenance.repository.indexed.fields");
        String indexedAttrString = nifiProperties.getProperty("nifi.provenance.repository.indexed.attributes");
        this.searchableFields = Collections.unmodifiableList(SearchableFieldParser.extractSearchableFields((String)indexedFieldString, (boolean)true));
        this.searchableAttributes = Collections.unmodifiableList(SearchableFieldParser.extractSearchableFields((String)indexedAttrString, (boolean)false));
        final ThreadFactory defaultThreadFactory = Executors.defaultThreadFactory();
        this.queryExecService = Executors.newFixedThreadPool(2, new ThreadFactory(){
            private final AtomicInteger counter = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = defaultThreadFactory.newThread(r);
                thread.setName("Provenance Query Thread-" + this.counter.incrementAndGet());
                return thread;
            }
        });
        this.scheduledExecService = Executors.newScheduledThreadPool(2);
    }

    public void initialize(EventReporter eventReporter, Authorizer authorizer, ProvenanceAuthorizableFactory resourceFactory, IdentifierLookup idLookup) throws IOException {
        if (this.initialized.getAndSet(true)) {
            return;
        }
        this.authorizer = authorizer;
        this.resourceFactory = resourceFactory;
        this.scheduledExecService.scheduleWithFixedDelay(new RemoveExpiredQueryResults(), 30L, 30L, TimeUnit.SECONDS);
    }

    public ProvenanceEventRepository getProvenanceEventRepository() {
        return this;
    }

    public ProvenanceEventBuilder eventBuilder() {
        return new StandardProvenanceEventRecord.Builder();
    }

    public void registerEvent(ProvenanceEventRecord event) {
        long id = this.idGenerator.getAndIncrement();
        this.ringBuffer.add((Object)new IdEnrichedProvEvent(event, id));
    }

    public void registerEvents(Iterable<ProvenanceEventRecord> events) {
        for (ProvenanceEventRecord event : events) {
            this.registerEvent(event);
        }
    }

    public List<ProvenanceEventRecord> getEvents(long firstRecordId, int maxRecords) throws IOException {
        return this.getEvents(firstRecordId, maxRecords, null);
    }

    public List<ProvenanceEventRecord> getEvents(final long firstRecordId, int maxRecords, final NiFiUser user) throws IOException {
        return this.ringBuffer.getSelectedElements((RingBuffer.Filter)new RingBuffer.Filter<ProvenanceEventRecord>(){

            public boolean select(ProvenanceEventRecord value) {
                if (!VolatileProvenanceRepository.this.isAuthorized(value, user)) {
                    return false;
                }
                return value.getEventId() >= firstRecordId;
            }
        }, maxRecords);
    }

    public Long getMaxEventId() {
        ProvenanceEventRecord newest = (ProvenanceEventRecord)this.ringBuffer.getNewestElement();
        return newest == null ? null : Long.valueOf(newest.getEventId());
    }

    public ProvenanceEventRecord getEvent(final String identifier) throws IOException {
        List records = this.ringBuffer.getSelectedElements((RingBuffer.Filter)new RingBuffer.Filter<ProvenanceEventRecord>(){

            public boolean select(ProvenanceEventRecord event) {
                return identifier.equals(event.getFlowFileUuid());
            }
        }, 1);
        return records.isEmpty() ? null : (ProvenanceEventRecord)records.get(0);
    }

    public ProvenanceEventRecord getEvent(final long id) {
        List records = this.ringBuffer.getSelectedElements((RingBuffer.Filter)new RingBuffer.Filter<ProvenanceEventRecord>(){

            public boolean select(ProvenanceEventRecord event) {
                return event.getEventId() == id;
            }
        }, 1);
        return records.isEmpty() ? null : (ProvenanceEventRecord)records.get(0);
    }

    public ProvenanceEventRecord getEvent(long id, NiFiUser user) {
        ProvenanceEventRecord event = this.getEvent(id);
        if (event == null) {
            return null;
        }
        this.authorize(event, user);
        return event;
    }

    public void close() throws IOException {
        this.queryExecService.shutdownNow();
        this.scheduledExecService.shutdown();
    }

    public List<SearchableField> getSearchableFields() {
        return this.searchableFields;
    }

    public List<SearchableField> getSearchableAttributes() {
        return this.searchableAttributes;
    }

    public QueryResult queryEvents(Query query, NiFiUser user) throws IOException {
        QuerySubmission submission = this.submitQuery(query, user);
        QueryResult result = submission.getResult();
        while (!result.isFinished()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (result.getError() != null) {
            throw new IOException(result.getError());
        }
        return result;
    }

    public boolean isAuthorized(ProvenanceEventRecord event, NiFiUser user) {
        Authorizable eventAuthorizable;
        if (this.authorizer == null || user == null) {
            return true;
        }
        try {
            eventAuthorizable = this.resourceFactory.createProvenanceDataAuthorizable(event.getComponentId());
        }
        catch (ResourceNotFoundException rnfe) {
            return false;
        }
        AuthorizationResult result = eventAuthorizable.checkAuthorization(this.authorizer, RequestAction.READ, user);
        return AuthorizationResult.Result.Approved.equals((Object)result.getResult());
    }

    protected void authorize(ProvenanceEventRecord event, NiFiUser user) {
        if (this.authorizer == null || user == null) {
            return;
        }
        Authorizable eventAuthorizable = this.resourceFactory.createProvenanceDataAuthorizable(event.getComponentId());
        eventAuthorizable.authorize(this.authorizer, RequestAction.READ, user);
    }

    private RingBuffer.Filter<ProvenanceEventRecord> createFilter(final Query query, final NiFiUser user) {
        return new RingBuffer.Filter<ProvenanceEventRecord>(){

            public boolean select(ProvenanceEventRecord event) {
                if (!VolatileProvenanceRepository.this.isAuthorized(event, user)) {
                    return false;
                }
                if (query.getStartDate() != null && query.getStartDate().getTime() > event.getEventTime()) {
                    return false;
                }
                if (query.getEndDate() != null && query.getEndDate().getTime() < event.getEventTime()) {
                    return false;
                }
                if (query.getMaxFileSize() != null) {
                    long maxFileSize = DataUnit.parseDataSize((String)query.getMaxFileSize(), (DataUnit)DataUnit.B).longValue();
                    if (event.getFileSize() > maxFileSize) {
                        return false;
                    }
                }
                if (query.getMinFileSize() != null) {
                    long minFileSize = DataUnit.parseDataSize((String)query.getMinFileSize(), (DataUnit)DataUnit.B).longValue();
                    if (event.getFileSize() < minFileSize) {
                        return false;
                    }
                }
                for (SearchTerm searchTerm : query.getSearchTerms()) {
                    String regex;
                    Pattern pattern;
                    SearchableField searchableField = searchTerm.getSearchableField();
                    String searchValue = searchTerm.getValue();
                    if (searchableField.isAttribute()) {
                        String attributeName = searchableField.getIdentifier();
                        String eventAttributeValue = (String)event.getAttributes().get(attributeName);
                        if (searchValue.contains("?") || searchValue.contains("*")) {
                            if (eventAttributeValue == null || eventAttributeValue.isEmpty()) {
                                return false;
                            }
                            String regex2 = searchValue.replace("?", ".").replace("*", ".*");
                            Pattern pattern2 = Pattern.compile(regex2, 2);
                            if (pattern2.matcher(eventAttributeValue).matches()) continue;
                            return false;
                        }
                        if (searchValue.equalsIgnoreCase(eventAttributeValue)) continue;
                        return false;
                    }
                    if (searchableField.equals(SearchableFields.FlowFileUUID)) {
                        if (searchValue.contains("?") || searchValue.contains("*")) {
                            String regex3 = searchValue.replace("?", ".").replace("*", ".*");
                            Pattern pattern3 = Pattern.compile(regex3, 2);
                            if (pattern3.matcher(event.getFlowFileUuid()).matches()) continue;
                            boolean found = false;
                            for (String uuid : event.getParentUuids()) {
                                if (!pattern3.matcher(uuid).matches()) continue;
                                found = true;
                                break;
                            }
                            for (String uuid : event.getChildUuids()) {
                                if (!pattern3.matcher(uuid).matches()) continue;
                                found = true;
                                break;
                            }
                            if (found) {
                                continue;
                            }
                        } else if (event.getFlowFileUuid().equals(searchValue) || event.getParentUuids().contains(searchValue) || event.getChildUuids().contains(searchValue)) continue;
                        return false;
                    }
                    Object fieldValue = VolatileProvenanceRepository.this.getFieldValue(event, searchableField);
                    if (fieldValue == null) {
                        return false;
                    }
                    if (!(searchValue.contains("?") || searchValue.contains("*") ? !(pattern = Pattern.compile(regex = searchValue.replace("?", ".").replace("*", ".*"), 2)).matcher(String.valueOf(fieldValue)).matches() : !searchValue.equalsIgnoreCase(String.valueOf(fieldValue)))) continue;
                    return false;
                }
                return true;
            }
        };
    }

    private Object getFieldValue(ProvenanceEventRecord record, SearchableField field) {
        if (SearchableFields.AlternateIdentifierURI.equals(field)) {
            return record.getAlternateIdentifierUri();
        }
        if (SearchableFields.ComponentID.equals(field)) {
            return record.getComponentId();
        }
        if (SearchableFields.Details.equals(field)) {
            return record.getDetails();
        }
        if (SearchableFields.EventTime.equals(field)) {
            return record.getEventTime();
        }
        if (SearchableFields.EventType.equals(field)) {
            return record.getEventType();
        }
        if (SearchableFields.Filename.equals(field)) {
            return record.getAttributes().get(CoreAttributes.FILENAME.key());
        }
        if (SearchableFields.FileSize.equals(field)) {
            return record.getFileSize();
        }
        if (SearchableFields.FlowFileUUID.equals(field)) {
            return record.getFlowFileUuid();
        }
        if (SearchableFields.LineageStartDate.equals(field)) {
            return record.getLineageStartDate();
        }
        if (SearchableFields.Relationship.equals(field)) {
            return record.getRelationship();
        }
        if (SearchableFields.TransitURI.equals(field)) {
            return record.getTransitUri();
        }
        return null;
    }

    public QuerySubmission submitQuery(Query query, NiFiUser user) {
        String userId;
        if (query.getEndDate() != null && query.getStartDate() != null && query.getStartDate().getTime() > query.getEndDate().getTime()) {
            throw new IllegalArgumentException("Query End Time cannot be before Query Start Time");
        }
        String string = userId = user == null ? null : user.getIdentity();
        if (query.getSearchTerms().isEmpty() && query.getStartDate() == null && query.getEndDate() == null) {
            AsyncQuerySubmission result = new AsyncQuerySubmission(query, 1, userId);
            this.queryExecService.submit(new QueryRunnable(this.ringBuffer, this.createFilter(query, user), query.getMaxResults(), result));
            this.querySubmissionMap.put(query.getIdentifier(), result);
            return result;
        }
        AsyncQuerySubmission result = new AsyncQuerySubmission(query, 1, userId);
        this.querySubmissionMap.put(query.getIdentifier(), result);
        this.queryExecService.submit(new QueryRunnable(this.ringBuffer, this.createFilter(query, user), query.getMaxResults(), result));
        return result;
    }

    public QuerySubmission retrieveQuerySubmission(String queryIdentifier, NiFiUser user) {
        QuerySubmission submission = (QuerySubmission)this.querySubmissionMap.get(queryIdentifier);
        String userId = submission.getSubmitterIdentity();
        if (user == null && userId == null) {
            return submission;
        }
        if (user == null) {
            throw new AccessDeniedException("Cannot retrieve Provenance Query Submission because no user id was provided in the provenance request.");
        }
        if (userId == null || userId.equals(user.getIdentity())) {
            return submission;
        }
        throw new AccessDeniedException("Cannot retrieve Provenance Query Submission because " + user.getIdentity() + " is not the user who submitted the request.");
    }

    public Lineage computeLineage(String flowFileUUID, NiFiUser user) throws IOException {
        return this.computeLineage(Collections.singleton(flowFileUUID), user, LineageComputationType.FLOWFILE_LINEAGE, null);
    }

    private Lineage computeLineage(Collection<String> flowFileUuids, NiFiUser user, LineageComputationType computationType, Long eventId) throws IOException {
        AsyncLineageSubmission submission = this.submitLineageComputation(flowFileUuids, user, computationType, eventId);
        StandardLineageResult result = submission.getResult();
        while (!result.isFinished()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (result.getError() != null) {
            throw new IOException(result.getError());
        }
        return new FlowFileLineage((Collection)result.getNodes(), (Collection)result.getEdges());
    }

    public ComputeLineageSubmission submitLineageComputation(long eventId, NiFiUser user) {
        ProvenanceEventRecord event = this.getEvent(eventId);
        if (event == null) {
            String userId = user == null ? null : user.getIdentity();
            AsyncLineageSubmission result = new AsyncLineageSubmission(LineageComputationType.FLOWFILE_LINEAGE, Long.valueOf(eventId), Collections.emptySet(), 1, userId);
            result.getResult().setError("Could not find event with ID " + eventId);
            this.lineageSubmissionMap.put(result.getLineageIdentifier(), result);
            return result;
        }
        return this.submitLineageComputation(Collections.singleton(event.getFlowFileUuid()), user, LineageComputationType.FLOWFILE_LINEAGE, eventId);
    }

    public AsyncLineageSubmission submitLineageComputation(String flowFileUuid, NiFiUser user) {
        return this.submitLineageComputation(Collections.singleton(flowFileUuid), user, LineageComputationType.FLOWFILE_LINEAGE, null);
    }

    public ComputeLineageSubmission retrieveLineageSubmission(String lineageIdentifier, NiFiUser user) {
        ComputeLineageSubmission submission = (ComputeLineageSubmission)this.lineageSubmissionMap.get(lineageIdentifier);
        String userId = submission.getSubmitterIdentity();
        if (user == null && userId == null) {
            return submission;
        }
        if (user == null) {
            throw new AccessDeniedException("Cannot retrieve Provenance Lineage Submission because no user id was provided in the lineage request.");
        }
        if (userId == null || userId.equals(user.getIdentity())) {
            return submission;
        }
        throw new AccessDeniedException("Cannot retrieve Provenance Lineage Submission because " + user.getIdentity() + " is not the user who submitted the request.");
    }

    public Lineage expandSpawnEventParents(String identifier) throws IOException {
        throw new UnsupportedOperationException();
    }

    public ComputeLineageSubmission submitExpandParents(long eventId, NiFiUser user) {
        String userId = user == null ? null : user.getIdentity();
        ProvenanceEventRecord event = this.getEvent(eventId, user);
        if (event == null) {
            AsyncLineageSubmission submission = new AsyncLineageSubmission(LineageComputationType.EXPAND_PARENTS, Long.valueOf(eventId), Collections.emptyList(), 1, userId);
            this.lineageSubmissionMap.put(submission.getLineageIdentifier(), submission);
            submission.getResult().update(Collections.emptyList(), 0L);
            return submission;
        }
        switch (event.getEventType()) {
            case JOIN: 
            case FORK: 
            case REPLAY: 
            case CLONE: {
                return this.submitLineageComputation(event.getParentUuids(), user, LineageComputationType.EXPAND_PARENTS, eventId);
            }
        }
        AsyncLineageSubmission submission = new AsyncLineageSubmission(LineageComputationType.EXPAND_PARENTS, Long.valueOf(eventId), Collections.emptyList(), 1, userId);
        this.lineageSubmissionMap.put(submission.getLineageIdentifier(), submission);
        submission.getResult().setError("Event ID " + eventId + " indicates an event of type " + event.getEventType() + " so its parents cannot be expanded");
        return submission;
    }

    public Lineage expandSpawnEventChildren(String identifier) {
        throw new UnsupportedOperationException();
    }

    public ComputeLineageSubmission submitExpandChildren(long eventId, NiFiUser user) {
        String userId = user == null ? null : user.getIdentity();
        ProvenanceEventRecord event = this.getEvent(eventId, user);
        if (event == null) {
            AsyncLineageSubmission submission = new AsyncLineageSubmission(LineageComputationType.EXPAND_CHILDREN, Long.valueOf(eventId), Collections.emptyList(), 1, userId);
            this.lineageSubmissionMap.put(submission.getLineageIdentifier(), submission);
            submission.getResult().update(Collections.emptyList(), 0L);
            return submission;
        }
        switch (event.getEventType()) {
            case JOIN: 
            case FORK: 
            case REPLAY: 
            case CLONE: {
                return this.submitLineageComputation(event.getChildUuids(), user, LineageComputationType.EXPAND_CHILDREN, eventId);
            }
        }
        AsyncLineageSubmission submission = new AsyncLineageSubmission(LineageComputationType.EXPAND_CHILDREN, Long.valueOf(eventId), Collections.emptyList(), 1, userId);
        this.lineageSubmissionMap.put(submission.getLineageIdentifier(), submission);
        submission.getResult().setError("Event ID " + eventId + " indicates an event of type " + event.getEventType() + " so its children cannot be expanded");
        return submission;
    }

    public long getContainerCapacity(String containerName) throws IOException {
        return this.maxSize;
    }

    public Set<String> getContainerNames() {
        return Collections.singleton(CONTAINER_NAME);
    }

    public long getContainerUsableSpace(String containerName) throws IOException {
        return this.maxSize - this.ringBuffer.getSize();
    }

    public String getContainerFileStoreName(String containerName) {
        return null;
    }

    private AsyncLineageSubmission submitLineageComputation(final Collection<String> flowFileUuids, final NiFiUser user, LineageComputationType computationType, Long eventId) {
        String userId = user == null ? null : user.getIdentity();
        AsyncLineageSubmission result = new AsyncLineageSubmission(computationType, eventId, flowFileUuids, 1, userId);
        this.lineageSubmissionMap.put(result.getLineageIdentifier(), result);
        RingBuffer.Filter<ProvenanceEventRecord> filter = new RingBuffer.Filter<ProvenanceEventRecord>(){

            public boolean select(ProvenanceEventRecord event) {
                if (!VolatileProvenanceRepository.this.isAuthorized(event, user)) {
                    return false;
                }
                if (flowFileUuids.contains(event.getFlowFileUuid())) {
                    return true;
                }
                for (String parentId : event.getParentUuids()) {
                    if (!flowFileUuids.contains(parentId)) continue;
                    return true;
                }
                for (String childId : event.getChildUuids()) {
                    if (!flowFileUuids.contains(childId)) continue;
                    return true;
                }
                return false;
            }
        };
        this.queryExecService.submit(new ComputeLineageRunnable(this.ringBuffer, filter, result));
        return result;
    }

    private static class IdEnrichedProvEvent
    implements ProvenanceEventRecord {
        private final ProvenanceEventRecord record;
        private final long id;

        public IdEnrichedProvEvent(ProvenanceEventRecord record, long id) {
            this.record = record;
            this.id = id;
        }

        public long getEventId() {
            return this.id;
        }

        public long getEventTime() {
            return this.record.getEventTime();
        }

        public long getFlowFileEntryDate() {
            return this.record.getFlowFileEntryDate();
        }

        public long getLineageStartDate() {
            return this.record.getLineageStartDate();
        }

        public long getFileSize() {
            return this.record.getFileSize();
        }

        public Long getPreviousFileSize() {
            return this.record.getPreviousFileSize();
        }

        public long getEventDuration() {
            return this.record.getEventDuration();
        }

        public ProvenanceEventType getEventType() {
            return this.record.getEventType();
        }

        public Map<String, String> getAttributes() {
            return this.record.getAttributes();
        }

        public Map<String, String> getPreviousAttributes() {
            return this.record.getPreviousAttributes();
        }

        public Map<String, String> getUpdatedAttributes() {
            return this.record.getUpdatedAttributes();
        }

        public String getComponentId() {
            return this.record.getComponentId();
        }

        public String getComponentType() {
            return this.record.getComponentType();
        }

        public String getTransitUri() {
            return this.record.getTransitUri();
        }

        public String getSourceSystemFlowFileIdentifier() {
            return this.record.getSourceSystemFlowFileIdentifier();
        }

        public String getFlowFileUuid() {
            return this.record.getFlowFileUuid();
        }

        public List<String> getParentUuids() {
            return this.record.getParentUuids();
        }

        public List<String> getChildUuids() {
            return this.record.getChildUuids();
        }

        public String getAlternateIdentifierUri() {
            return this.record.getAlternateIdentifierUri();
        }

        public String getDetails() {
            return this.record.getDetails();
        }

        public String getRelationship() {
            return this.record.getRelationship();
        }

        public String getSourceQueueIdentifier() {
            return this.record.getSourceQueueIdentifier();
        }

        public String getContentClaimSection() {
            return this.record.getContentClaimSection();
        }

        public String getPreviousContentClaimSection() {
            return this.record.getPreviousContentClaimSection();
        }

        public String getContentClaimContainer() {
            return this.record.getContentClaimContainer();
        }

        public String getPreviousContentClaimContainer() {
            return this.record.getPreviousContentClaimContainer();
        }

        public String getContentClaimIdentifier() {
            return this.record.getContentClaimIdentifier();
        }

        public String getPreviousContentClaimIdentifier() {
            return this.record.getPreviousContentClaimIdentifier();
        }

        public Long getContentClaimOffset() {
            return this.record.getContentClaimOffset();
        }

        public Long getPreviousContentClaimOffset() {
            return this.record.getPreviousContentClaimOffset();
        }

        public String getBestEventIdentifier() {
            return Long.toString(this.getEventId());
        }
    }

    private class RemoveExpiredQueryResults
    implements Runnable {
        private RemoveExpiredQueryResults() {
        }

        @Override
        public void run() {
            Date now = new Date();
            for (Map.Entry entry : VolatileProvenanceRepository.this.querySubmissionMap.entrySet()) {
                StandardQueryResult result = ((AsyncQuerySubmission)entry.getValue()).getResult();
                if (!result.isFinished() || !result.getExpiration().before(now)) continue;
                VolatileProvenanceRepository.this.querySubmissionMap.remove(entry.getKey());
            }
            for (Map.Entry entry : VolatileProvenanceRepository.this.lineageSubmissionMap.entrySet()) {
                StandardLineageResult result = ((AsyncLineageSubmission)entry.getValue()).getResult();
                if (!result.isFinished() || !result.getExpiration().before(now)) continue;
                VolatileProvenanceRepository.this.querySubmissionMap.remove(entry.getKey());
            }
        }
    }

    private static class ComputeLineageRunnable
    implements Runnable {
        private final RingBuffer<ProvenanceEventRecord> ringBuffer;
        private final RingBuffer.Filter<ProvenanceEventRecord> filter;
        private final AsyncLineageSubmission submission;

        public ComputeLineageRunnable(RingBuffer<ProvenanceEventRecord> ringBuffer, RingBuffer.Filter<ProvenanceEventRecord> filter, AsyncLineageSubmission submission) {
            this.ringBuffer = ringBuffer;
            this.filter = filter;
            this.submission = submission;
        }

        @Override
        public void run() {
            List records = this.ringBuffer.getSelectedElements(this.filter);
            this.submission.getResult().update((Collection)records, (long)records.size());
        }
    }

    private static class QueryRunnable
    implements Runnable {
        private final RingBuffer<ProvenanceEventRecord> ringBuffer;
        private final RingBuffer.Filter<ProvenanceEventRecord> filter;
        private final AsyncQuerySubmission submission;
        private final int maxRecords;

        public QueryRunnable(RingBuffer<ProvenanceEventRecord> ringBuffer, RingBuffer.Filter<ProvenanceEventRecord> filter, int maxRecords, AsyncQuerySubmission submission) {
            this.ringBuffer = ringBuffer;
            this.filter = filter;
            this.submission = submission;
            this.maxRecords = maxRecords;
        }

        @Override
        public void run() {
            final AtomicInteger matchingCount = new AtomicInteger(0);
            final ArrayList matchingRecords = new ArrayList(this.maxRecords);
            this.ringBuffer.forEach((RingBuffer.ForEachEvaluator)new RingBuffer.ForEachEvaluator<ProvenanceEventRecord>(){

                public boolean evaluate(ProvenanceEventRecord record) {
                    if (filter.select((Object)record) && matchingCount.incrementAndGet() <= maxRecords) {
                        matchingRecords.add(record);
                    }
                    return true;
                }
            }, RingBuffer.IterationDirection.BACKWARD);
            this.submission.getResult().update(matchingRecords, (long)matchingCount.get());
        }
    }
}

