/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.client.impl;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationIntrospector;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.registry.bucket.BucketItem;
import org.apache.nifi.registry.client.BucketClient;
import org.apache.nifi.registry.client.BundleClient;
import org.apache.nifi.registry.client.BundleVersionClient;
import org.apache.nifi.registry.client.ExtensionClient;
import org.apache.nifi.registry.client.ExtensionRepoClient;
import org.apache.nifi.registry.client.FlowClient;
import org.apache.nifi.registry.client.FlowSnapshotClient;
import org.apache.nifi.registry.client.ItemsClient;
import org.apache.nifi.registry.client.NiFiRegistryClient;
import org.apache.nifi.registry.client.NiFiRegistryClientConfig;
import org.apache.nifi.registry.client.UserClient;
import org.apache.nifi.registry.client.impl.BucketItemDeserializer;
import org.apache.nifi.registry.client.impl.JerseyBucketClient;
import org.apache.nifi.registry.client.impl.JerseyBundleClient;
import org.apache.nifi.registry.client.impl.JerseyBundleVersionClient;
import org.apache.nifi.registry.client.impl.JerseyExtensionClient;
import org.apache.nifi.registry.client.impl.JerseyExtensionRepoClient;
import org.apache.nifi.registry.client.impl.JerseyFlowClient;
import org.apache.nifi.registry.client.impl.JerseyFlowSnapshotClient;
import org.apache.nifi.registry.client.impl.JerseyItemsClient;
import org.apache.nifi.registry.client.impl.JerseyUserClient;
import org.apache.nifi.registry.security.util.ProxiedEntitiesUtils;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.RequestEntityProcessing;
import org.glassfish.jersey.jackson.internal.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import org.glassfish.jersey.media.multipart.MultiPartFeature;

public class JerseyNiFiRegistryClient
implements NiFiRegistryClient {
    static final String NIFI_REGISTRY_CONTEXT = "nifi-registry-api";
    static final int DEFAULT_CONNECT_TIMEOUT = 10000;
    static final int DEFAULT_READ_TIMEOUT = 10000;
    private final Client client;
    private final WebTarget baseTarget;
    private final BucketClient bucketClient;
    private final FlowClient flowClient;
    private final FlowSnapshotClient flowSnapshotClient;
    private final ItemsClient itemsClient;

    private JerseyNiFiRegistryClient(NiFiRegistryClient.Builder builder) {
        NiFiRegistryClientConfig registryClientConfig = builder.getConfig();
        if (registryClientConfig == null) {
            throw new IllegalArgumentException("NiFiRegistryClientConfig cannot be null");
        }
        String baseUrl = registryClientConfig.getBaseUrl();
        if (StringUtils.isBlank((CharSequence)baseUrl)) {
            throw new IllegalArgumentException("Base URL cannot be blank");
        }
        if (baseUrl.endsWith("/")) {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1);
        }
        if (!baseUrl.endsWith(NIFI_REGISTRY_CONTEXT)) {
            baseUrl = baseUrl + "/" + NIFI_REGISTRY_CONTEXT;
        }
        try {
            new URI(baseUrl);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid base URL: " + e.getMessage(), e);
        }
        SSLContext sslContext = registryClientConfig.getSslContext();
        HostnameVerifier hostnameVerifier = registryClientConfig.getHostnameVerifier();
        ClientBuilder clientBuilder = ClientBuilder.newBuilder();
        if (sslContext != null) {
            clientBuilder.sslContext(sslContext);
        }
        if (hostnameVerifier != null) {
            clientBuilder.hostnameVerifier(hostnameVerifier);
        }
        int connectTimeout = registryClientConfig.getConnectTimeout() == null ? 10000 : registryClientConfig.getConnectTimeout();
        int readTimeout = registryClientConfig.getReadTimeout() == null ? 10000 : registryClientConfig.getReadTimeout();
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.property("jersey.config.client.connectTimeout", (Object)connectTimeout);
        clientConfig.property("jersey.config.client.readTimeout", (Object)readTimeout);
        clientConfig.property("jersey.config.client.request.entity.processing", (Object)RequestEntityProcessing.CHUNKED);
        clientConfig.register((Object)JerseyNiFiRegistryClient.jacksonJaxbJsonProvider());
        clientBuilder.withConfig((Configuration)clientConfig);
        this.client = ((ClientBuilder)clientBuilder.register(MultiPartFeature.class)).build();
        this.baseTarget = this.client.target(baseUrl);
        this.bucketClient = new JerseyBucketClient(this.baseTarget);
        this.flowClient = new JerseyFlowClient(this.baseTarget);
        this.flowSnapshotClient = new JerseyFlowSnapshotClient(this.baseTarget);
        this.itemsClient = new JerseyItemsClient(this.baseTarget);
    }

    @Override
    public BucketClient getBucketClient() {
        return this.bucketClient;
    }

    @Override
    public FlowClient getFlowClient() {
        return this.flowClient;
    }

    @Override
    public FlowSnapshotClient getFlowSnapshotClient() {
        return this.flowSnapshotClient;
    }

    @Override
    public ItemsClient getItemsClient() {
        return this.itemsClient;
    }

    @Override
    public BucketClient getBucketClient(String ... proxiedEntity) {
        Map<String, String> headers = this.getHeaders(proxiedEntity);
        return new JerseyBucketClient(this.baseTarget, headers);
    }

    @Override
    public FlowClient getFlowClient(String ... proxiedEntity) {
        Map<String, String> headers = this.getHeaders(proxiedEntity);
        return new JerseyFlowClient(this.baseTarget, headers);
    }

    @Override
    public FlowSnapshotClient getFlowSnapshotClient(String ... proxiedEntity) {
        Map<String, String> headers = this.getHeaders(proxiedEntity);
        return new JerseyFlowSnapshotClient(this.baseTarget, headers);
    }

    @Override
    public ItemsClient getItemsClient(String ... proxiedEntity) {
        Map<String, String> headers = this.getHeaders(proxiedEntity);
        return new JerseyItemsClient(this.baseTarget, headers);
    }

    @Override
    public UserClient getUserClient() {
        return new JerseyUserClient(this.baseTarget);
    }

    @Override
    public UserClient getUserClient(String ... proxiedEntity) {
        Map<String, String> headers = this.getHeaders(proxiedEntity);
        return new JerseyUserClient(this.baseTarget, headers);
    }

    @Override
    public BundleClient getBundleClient() {
        return new JerseyBundleClient(this.baseTarget);
    }

    @Override
    public BundleClient getBundleClient(String ... proxiedEntity) {
        Map<String, String> headers = this.getHeaders(proxiedEntity);
        return new JerseyBundleClient(this.baseTarget, headers);
    }

    @Override
    public BundleVersionClient getBundleVersionClient() {
        return new JerseyBundleVersionClient(this.baseTarget);
    }

    @Override
    public BundleVersionClient getBundleVersionClient(String ... proxiedEntity) {
        Map<String, String> headers = this.getHeaders(proxiedEntity);
        return new JerseyBundleVersionClient(this.baseTarget, headers);
    }

    @Override
    public ExtensionRepoClient getExtensionRepoClient() {
        return new JerseyExtensionRepoClient(this.baseTarget);
    }

    @Override
    public ExtensionClient getExtensionClient() {
        return new JerseyExtensionClient(this.baseTarget);
    }

    @Override
    public ExtensionClient getExtensionClient(String ... proxiedEntity) {
        Map<String, String> headers = this.getHeaders(proxiedEntity);
        return new JerseyExtensionClient(this.baseTarget, headers);
    }

    @Override
    public ExtensionRepoClient getExtensionRepoClient(String ... proxiedEntity) {
        Map<String, String> headers = this.getHeaders(proxiedEntity);
        return new JerseyExtensionRepoClient(this.baseTarget, headers);
    }

    private Map<String, String> getHeaders(String[] proxiedEntities) {
        String proxiedEntitiesValue = this.getProxiedEntitesValue(proxiedEntities);
        HashMap<String, String> headers = new HashMap<String, String>();
        if (proxiedEntitiesValue != null) {
            headers.put("X-ProxiedEntitiesChain", proxiedEntitiesValue);
        }
        return headers;
    }

    private String getProxiedEntitesValue(String[] proxiedEntities) {
        if (proxiedEntities == null) {
            return null;
        }
        List proxiedEntityChain = Arrays.stream(proxiedEntities).map(ProxiedEntitiesUtils::formatProxyDn).collect(Collectors.toList());
        return StringUtils.join(proxiedEntityChain, (String)"");
    }

    @Override
    public void close() throws IOException {
        if (this.client != null) {
            try {
                this.client.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static JacksonJaxbJsonProvider jacksonJaxbJsonProvider() {
        JacksonJaxbJsonProvider jacksonJaxbJsonProvider = new JacksonJaxbJsonProvider();
        ObjectMapper mapper = new ObjectMapper();
        mapper.setPropertyInclusion(JsonInclude.Value.construct((JsonInclude.Include)JsonInclude.Include.NON_NULL, (JsonInclude.Include)JsonInclude.Include.NON_NULL));
        mapper.setAnnotationIntrospector((AnnotationIntrospector)new JaxbAnnotationIntrospector(mapper.getTypeFactory()));
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        SimpleModule module = new SimpleModule();
        module.addDeserializer(BucketItem[].class, (JsonDeserializer)new BucketItemDeserializer());
        mapper.registerModule((Module)module);
        jacksonJaxbJsonProvider.setMapper(mapper);
        return jacksonJaxbJsonProvider;
    }

    public static class Builder
    implements NiFiRegistryClient.Builder {
        private NiFiRegistryClientConfig clientConfig;

        @Override
        public Builder config(NiFiRegistryClientConfig clientConfig) {
            this.clientConfig = clientConfig;
            return this;
        }

        @Override
        public NiFiRegistryClientConfig getConfig() {
            return this.clientConfig;
        }

        @Override
        public NiFiRegistryClient build() {
            return new JerseyNiFiRegistryClient(this);
        }
    }
}

