/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.flow;

import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Set;
import org.apache.nifi.registry.flow.ComponentType;
import org.apache.nifi.registry.flow.ConnectableComponent;
import org.apache.nifi.registry.flow.Position;
import org.apache.nifi.registry.flow.VersionedComponent;

public class VersionedConnection
extends VersionedComponent {
    private ConnectableComponent source;
    private ConnectableComponent destination;
    private Integer labelIndex;
    private Long zIndex;
    private Set<String> selectedRelationships;
    private Long backPressureObjectThreshold;
    private String backPressureDataSizeThreshold;
    private String flowFileExpiration;
    private List<String> prioritizers;
    private List<Position> bends;

    @ApiModelProperty(value="The source of the connection.")
    public ConnectableComponent getSource() {
        return this.source;
    }

    public void setSource(ConnectableComponent source) {
        this.source = source;
    }

    @ApiModelProperty(value="The destination of the connection.")
    public ConnectableComponent getDestination() {
        return this.destination;
    }

    public void setDestination(ConnectableComponent destination) {
        this.destination = destination;
    }

    @ApiModelProperty(value="The bend points on the connection.")
    public List<Position> getBends() {
        return this.bends;
    }

    public void setBends(List<Position> bends) {
        this.bends = bends;
    }

    @ApiModelProperty(value="The index of the bend point where to place the connection label.")
    public Integer getLabelIndex() {
        return this.labelIndex;
    }

    public void setLabelIndex(Integer labelIndex) {
        this.labelIndex = labelIndex;
    }

    @ApiModelProperty(value="The z index of the connection.", name="zIndex")
    public Long getzIndex() {
        return this.zIndex;
    }

    public void setzIndex(Long zIndex) {
        this.zIndex = zIndex;
    }

    @ApiModelProperty(value="The selected relationship that comprise the connection.")
    public Set<String> getSelectedRelationships() {
        return this.selectedRelationships;
    }

    public void setSelectedRelationships(Set<String> relationships) {
        this.selectedRelationships = relationships;
    }

    @ApiModelProperty(value="The object count threshold for determining when back pressure is applied. Updating this value is a passive change in the sense that it won't impact whether existing files over the limit are affected but it does help feeder processors to stop pushing too much into this work queue.")
    public Long getBackPressureObjectThreshold() {
        return this.backPressureObjectThreshold;
    }

    public void setBackPressureObjectThreshold(Long backPressureObjectThreshold) {
        this.backPressureObjectThreshold = backPressureObjectThreshold;
    }

    @ApiModelProperty(value="The object data size threshold for determining when back pressure is applied. Updating this value is a passive change in the sense that it won't impact whether existing files over the limit are affected but it does help feeder processors to stop pushing too much into this work queue.")
    public String getBackPressureDataSizeThreshold() {
        return this.backPressureDataSizeThreshold;
    }

    public void setBackPressureDataSizeThreshold(String backPressureDataSizeThreshold) {
        this.backPressureDataSizeThreshold = backPressureDataSizeThreshold;
    }

    @ApiModelProperty(value="The amount of time a flow file may be in the flow before it will be automatically aged out of the flow. Once a flow file reaches this age it will be terminated from the flow the next time a processor attempts to start work on it.")
    public String getFlowFileExpiration() {
        return this.flowFileExpiration;
    }

    public void setFlowFileExpiration(String flowFileExpiration) {
        this.flowFileExpiration = flowFileExpiration;
    }

    @ApiModelProperty(value="The comparators used to prioritize the queue.")
    public List<String> getPrioritizers() {
        return this.prioritizers;
    }

    public void setPrioritizers(List<String> prioritizers) {
        this.prioritizers = prioritizers;
    }

    @Override
    public ComponentType getComponentType() {
        return ComponentType.CONNECTION;
    }
}

