/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.flow;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.nifi.registry.bucket.Bucket;
import org.apache.nifi.registry.flow.VersionedFlow;
import org.apache.nifi.registry.flow.VersionedFlowSnapshotMetadata;
import org.apache.nifi.registry.flow.VersionedProcessGroup;

@ApiModel(value="versionedFlowSnapshot")
@XmlRootElement
public class VersionedFlowSnapshot {
    @Valid
    @NotNull
    private VersionedFlowSnapshotMetadata snapshotMetadata;
    @Valid
    @NotNull
    private VersionedProcessGroup flowContents;
    private VersionedFlow flow;
    private Bucket bucket;

    @ApiModelProperty(value="The metadata for this snapshot", required=true)
    public VersionedFlowSnapshotMetadata getSnapshotMetadata() {
        return this.snapshotMetadata;
    }

    public void setSnapshotMetadata(VersionedFlowSnapshotMetadata snapshotMetadata) {
        this.snapshotMetadata = snapshotMetadata;
    }

    @ApiModelProperty(value="The contents of the versioned flow", required=true)
    public VersionedProcessGroup getFlowContents() {
        return this.flowContents;
    }

    public void setFlowContents(VersionedProcessGroup flowContents) {
        this.flowContents = flowContents;
    }

    @ApiModelProperty(value="The flow this snapshot is for", readOnly=true)
    public VersionedFlow getFlow() {
        return this.flow;
    }

    public void setFlow(VersionedFlow flow) {
        this.flow = flow;
    }

    @ApiModelProperty(value="The bucket where the flow is located", readOnly=true)
    public Bucket getBucket() {
        return this.bucket;
    }

    public void setBucket(Bucket bucket) {
        this.bucket = bucket;
    }

    @XmlTransient
    public boolean isLatest() {
        return this.flow != null && this.snapshotMetadata != null && this.flow.getVersionCount() == (long)this.getSnapshotMetadata().getVersion();
    }

    public int hashCode() {
        return Objects.hash(this.snapshotMetadata);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VersionedFlowSnapshot other = (VersionedFlowSnapshot)obj;
        return Objects.equals(this.snapshotMetadata, other.snapshotMetadata);
    }

    public String toString() {
        String flowName = this.flow == null ? "null" : this.flow.getName();
        return "VersionedFlowSnapshot[flowId=" + this.snapshotMetadata.getFlowIdentifier() + ", flowName=" + flowName + ", version=" + this.snapshotMetadata.getVersion() + ", comments=" + this.snapshotMetadata.getComments() + "]";
    }
}

